/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSharedDirectoriesRequest extends DirectoryRequest implements
        ToCopyableBuilder<DescribeSharedDirectoriesRequest.Builder, DescribeSharedDirectoriesRequest> {
    private static final SdkField<String> OWNER_DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeSharedDirectoriesRequest::ownerDirectoryId)).setter(setter(Builder::ownerDirectoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerDirectoryId").build()).build();

    private static final SdkField<List<String>> SHARED_DIRECTORY_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeSharedDirectoriesRequest::sharedDirectoryIds))
            .setter(setter(Builder::sharedDirectoryIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedDirectoryIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeSharedDirectoriesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeSharedDirectoriesRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_DIRECTORY_ID_FIELD,
            SHARED_DIRECTORY_IDS_FIELD, NEXT_TOKEN_FIELD, LIMIT_FIELD));

    private final String ownerDirectoryId;

    private final List<String> sharedDirectoryIds;

    private final String nextToken;

    private final Integer limit;

    private DescribeSharedDirectoriesRequest(BuilderImpl builder) {
        super(builder);
        this.ownerDirectoryId = builder.ownerDirectoryId;
        this.sharedDirectoryIds = builder.sharedDirectoryIds;
        this.nextToken = builder.nextToken;
        this.limit = builder.limit;
    }

    /**
     * <p>
     * Returns the identifier of the directory in the directory owner account.
     * </p>
     * 
     * @return Returns the identifier of the directory in the directory owner account.
     */
    public String ownerDirectoryId() {
        return ownerDirectoryId;
    }

    /**
     * <p>
     * A list of identifiers of all shared directories in your account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of identifiers of all shared directories in your account.
     */
    public List<String> sharedDirectoryIds() {
        return sharedDirectoryIds;
    }

    /**
     * <p>
     * The <code>DescribeSharedDirectoriesResult.NextToken</code> value from a previous call to
     * <a>DescribeSharedDirectories</a>. Pass null if this is the first call.
     * </p>
     * 
     * @return The <code>DescribeSharedDirectoriesResult.NextToken</code> value from a previous call to
     *         <a>DescribeSharedDirectories</a>. Pass null if this is the first call.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The number of shared directories to return in the response object.
     * </p>
     * 
     * @return The number of shared directories to return in the response object.
     */
    public Integer limit() {
        return limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ownerDirectoryId());
        hashCode = 31 * hashCode + Objects.hashCode(sharedDirectoryIds());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSharedDirectoriesRequest)) {
            return false;
        }
        DescribeSharedDirectoriesRequest other = (DescribeSharedDirectoriesRequest) obj;
        return Objects.equals(ownerDirectoryId(), other.ownerDirectoryId())
                && Objects.equals(sharedDirectoryIds(), other.sharedDirectoryIds())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(limit(), other.limit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeSharedDirectoriesRequest").add("OwnerDirectoryId", ownerDirectoryId())
                .add("SharedDirectoryIds", sharedDirectoryIds()).add("NextToken", nextToken()).add("Limit", limit()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OwnerDirectoryId":
            return Optional.ofNullable(clazz.cast(ownerDirectoryId()));
        case "SharedDirectoryIds":
            return Optional.ofNullable(clazz.cast(sharedDirectoryIds()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSharedDirectoriesRequest, T> g) {
        return obj -> g.apply((DescribeSharedDirectoriesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectoryRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeSharedDirectoriesRequest> {
        /**
         * <p>
         * Returns the identifier of the directory in the directory owner account.
         * </p>
         * 
         * @param ownerDirectoryId
         *        Returns the identifier of the directory in the directory owner account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerDirectoryId(String ownerDirectoryId);

        /**
         * <p>
         * A list of identifiers of all shared directories in your account.
         * </p>
         * 
         * @param sharedDirectoryIds
         *        A list of identifiers of all shared directories in your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedDirectoryIds(Collection<String> sharedDirectoryIds);

        /**
         * <p>
         * A list of identifiers of all shared directories in your account.
         * </p>
         * 
         * @param sharedDirectoryIds
         *        A list of identifiers of all shared directories in your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedDirectoryIds(String... sharedDirectoryIds);

        /**
         * <p>
         * The <code>DescribeSharedDirectoriesResult.NextToken</code> value from a previous call to
         * <a>DescribeSharedDirectories</a>. Pass null if this is the first call.
         * </p>
         * 
         * @param nextToken
         *        The <code>DescribeSharedDirectoriesResult.NextToken</code> value from a previous call to
         *        <a>DescribeSharedDirectories</a>. Pass null if this is the first call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The number of shared directories to return in the response object.
         * </p>
         * 
         * @param limit
         *        The number of shared directories to return in the response object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectoryRequest.BuilderImpl implements Builder {
        private String ownerDirectoryId;

        private List<String> sharedDirectoryIds = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSharedDirectoriesRequest model) {
            super(model);
            ownerDirectoryId(model.ownerDirectoryId);
            sharedDirectoryIds(model.sharedDirectoryIds);
            nextToken(model.nextToken);
            limit(model.limit);
        }

        public final String getOwnerDirectoryId() {
            return ownerDirectoryId;
        }

        @Override
        public final Builder ownerDirectoryId(String ownerDirectoryId) {
            this.ownerDirectoryId = ownerDirectoryId;
            return this;
        }

        public final void setOwnerDirectoryId(String ownerDirectoryId) {
            this.ownerDirectoryId = ownerDirectoryId;
        }

        public final Collection<String> getSharedDirectoryIds() {
            return sharedDirectoryIds;
        }

        @Override
        public final Builder sharedDirectoryIds(Collection<String> sharedDirectoryIds) {
            this.sharedDirectoryIds = DirectoryIdsCopier.copy(sharedDirectoryIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sharedDirectoryIds(String... sharedDirectoryIds) {
            sharedDirectoryIds(Arrays.asList(sharedDirectoryIds));
            return this;
        }

        public final void setSharedDirectoryIds(Collection<String> sharedDirectoryIds) {
            this.sharedDirectoryIds = DirectoryIdsCopier.copy(sharedDirectoryIds);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeSharedDirectoriesRequest build() {
            return new DescribeSharedDirectoriesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
