/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of a DescribeTrust request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTrustsResponse extends DirectoryResponse implements
        ToCopyableBuilder<DescribeTrustsResponse.Builder, DescribeTrustsResponse> {
    private static final SdkField<List<Trust>> TRUSTS_FIELD = SdkField
            .<List<Trust>> builder(MarshallingType.LIST)
            .getter(getter(DescribeTrustsResponse::trusts))
            .setter(setter(Builder::trusts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Trusts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Trust> builder(MarshallingType.SDK_POJO)
                                            .constructor(Trust::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeTrustsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TRUSTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<Trust> trusts;

    private final String nextToken;

    private DescribeTrustsResponse(BuilderImpl builder) {
        super(builder);
        this.trusts = builder.trusts;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The list of Trust objects that were retrieved.
     * </p>
     * <p>
     * It is possible that this list contains less than the number of items specified in the <i>Limit</i> member of the
     * request. This occurs if there are less than the requested number of items left to retrieve, or if the limitations
     * of the operation have been exceeded.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of Trust objects that were retrieved.</p>
     *         <p>
     *         It is possible that this list contains less than the number of items specified in the <i>Limit</i> member
     *         of the request. This occurs if there are less than the requested number of items left to retrieve, or if
     *         the limitations of the operation have been exceeded.
     */
    public List<Trust> trusts() {
        return trusts;
    }

    /**
     * <p>
     * If not null, more results are available. Pass this value for the <i>NextToken</i> parameter in a subsequent call
     * to <a>DescribeTrusts</a> to retrieve the next set of items.
     * </p>
     * 
     * @return If not null, more results are available. Pass this value for the <i>NextToken</i> parameter in a
     *         subsequent call to <a>DescribeTrusts</a> to retrieve the next set of items.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trusts());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrustsResponse)) {
            return false;
        }
        DescribeTrustsResponse other = (DescribeTrustsResponse) obj;
        return Objects.equals(trusts(), other.trusts()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeTrustsResponse").add("Trusts", trusts()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Trusts":
            return Optional.ofNullable(clazz.cast(trusts()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTrustsResponse, T> g) {
        return obj -> g.apply((DescribeTrustsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectoryResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeTrustsResponse> {
        /**
         * <p>
         * The list of Trust objects that were retrieved.
         * </p>
         * <p>
         * It is possible that this list contains less than the number of items specified in the <i>Limit</i> member of
         * the request. This occurs if there are less than the requested number of items left to retrieve, or if the
         * limitations of the operation have been exceeded.
         * </p>
         * 
         * @param trusts
         *        The list of Trust objects that were retrieved.</p>
         *        <p>
         *        It is possible that this list contains less than the number of items specified in the <i>Limit</i>
         *        member of the request. This occurs if there are less than the requested number of items left to
         *        retrieve, or if the limitations of the operation have been exceeded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trusts(Collection<Trust> trusts);

        /**
         * <p>
         * The list of Trust objects that were retrieved.
         * </p>
         * <p>
         * It is possible that this list contains less than the number of items specified in the <i>Limit</i> member of
         * the request. This occurs if there are less than the requested number of items left to retrieve, or if the
         * limitations of the operation have been exceeded.
         * </p>
         * 
         * @param trusts
         *        The list of Trust objects that were retrieved.</p>
         *        <p>
         *        It is possible that this list contains less than the number of items specified in the <i>Limit</i>
         *        member of the request. This occurs if there are less than the requested number of items left to
         *        retrieve, or if the limitations of the operation have been exceeded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trusts(Trust... trusts);

        /**
         * <p>
         * The list of Trust objects that were retrieved.
         * </p>
         * <p>
         * It is possible that this list contains less than the number of items specified in the <i>Limit</i> member of
         * the request. This occurs if there are less than the requested number of items left to retrieve, or if the
         * limitations of the operation have been exceeded.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Trust>.Builder} avoiding the need to create
         * one manually via {@link List<Trust>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Trust>.Builder#build()} is called immediately and its result
         * is passed to {@link #trusts(List<Trust>)}.
         * 
         * @param trusts
         *        a consumer that will call methods on {@link List<Trust>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trusts(List<Trust>)
         */
        Builder trusts(Consumer<Trust.Builder>... trusts);

        /**
         * <p>
         * If not null, more results are available. Pass this value for the <i>NextToken</i> parameter in a subsequent
         * call to <a>DescribeTrusts</a> to retrieve the next set of items.
         * </p>
         * 
         * @param nextToken
         *        If not null, more results are available. Pass this value for the <i>NextToken</i> parameter in a
         *        subsequent call to <a>DescribeTrusts</a> to retrieve the next set of items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DirectoryResponse.BuilderImpl implements Builder {
        private List<Trust> trusts = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTrustsResponse model) {
            super(model);
            trusts(model.trusts);
            nextToken(model.nextToken);
        }

        public final Collection<Trust.Builder> getTrusts() {
            return trusts != null ? trusts.stream().map(Trust::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder trusts(Collection<Trust> trusts) {
            this.trusts = TrustsCopier.copy(trusts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trusts(Trust... trusts) {
            trusts(Arrays.asList(trusts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trusts(Consumer<Trust.Builder>... trusts) {
            trusts(Stream.of(trusts).map(c -> Trust.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTrusts(Collection<Trust.BuilderImpl> trusts) {
            this.trusts = TrustsCopier.copyFromBuilder(trusts);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeTrustsResponse build() {
            return new DescribeTrustsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
