/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the inputs for the <a>DisableSso</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisableSsoRequest extends DirectoryRequest implements
        ToCopyableBuilder<DisableSsoRequest.Builder, DisableSsoRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DisableSsoRequest::directoryId)).setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DisableSsoRequest::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final SdkField<String> PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DisableSsoRequest::password)).setter(setter(Builder::password))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD,
            USER_NAME_FIELD, PASSWORD_FIELD));

    private final String directoryId;

    private final String userName;

    private final String password;

    private DisableSsoRequest(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.userName = builder.userName;
        this.password = builder.password;
    }

    /**
     * <p>
     * The identifier of the directory for which to disable single-sign on.
     * </p>
     * 
     * @return The identifier of the directory for which to disable single-sign on.
     */
    public String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * The username of an alternate account to use to disable single-sign on. This is only used for AD Connector
     * directories. This account must have privileges to remove a service principal name.
     * </p>
     * <p>
     * If the AD Connector service account does not have privileges to remove a service principal name, you can specify
     * an alternate account with the <i>UserName</i> and <i>Password</i> parameters. These credentials are only used to
     * disable single sign-on and are not stored by the service. The AD Connector service account is not changed.
     * </p>
     * 
     * @return The username of an alternate account to use to disable single-sign on. This is only used for AD Connector
     *         directories. This account must have privileges to remove a service principal name.</p>
     *         <p>
     *         If the AD Connector service account does not have privileges to remove a service principal name, you can
     *         specify an alternate account with the <i>UserName</i> and <i>Password</i> parameters. These credentials
     *         are only used to disable single sign-on and are not stored by the service. The AD Connector service
     *         account is not changed.
     */
    public String userName() {
        return userName;
    }

    /**
     * <p>
     * The password of an alternate account to use to disable single-sign on. This is only used for AD Connector
     * directories. For more information, see the <i>UserName</i> parameter.
     * </p>
     * 
     * @return The password of an alternate account to use to disable single-sign on. This is only used for AD Connector
     *         directories. For more information, see the <i>UserName</i> parameter.
     */
    public String password() {
        return password;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        hashCode = 31 * hashCode + Objects.hashCode(password());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisableSsoRequest)) {
            return false;
        }
        DisableSsoRequest other = (DisableSsoRequest) obj;
        return Objects.equals(directoryId(), other.directoryId()) && Objects.equals(userName(), other.userName())
                && Objects.equals(password(), other.password());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DisableSsoRequest").add("DirectoryId", directoryId()).add("UserName", userName())
                .add("Password", password() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        case "Password":
            return Optional.ofNullable(clazz.cast(password()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisableSsoRequest, T> g) {
        return obj -> g.apply((DisableSsoRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectoryRequest.Builder, SdkPojo, CopyableBuilder<Builder, DisableSsoRequest> {
        /**
         * <p>
         * The identifier of the directory for which to disable single-sign on.
         * </p>
         * 
         * @param directoryId
         *        The identifier of the directory for which to disable single-sign on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * The username of an alternate account to use to disable single-sign on. This is only used for AD Connector
         * directories. This account must have privileges to remove a service principal name.
         * </p>
         * <p>
         * If the AD Connector service account does not have privileges to remove a service principal name, you can
         * specify an alternate account with the <i>UserName</i> and <i>Password</i> parameters. These credentials are
         * only used to disable single sign-on and are not stored by the service. The AD Connector service account is
         * not changed.
         * </p>
         * 
         * @param userName
         *        The username of an alternate account to use to disable single-sign on. This is only used for AD
         *        Connector directories. This account must have privileges to remove a service principal name.</p>
         *        <p>
         *        If the AD Connector service account does not have privileges to remove a service principal name, you
         *        can specify an alternate account with the <i>UserName</i> and <i>Password</i> parameters. These
         *        credentials are only used to disable single sign-on and are not stored by the service. The AD
         *        Connector service account is not changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);

        /**
         * <p>
         * The password of an alternate account to use to disable single-sign on. This is only used for AD Connector
         * directories. For more information, see the <i>UserName</i> parameter.
         * </p>
         * 
         * @param password
         *        The password of an alternate account to use to disable single-sign on. This is only used for AD
         *        Connector directories. For more information, see the <i>UserName</i> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder password(String password);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectoryRequest.BuilderImpl implements Builder {
        private String directoryId;

        private String userName;

        private String password;

        private BuilderImpl() {
        }

        private BuilderImpl(DisableSsoRequest model) {
            super(model);
            directoryId(model.directoryId);
            userName(model.userName);
            password(model.password);
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        public final String getUserName() {
            return userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getPassword() {
            return password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisableSsoRequest build() {
            return new DisableSsoRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
