/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the results of the <a>GetSnapshotLimits</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSnapshotLimitsResponse extends DirectoryResponse implements
        ToCopyableBuilder<GetSnapshotLimitsResponse.Builder, GetSnapshotLimitsResponse> {
    private static final SdkField<SnapshotLimits> SNAPSHOT_LIMITS_FIELD = SdkField
            .<SnapshotLimits> builder(MarshallingType.SDK_POJO).getter(getter(GetSnapshotLimitsResponse::snapshotLimits))
            .setter(setter(Builder::snapshotLimits)).constructor(SnapshotLimits::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotLimits").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_LIMITS_FIELD));

    private final SnapshotLimits snapshotLimits;

    private GetSnapshotLimitsResponse(BuilderImpl builder) {
        super(builder);
        this.snapshotLimits = builder.snapshotLimits;
    }

    /**
     * <p>
     * A <a>SnapshotLimits</a> object that contains the manual snapshot limits for the specified directory.
     * </p>
     * 
     * @return A <a>SnapshotLimits</a> object that contains the manual snapshot limits for the specified directory.
     */
    public SnapshotLimits snapshotLimits() {
        return snapshotLimits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(snapshotLimits());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSnapshotLimitsResponse)) {
            return false;
        }
        GetSnapshotLimitsResponse other = (GetSnapshotLimitsResponse) obj;
        return Objects.equals(snapshotLimits(), other.snapshotLimits());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetSnapshotLimitsResponse").add("SnapshotLimits", snapshotLimits()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SnapshotLimits":
            return Optional.ofNullable(clazz.cast(snapshotLimits()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSnapshotLimitsResponse, T> g) {
        return obj -> g.apply((GetSnapshotLimitsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectoryResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSnapshotLimitsResponse> {
        /**
         * <p>
         * A <a>SnapshotLimits</a> object that contains the manual snapshot limits for the specified directory.
         * </p>
         * 
         * @param snapshotLimits
         *        A <a>SnapshotLimits</a> object that contains the manual snapshot limits for the specified directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotLimits(SnapshotLimits snapshotLimits);

        /**
         * <p>
         * A <a>SnapshotLimits</a> object that contains the manual snapshot limits for the specified directory.
         * </p>
         * This is a convenience that creates an instance of the {@link SnapshotLimits.Builder} avoiding the need to
         * create one manually via {@link SnapshotLimits#builder()}.
         *
         * When the {@link Consumer} completes, {@link SnapshotLimits.Builder#build()} is called immediately and its
         * result is passed to {@link #snapshotLimits(SnapshotLimits)}.
         * 
         * @param snapshotLimits
         *        a consumer that will call methods on {@link SnapshotLimits.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snapshotLimits(SnapshotLimits)
         */
        default Builder snapshotLimits(Consumer<SnapshotLimits.Builder> snapshotLimits) {
            return snapshotLimits(SnapshotLimits.builder().applyMutation(snapshotLimits).build());
        }
    }

    static final class BuilderImpl extends DirectoryResponse.BuilderImpl implements Builder {
        private SnapshotLimits snapshotLimits;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSnapshotLimitsResponse model) {
            super(model);
            snapshotLimits(model.snapshotLimits);
        }

        public final SnapshotLimits.Builder getSnapshotLimits() {
            return snapshotLimits != null ? snapshotLimits.toBuilder() : null;
        }

        @Override
        public final Builder snapshotLimits(SnapshotLimits snapshotLimits) {
            this.snapshotLimits = snapshotLimits;
            return this;
        }

        public final void setSnapshotLimits(SnapshotLimits.BuilderImpl snapshotLimits) {
            this.snapshotLimits = snapshotLimits != null ? snapshotLimits.build() : null;
        }

        @Override
        public GetSnapshotLimitsResponse build() {
            return new GetSnapshotLimitsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
