/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directory.model.CertificateState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CertificateInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CertificateInfo> {
    private static final SdkField<String> CERTIFICATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CertificateInfo.getter(CertificateInfo::certificateId)).setter(CertificateInfo.setter(Builder::certificateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateId").build()}).build();
    private static final SdkField<String> COMMON_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CertificateInfo.getter(CertificateInfo::commonName)).setter(CertificateInfo.setter(Builder::commonName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommonName").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CertificateInfo.getter(CertificateInfo::stateAsString)).setter(CertificateInfo.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<Instant> EXPIRY_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(CertificateInfo.getter(CertificateInfo::expiryDateTime)).setter(CertificateInfo.setter(Builder::expiryDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpiryDateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_ID_FIELD, COMMON_NAME_FIELD, STATE_FIELD, EXPIRY_DATE_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String certificateId;
    private final String commonName;
    private final String state;
    private final Instant expiryDateTime;

    private CertificateInfo(BuilderImpl builder) {
        this.certificateId = builder.certificateId;
        this.commonName = builder.commonName;
        this.state = builder.state;
        this.expiryDateTime = builder.expiryDateTime;
    }

    public String certificateId() {
        return this.certificateId;
    }

    public String commonName() {
        return this.commonName;
    }

    public CertificateState state() {
        return CertificateState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public Instant expiryDateTime() {
        return this.expiryDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.commonName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiryDateTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CertificateInfo)) {
            return false;
        }
        CertificateInfo other = (CertificateInfo)obj;
        return Objects.equals(this.certificateId(), other.certificateId()) && Objects.equals(this.commonName(), other.commonName()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.expiryDateTime(), other.expiryDateTime());
    }

    public String toString() {
        return ToString.builder((String)"CertificateInfo").add("CertificateId", (Object)this.certificateId()).add("CommonName", (Object)this.commonName()).add("State", (Object)this.stateAsString()).add("ExpiryDateTime", (Object)this.expiryDateTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CertificateId": {
                return Optional.ofNullable(clazz.cast(this.certificateId()));
            }
            case "CommonName": {
                return Optional.ofNullable(clazz.cast(this.commonName()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "ExpiryDateTime": {
                return Optional.ofNullable(clazz.cast(this.expiryDateTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CertificateInfo, T> g) {
        return obj -> g.apply((CertificateInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String certificateId;
        private String commonName;
        private String state;
        private Instant expiryDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CertificateInfo model) {
            this.certificateId(model.certificateId);
            this.commonName(model.commonName);
            this.state(model.state);
            this.expiryDateTime(model.expiryDateTime);
        }

        public final String getCertificateId() {
            return this.certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        public final String getCommonName() {
            return this.commonName;
        }

        @Override
        public final Builder commonName(String commonName) {
            this.commonName = commonName;
            return this;
        }

        public final void setCommonName(String commonName) {
            this.commonName = commonName;
        }

        public final String getStateAsString() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CertificateState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Instant getExpiryDateTime() {
            return this.expiryDateTime;
        }

        @Override
        public final Builder expiryDateTime(Instant expiryDateTime) {
            this.expiryDateTime = expiryDateTime;
            return this;
        }

        public final void setExpiryDateTime(Instant expiryDateTime) {
            this.expiryDateTime = expiryDateTime;
        }

        public CertificateInfo build() {
            return new CertificateInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CertificateInfo> {
        public Builder certificateId(String var1);

        public Builder commonName(String var1);

        public Builder state(String var1);

        public Builder state(CertificateState var1);

        public Builder expiryDateTime(Instant var1);
    }
}

