/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directory.model.DirectoryEdition;
import software.amazon.awssdk.services.directory.model.DirectoryRequest;
import software.amazon.awssdk.services.directory.model.DirectoryVpcSettings;
import software.amazon.awssdk.services.directory.model.Tag;
import software.amazon.awssdk.services.directory.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMicrosoftAdRequest
extends DirectoryRequest
implements ToCopyableBuilder<Builder, CreateMicrosoftAdRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateMicrosoftAdRequest.getter(CreateMicrosoftAdRequest::name)).setter(CreateMicrosoftAdRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> SHORT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateMicrosoftAdRequest.getter(CreateMicrosoftAdRequest::shortName)).setter(CreateMicrosoftAdRequest.setter(Builder::shortName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShortName").build()}).build();
    private static final SdkField<String> PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateMicrosoftAdRequest.getter(CreateMicrosoftAdRequest::password)).setter(CreateMicrosoftAdRequest.setter(Builder::password)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateMicrosoftAdRequest.getter(CreateMicrosoftAdRequest::description)).setter(CreateMicrosoftAdRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<DirectoryVpcSettings> VPC_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateMicrosoftAdRequest.getter(CreateMicrosoftAdRequest::vpcSettings)).setter(CreateMicrosoftAdRequest.setter(Builder::vpcSettings)).constructor(DirectoryVpcSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSettings").build()}).build();
    private static final SdkField<String> EDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateMicrosoftAdRequest.getter(CreateMicrosoftAdRequest::editionAsString)).setter(CreateMicrosoftAdRequest.setter(Builder::edition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Edition").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateMicrosoftAdRequest.getter(CreateMicrosoftAdRequest::tags)).setter(CreateMicrosoftAdRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SHORT_NAME_FIELD, PASSWORD_FIELD, DESCRIPTION_FIELD, VPC_SETTINGS_FIELD, EDITION_FIELD, TAGS_FIELD));
    private final String name;
    private final String shortName;
    private final String password;
    private final String description;
    private final DirectoryVpcSettings vpcSettings;
    private final String edition;
    private final List<Tag> tags;

    private CreateMicrosoftAdRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.shortName = builder.shortName;
        this.password = builder.password;
        this.description = builder.description;
        this.vpcSettings = builder.vpcSettings;
        this.edition = builder.edition;
        this.tags = builder.tags;
    }

    public String name() {
        return this.name;
    }

    public String shortName() {
        return this.shortName;
    }

    public String password() {
        return this.password;
    }

    public String description() {
        return this.description;
    }

    public DirectoryVpcSettings vpcSettings() {
        return this.vpcSettings;
    }

    public DirectoryEdition edition() {
        return DirectoryEdition.fromValue(this.edition);
    }

    public String editionAsString() {
        return this.edition;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.shortName());
        hashCode = 31 * hashCode + Objects.hashCode(this.password());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.editionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMicrosoftAdRequest)) {
            return false;
        }
        CreateMicrosoftAdRequest other = (CreateMicrosoftAdRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.shortName(), other.shortName()) && Objects.equals(this.password(), other.password()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.vpcSettings(), other.vpcSettings()) && Objects.equals(this.editionAsString(), other.editionAsString()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateMicrosoftAdRequest").add("Name", (Object)this.name()).add("ShortName", (Object)this.shortName()).add("Password", (Object)(this.password() == null ? null : "*** Sensitive Data Redacted ***")).add("Description", (Object)this.description()).add("VpcSettings", (Object)this.vpcSettings()).add("Edition", (Object)this.editionAsString()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ShortName": {
                return Optional.ofNullable(clazz.cast(this.shortName()));
            }
            case "Password": {
                return Optional.ofNullable(clazz.cast(this.password()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "VpcSettings": {
                return Optional.ofNullable(clazz.cast(this.vpcSettings()));
            }
            case "Edition": {
                return Optional.ofNullable(clazz.cast(this.editionAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMicrosoftAdRequest, T> g) {
        return obj -> g.apply((CreateMicrosoftAdRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectoryRequest.BuilderImpl
    implements Builder {
        private String name;
        private String shortName;
        private String password;
        private String description;
        private DirectoryVpcSettings vpcSettings;
        private String edition;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMicrosoftAdRequest model) {
            super(model);
            this.name(model.name);
            this.shortName(model.shortName);
            this.password(model.password);
            this.description(model.description);
            this.vpcSettings(model.vpcSettings);
            this.edition(model.edition);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getShortName() {
            return this.shortName;
        }

        @Override
        public final Builder shortName(String shortName) {
            this.shortName = shortName;
            return this;
        }

        public final void setShortName(String shortName) {
            this.shortName = shortName;
        }

        public final String getPassword() {
            return this.password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final DirectoryVpcSettings.Builder getVpcSettings() {
            return this.vpcSettings != null ? this.vpcSettings.toBuilder() : null;
        }

        @Override
        public final Builder vpcSettings(DirectoryVpcSettings vpcSettings) {
            this.vpcSettings = vpcSettings;
            return this;
        }

        public final void setVpcSettings(DirectoryVpcSettings.BuilderImpl vpcSettings) {
            this.vpcSettings = vpcSettings != null ? vpcSettings.build() : null;
        }

        public final String getEditionAsString() {
            return this.edition;
        }

        @Override
        public final Builder edition(String edition) {
            this.edition = edition;
            return this;
        }

        @Override
        public final Builder edition(DirectoryEdition edition) {
            this.edition(edition == null ? null : edition.toString());
            return this;
        }

        public final void setEdition(String edition) {
            this.edition = edition;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMicrosoftAdRequest build() {
            return new CreateMicrosoftAdRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DirectoryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateMicrosoftAdRequest> {
        public Builder name(String var1);

        public Builder shortName(String var1);

        public Builder password(String var1);

        public Builder description(String var1);

        public Builder vpcSettings(DirectoryVpcSettings var1);

        default public Builder vpcSettings(Consumer<DirectoryVpcSettings.Builder> vpcSettings) {
            return this.vpcSettings((DirectoryVpcSettings)((DirectoryVpcSettings.Builder)DirectoryVpcSettings.builder().applyMutation(vpcSettings)).build());
        }

        public Builder edition(String var1);

        public Builder edition(DirectoryEdition var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

