/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.directory.DirectoryAsyncClient;
import software.amazon.awssdk.services.directory.model.AcceptSharedDirectoryRequest;
import software.amazon.awssdk.services.directory.model.AcceptSharedDirectoryResponse;
import software.amazon.awssdk.services.directory.model.AccessDeniedException;
import software.amazon.awssdk.services.directory.model.AddIpRoutesRequest;
import software.amazon.awssdk.services.directory.model.AddIpRoutesResponse;
import software.amazon.awssdk.services.directory.model.AddTagsToResourceRequest;
import software.amazon.awssdk.services.directory.model.AddTagsToResourceResponse;
import software.amazon.awssdk.services.directory.model.AuthenticationFailedException;
import software.amazon.awssdk.services.directory.model.CancelSchemaExtensionRequest;
import software.amazon.awssdk.services.directory.model.CancelSchemaExtensionResponse;
import software.amazon.awssdk.services.directory.model.CertificateAlreadyExistsException;
import software.amazon.awssdk.services.directory.model.CertificateDoesNotExistException;
import software.amazon.awssdk.services.directory.model.CertificateInUseException;
import software.amazon.awssdk.services.directory.model.CertificateLimitExceededException;
import software.amazon.awssdk.services.directory.model.ClientException;
import software.amazon.awssdk.services.directory.model.ConnectDirectoryRequest;
import software.amazon.awssdk.services.directory.model.ConnectDirectoryResponse;
import software.amazon.awssdk.services.directory.model.CreateAliasRequest;
import software.amazon.awssdk.services.directory.model.CreateAliasResponse;
import software.amazon.awssdk.services.directory.model.CreateComputerRequest;
import software.amazon.awssdk.services.directory.model.CreateComputerResponse;
import software.amazon.awssdk.services.directory.model.CreateConditionalForwarderRequest;
import software.amazon.awssdk.services.directory.model.CreateConditionalForwarderResponse;
import software.amazon.awssdk.services.directory.model.CreateDirectoryRequest;
import software.amazon.awssdk.services.directory.model.CreateDirectoryResponse;
import software.amazon.awssdk.services.directory.model.CreateLogSubscriptionRequest;
import software.amazon.awssdk.services.directory.model.CreateLogSubscriptionResponse;
import software.amazon.awssdk.services.directory.model.CreateMicrosoftAdRequest;
import software.amazon.awssdk.services.directory.model.CreateMicrosoftAdResponse;
import software.amazon.awssdk.services.directory.model.CreateSnapshotRequest;
import software.amazon.awssdk.services.directory.model.CreateSnapshotResponse;
import software.amazon.awssdk.services.directory.model.CreateTrustRequest;
import software.amazon.awssdk.services.directory.model.CreateTrustResponse;
import software.amazon.awssdk.services.directory.model.DeleteConditionalForwarderRequest;
import software.amazon.awssdk.services.directory.model.DeleteConditionalForwarderResponse;
import software.amazon.awssdk.services.directory.model.DeleteDirectoryRequest;
import software.amazon.awssdk.services.directory.model.DeleteDirectoryResponse;
import software.amazon.awssdk.services.directory.model.DeleteLogSubscriptionRequest;
import software.amazon.awssdk.services.directory.model.DeleteLogSubscriptionResponse;
import software.amazon.awssdk.services.directory.model.DeleteSnapshotRequest;
import software.amazon.awssdk.services.directory.model.DeleteSnapshotResponse;
import software.amazon.awssdk.services.directory.model.DeleteTrustRequest;
import software.amazon.awssdk.services.directory.model.DeleteTrustResponse;
import software.amazon.awssdk.services.directory.model.DeregisterCertificateRequest;
import software.amazon.awssdk.services.directory.model.DeregisterCertificateResponse;
import software.amazon.awssdk.services.directory.model.DeregisterEventTopicRequest;
import software.amazon.awssdk.services.directory.model.DeregisterEventTopicResponse;
import software.amazon.awssdk.services.directory.model.DescribeCertificateRequest;
import software.amazon.awssdk.services.directory.model.DescribeCertificateResponse;
import software.amazon.awssdk.services.directory.model.DescribeConditionalForwardersRequest;
import software.amazon.awssdk.services.directory.model.DescribeConditionalForwardersResponse;
import software.amazon.awssdk.services.directory.model.DescribeDirectoriesRequest;
import software.amazon.awssdk.services.directory.model.DescribeDirectoriesResponse;
import software.amazon.awssdk.services.directory.model.DescribeDomainControllersRequest;
import software.amazon.awssdk.services.directory.model.DescribeDomainControllersResponse;
import software.amazon.awssdk.services.directory.model.DescribeEventTopicsRequest;
import software.amazon.awssdk.services.directory.model.DescribeEventTopicsResponse;
import software.amazon.awssdk.services.directory.model.DescribeLdapsSettingsRequest;
import software.amazon.awssdk.services.directory.model.DescribeLdapsSettingsResponse;
import software.amazon.awssdk.services.directory.model.DescribeSharedDirectoriesRequest;
import software.amazon.awssdk.services.directory.model.DescribeSharedDirectoriesResponse;
import software.amazon.awssdk.services.directory.model.DescribeSnapshotsRequest;
import software.amazon.awssdk.services.directory.model.DescribeSnapshotsResponse;
import software.amazon.awssdk.services.directory.model.DescribeTrustsRequest;
import software.amazon.awssdk.services.directory.model.DescribeTrustsResponse;
import software.amazon.awssdk.services.directory.model.DirectoryAlreadySharedException;
import software.amazon.awssdk.services.directory.model.DirectoryDoesNotExistException;
import software.amazon.awssdk.services.directory.model.DirectoryException;
import software.amazon.awssdk.services.directory.model.DirectoryLimitExceededException;
import software.amazon.awssdk.services.directory.model.DirectoryNotSharedException;
import software.amazon.awssdk.services.directory.model.DirectoryRequest;
import software.amazon.awssdk.services.directory.model.DirectoryUnavailableException;
import software.amazon.awssdk.services.directory.model.DisableLdapsRequest;
import software.amazon.awssdk.services.directory.model.DisableLdapsResponse;
import software.amazon.awssdk.services.directory.model.DisableRadiusRequest;
import software.amazon.awssdk.services.directory.model.DisableRadiusResponse;
import software.amazon.awssdk.services.directory.model.DisableSsoRequest;
import software.amazon.awssdk.services.directory.model.DisableSsoResponse;
import software.amazon.awssdk.services.directory.model.DomainControllerLimitExceededException;
import software.amazon.awssdk.services.directory.model.EnableLdapsRequest;
import software.amazon.awssdk.services.directory.model.EnableLdapsResponse;
import software.amazon.awssdk.services.directory.model.EnableRadiusRequest;
import software.amazon.awssdk.services.directory.model.EnableRadiusResponse;
import software.amazon.awssdk.services.directory.model.EnableSsoRequest;
import software.amazon.awssdk.services.directory.model.EnableSsoResponse;
import software.amazon.awssdk.services.directory.model.EntityAlreadyExistsException;
import software.amazon.awssdk.services.directory.model.EntityDoesNotExistException;
import software.amazon.awssdk.services.directory.model.GetDirectoryLimitsRequest;
import software.amazon.awssdk.services.directory.model.GetDirectoryLimitsResponse;
import software.amazon.awssdk.services.directory.model.GetSnapshotLimitsRequest;
import software.amazon.awssdk.services.directory.model.GetSnapshotLimitsResponse;
import software.amazon.awssdk.services.directory.model.InsufficientPermissionsException;
import software.amazon.awssdk.services.directory.model.InvalidCertificateException;
import software.amazon.awssdk.services.directory.model.InvalidLdapsStatusException;
import software.amazon.awssdk.services.directory.model.InvalidNextTokenException;
import software.amazon.awssdk.services.directory.model.InvalidParameterException;
import software.amazon.awssdk.services.directory.model.InvalidPasswordException;
import software.amazon.awssdk.services.directory.model.InvalidTargetException;
import software.amazon.awssdk.services.directory.model.IpRouteLimitExceededException;
import software.amazon.awssdk.services.directory.model.ListCertificatesRequest;
import software.amazon.awssdk.services.directory.model.ListCertificatesResponse;
import software.amazon.awssdk.services.directory.model.ListIpRoutesRequest;
import software.amazon.awssdk.services.directory.model.ListIpRoutesResponse;
import software.amazon.awssdk.services.directory.model.ListLogSubscriptionsRequest;
import software.amazon.awssdk.services.directory.model.ListLogSubscriptionsResponse;
import software.amazon.awssdk.services.directory.model.ListSchemaExtensionsRequest;
import software.amazon.awssdk.services.directory.model.ListSchemaExtensionsResponse;
import software.amazon.awssdk.services.directory.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.directory.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.directory.model.NoAvailableCertificateException;
import software.amazon.awssdk.services.directory.model.OrganizationsException;
import software.amazon.awssdk.services.directory.model.RegisterCertificateRequest;
import software.amazon.awssdk.services.directory.model.RegisterCertificateResponse;
import software.amazon.awssdk.services.directory.model.RegisterEventTopicRequest;
import software.amazon.awssdk.services.directory.model.RegisterEventTopicResponse;
import software.amazon.awssdk.services.directory.model.RejectSharedDirectoryRequest;
import software.amazon.awssdk.services.directory.model.RejectSharedDirectoryResponse;
import software.amazon.awssdk.services.directory.model.RemoveIpRoutesRequest;
import software.amazon.awssdk.services.directory.model.RemoveIpRoutesResponse;
import software.amazon.awssdk.services.directory.model.RemoveTagsFromResourceRequest;
import software.amazon.awssdk.services.directory.model.RemoveTagsFromResourceResponse;
import software.amazon.awssdk.services.directory.model.ResetUserPasswordRequest;
import software.amazon.awssdk.services.directory.model.ResetUserPasswordResponse;
import software.amazon.awssdk.services.directory.model.RestoreFromSnapshotRequest;
import software.amazon.awssdk.services.directory.model.RestoreFromSnapshotResponse;
import software.amazon.awssdk.services.directory.model.ServiceException;
import software.amazon.awssdk.services.directory.model.ShareDirectoryRequest;
import software.amazon.awssdk.services.directory.model.ShareDirectoryResponse;
import software.amazon.awssdk.services.directory.model.ShareLimitExceededException;
import software.amazon.awssdk.services.directory.model.SnapshotLimitExceededException;
import software.amazon.awssdk.services.directory.model.StartSchemaExtensionRequest;
import software.amazon.awssdk.services.directory.model.StartSchemaExtensionResponse;
import software.amazon.awssdk.services.directory.model.TagLimitExceededException;
import software.amazon.awssdk.services.directory.model.UnshareDirectoryRequest;
import software.amazon.awssdk.services.directory.model.UnshareDirectoryResponse;
import software.amazon.awssdk.services.directory.model.UnsupportedOperationException;
import software.amazon.awssdk.services.directory.model.UpdateConditionalForwarderRequest;
import software.amazon.awssdk.services.directory.model.UpdateConditionalForwarderResponse;
import software.amazon.awssdk.services.directory.model.UpdateNumberOfDomainControllersRequest;
import software.amazon.awssdk.services.directory.model.UpdateNumberOfDomainControllersResponse;
import software.amazon.awssdk.services.directory.model.UpdateRadiusRequest;
import software.amazon.awssdk.services.directory.model.UpdateRadiusResponse;
import software.amazon.awssdk.services.directory.model.UpdateTrustRequest;
import software.amazon.awssdk.services.directory.model.UpdateTrustResponse;
import software.amazon.awssdk.services.directory.model.UserDoesNotExistException;
import software.amazon.awssdk.services.directory.model.VerifyTrustRequest;
import software.amazon.awssdk.services.directory.model.VerifyTrustResponse;
import software.amazon.awssdk.services.directory.paginators.DescribeDomainControllersPublisher;
import software.amazon.awssdk.services.directory.transform.AcceptSharedDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.AddIpRoutesRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.AddTagsToResourceRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CancelSchemaExtensionRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ConnectDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateAliasRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateComputerRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateConditionalForwarderRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateLogSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateMicrosoftAdRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateSnapshotRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateTrustRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DeleteConditionalForwarderRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DeleteDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DeleteLogSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DeleteSnapshotRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DeleteTrustRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DeregisterCertificateRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DeregisterEventTopicRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeCertificateRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeConditionalForwardersRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeDirectoriesRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeDomainControllersRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeEventTopicsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeLdapsSettingsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeSharedDirectoriesRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeTrustsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DisableLdapsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DisableRadiusRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DisableSsoRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.EnableLdapsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.EnableRadiusRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.EnableSsoRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.GetDirectoryLimitsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.GetSnapshotLimitsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ListCertificatesRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ListIpRoutesRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ListLogSubscriptionsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ListSchemaExtensionsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.RegisterCertificateRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.RegisterEventTopicRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.RejectSharedDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.RemoveIpRoutesRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.RemoveTagsFromResourceRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ResetUserPasswordRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.RestoreFromSnapshotRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ShareDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.StartSchemaExtensionRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.UnshareDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.UpdateConditionalForwarderRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.UpdateNumberOfDomainControllersRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.UpdateRadiusRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.UpdateTrustRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.VerifyTrustRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultDirectoryAsyncClient
implements DirectoryAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultDirectoryAsyncClient.class);
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultDirectoryAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "ds";
    }

    @Override
    public CompletableFuture<AcceptSharedDirectoryResponse> acceptSharedDirectory(AcceptSharedDirectoryRequest acceptSharedDirectoryRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AcceptSharedDirectory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AcceptSharedDirectoryResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AcceptSharedDirectory").withMarshaller((Marshaller)new AcceptSharedDirectoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)acceptSharedDirectoryRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = acceptSharedDirectoryRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, acceptSharedDirectoryRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AddIpRoutesResponse> addIpRoutes(AddIpRoutesRequest addIpRoutesRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddIpRoutes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddIpRoutesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddIpRoutes").withMarshaller((Marshaller)new AddIpRoutesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)addIpRoutesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = addIpRoutesRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, addIpRoutesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AddTagsToResourceResponse> addTagsToResource(AddTagsToResourceRequest addTagsToResourceRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddTagsToResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddTagsToResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddTagsToResource").withMarshaller((Marshaller)new AddTagsToResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)addTagsToResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = addTagsToResourceRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, addTagsToResourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CancelSchemaExtensionResponse> cancelSchemaExtension(CancelSchemaExtensionRequest cancelSchemaExtensionRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelSchemaExtension");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelSchemaExtensionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelSchemaExtension").withMarshaller((Marshaller)new CancelSchemaExtensionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)cancelSchemaExtensionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = cancelSchemaExtensionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, cancelSchemaExtensionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ConnectDirectoryResponse> connectDirectory(ConnectDirectoryRequest connectDirectoryRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ConnectDirectory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ConnectDirectoryResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ConnectDirectory").withMarshaller((Marshaller)new ConnectDirectoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)connectDirectoryRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = connectDirectoryRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, connectDirectoryRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateAliasResponse> createAlias(CreateAliasRequest createAliasRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAlias");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAliasResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAlias").withMarshaller((Marshaller)new CreateAliasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)createAliasRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createAliasRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, createAliasRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateComputerResponse> createComputer(CreateComputerRequest createComputerRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateComputer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateComputerResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateComputer").withMarshaller((Marshaller)new CreateComputerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)createComputerRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createComputerRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, createComputerRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateConditionalForwarderResponse> createConditionalForwarder(CreateConditionalForwarderRequest createConditionalForwarderRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateConditionalForwarder");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateConditionalForwarderResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateConditionalForwarder").withMarshaller((Marshaller)new CreateConditionalForwarderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)createConditionalForwarderRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createConditionalForwarderRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, createConditionalForwarderRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDirectoryResponse> createDirectory(CreateDirectoryRequest createDirectoryRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDirectory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDirectoryResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDirectory").withMarshaller((Marshaller)new CreateDirectoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)createDirectoryRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createDirectoryRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, createDirectoryRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateLogSubscriptionResponse> createLogSubscription(CreateLogSubscriptionRequest createLogSubscriptionRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLogSubscription");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLogSubscriptionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLogSubscription").withMarshaller((Marshaller)new CreateLogSubscriptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)createLogSubscriptionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createLogSubscriptionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, createLogSubscriptionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateMicrosoftAdResponse> createMicrosoftAD(CreateMicrosoftAdRequest createMicrosoftAdRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateMicrosoftAD");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateMicrosoftAdResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateMicrosoftAD").withMarshaller((Marshaller)new CreateMicrosoftAdRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)createMicrosoftAdRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createMicrosoftAdRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, createMicrosoftAdRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateSnapshotResponse> createSnapshot(CreateSnapshotRequest createSnapshotRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSnapshotResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSnapshot").withMarshaller((Marshaller)new CreateSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)createSnapshotRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createSnapshotRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, createSnapshotRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateTrustResponse> createTrust(CreateTrustRequest createTrustRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTrust");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTrustResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTrust").withMarshaller((Marshaller)new CreateTrustRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)createTrustRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createTrustRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, createTrustRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteConditionalForwarderResponse> deleteConditionalForwarder(DeleteConditionalForwarderRequest deleteConditionalForwarderRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteConditionalForwarder");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteConditionalForwarderResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteConditionalForwarder").withMarshaller((Marshaller)new DeleteConditionalForwarderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)deleteConditionalForwarderRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteConditionalForwarderRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteConditionalForwarderRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDirectoryResponse> deleteDirectory(DeleteDirectoryRequest deleteDirectoryRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDirectory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDirectoryResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDirectory").withMarshaller((Marshaller)new DeleteDirectoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)deleteDirectoryRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteDirectoryRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteDirectoryRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteLogSubscriptionResponse> deleteLogSubscription(DeleteLogSubscriptionRequest deleteLogSubscriptionRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteLogSubscription");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteLogSubscriptionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLogSubscription").withMarshaller((Marshaller)new DeleteLogSubscriptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)deleteLogSubscriptionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteLogSubscriptionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteLogSubscriptionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteSnapshotResponse> deleteSnapshot(DeleteSnapshotRequest deleteSnapshotRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSnapshotResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSnapshot").withMarshaller((Marshaller)new DeleteSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)deleteSnapshotRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteSnapshotRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteSnapshotRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteTrustResponse> deleteTrust(DeleteTrustRequest deleteTrustRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTrust");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTrustResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTrust").withMarshaller((Marshaller)new DeleteTrustRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)deleteTrustRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteTrustRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteTrustRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeregisterCertificateResponse> deregisterCertificate(DeregisterCertificateRequest deregisterCertificateRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeregisterCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeregisterCertificateResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterCertificate").withMarshaller((Marshaller)new DeregisterCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)deregisterCertificateRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deregisterCertificateRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, deregisterCertificateRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeregisterEventTopicResponse> deregisterEventTopic(DeregisterEventTopicRequest deregisterEventTopicRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeregisterEventTopic");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeregisterEventTopicResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterEventTopic").withMarshaller((Marshaller)new DeregisterEventTopicRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)deregisterEventTopicRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deregisterEventTopicRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, deregisterEventTopicRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeCertificateResponse> describeCertificate(DescribeCertificateRequest describeCertificateRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCertificateResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCertificate").withMarshaller((Marshaller)new DescribeCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeCertificateRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeCertificateRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeCertificateRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeConditionalForwardersResponse> describeConditionalForwarders(DescribeConditionalForwardersRequest describeConditionalForwardersRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeConditionalForwarders");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeConditionalForwardersResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConditionalForwarders").withMarshaller((Marshaller)new DescribeConditionalForwardersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeConditionalForwardersRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeConditionalForwardersRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeConditionalForwardersRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeDirectoriesResponse> describeDirectories(DescribeDirectoriesRequest describeDirectoriesRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDirectories");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDirectoriesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDirectories").withMarshaller((Marshaller)new DescribeDirectoriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeDirectoriesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeDirectoriesRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeDirectoriesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeDomainControllersResponse> describeDomainControllers(DescribeDomainControllersRequest describeDomainControllersRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDomainControllers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDomainControllersResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDomainControllers").withMarshaller((Marshaller)new DescribeDomainControllersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeDomainControllersRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeDomainControllersRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeDomainControllersRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeDomainControllersPublisher describeDomainControllersPaginator(DescribeDomainControllersRequest describeDomainControllersRequest) {
        return new DescribeDomainControllersPublisher(this, this.applyPaginatorUserAgent(describeDomainControllersRequest));
    }

    @Override
    public CompletableFuture<DescribeEventTopicsResponse> describeEventTopics(DescribeEventTopicsRequest describeEventTopicsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEventTopics");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEventTopicsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEventTopics").withMarshaller((Marshaller)new DescribeEventTopicsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeEventTopicsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeEventTopicsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeEventTopicsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeLdapsSettingsResponse> describeLDAPSSettings(DescribeLdapsSettingsRequest describeLdapsSettingsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeLDAPSSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeLdapsSettingsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLDAPSSettings").withMarshaller((Marshaller)new DescribeLdapsSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeLdapsSettingsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeLdapsSettingsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeLdapsSettingsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeSharedDirectoriesResponse> describeSharedDirectories(DescribeSharedDirectoriesRequest describeSharedDirectoriesRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSharedDirectories");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSharedDirectoriesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSharedDirectories").withMarshaller((Marshaller)new DescribeSharedDirectoriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeSharedDirectoriesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeSharedDirectoriesRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeSharedDirectoriesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeSnapshotsResponse> describeSnapshots(DescribeSnapshotsRequest describeSnapshotsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSnapshots");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSnapshotsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSnapshots").withMarshaller((Marshaller)new DescribeSnapshotsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeSnapshotsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeSnapshotsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeSnapshotsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeTrustsResponse> describeTrusts(DescribeTrustsRequest describeTrustsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTrusts");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTrustsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTrusts").withMarshaller((Marshaller)new DescribeTrustsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeTrustsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeTrustsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeTrustsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisableLdapsResponse> disableLDAPS(DisableLdapsRequest disableLdapsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableLDAPS");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableLdapsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableLDAPS").withMarshaller((Marshaller)new DisableLdapsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)disableLdapsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = disableLdapsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, disableLdapsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisableRadiusResponse> disableRadius(DisableRadiusRequest disableRadiusRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableRadius");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableRadiusResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableRadius").withMarshaller((Marshaller)new DisableRadiusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)disableRadiusRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = disableRadiusRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, disableRadiusRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisableSsoResponse> disableSso(DisableSsoRequest disableSsoRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableSso");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableSsoResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableSso").withMarshaller((Marshaller)new DisableSsoRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)disableSsoRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = disableSsoRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, disableSsoRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<EnableLdapsResponse> enableLDAPS(EnableLdapsRequest enableLdapsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableLDAPS");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableLdapsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableLDAPS").withMarshaller((Marshaller)new EnableLdapsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)enableLdapsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = enableLdapsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, enableLdapsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<EnableRadiusResponse> enableRadius(EnableRadiusRequest enableRadiusRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableRadius");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableRadiusResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableRadius").withMarshaller((Marshaller)new EnableRadiusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)enableRadiusRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = enableRadiusRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, enableRadiusRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<EnableSsoResponse> enableSso(EnableSsoRequest enableSsoRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableSso");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableSsoResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableSso").withMarshaller((Marshaller)new EnableSsoRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)enableSsoRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = enableSsoRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, enableSsoRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDirectoryLimitsResponse> getDirectoryLimits(GetDirectoryLimitsRequest getDirectoryLimitsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDirectoryLimits");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDirectoryLimitsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDirectoryLimits").withMarshaller((Marshaller)new GetDirectoryLimitsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)getDirectoryLimitsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getDirectoryLimitsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, getDirectoryLimitsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetSnapshotLimitsResponse> getSnapshotLimits(GetSnapshotLimitsRequest getSnapshotLimitsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSnapshotLimits");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSnapshotLimitsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSnapshotLimits").withMarshaller((Marshaller)new GetSnapshotLimitsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)getSnapshotLimitsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getSnapshotLimitsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, getSnapshotLimitsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListCertificatesResponse> listCertificates(ListCertificatesRequest listCertificatesRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCertificates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCertificatesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCertificates").withMarshaller((Marshaller)new ListCertificatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)listCertificatesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listCertificatesRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, listCertificatesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListIpRoutesResponse> listIpRoutes(ListIpRoutesRequest listIpRoutesRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListIpRoutes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListIpRoutesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListIpRoutes").withMarshaller((Marshaller)new ListIpRoutesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)listIpRoutesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listIpRoutesRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, listIpRoutesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListLogSubscriptionsResponse> listLogSubscriptions(ListLogSubscriptionsRequest listLogSubscriptionsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListLogSubscriptions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLogSubscriptionsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLogSubscriptions").withMarshaller((Marshaller)new ListLogSubscriptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)listLogSubscriptionsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listLogSubscriptionsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, listLogSubscriptionsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListSchemaExtensionsResponse> listSchemaExtensions(ListSchemaExtensionsRequest listSchemaExtensionsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSchemaExtensions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSchemaExtensionsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSchemaExtensions").withMarshaller((Marshaller)new ListSchemaExtensionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)listSchemaExtensionsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listSchemaExtensionsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, listSchemaExtensionsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)listTagsForResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listTagsForResourceRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RegisterCertificateResponse> registerCertificate(RegisterCertificateRequest registerCertificateRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterCertificateResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterCertificate").withMarshaller((Marshaller)new RegisterCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)registerCertificateRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = registerCertificateRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, registerCertificateRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RegisterEventTopicResponse> registerEventTopic(RegisterEventTopicRequest registerEventTopicRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterEventTopic");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterEventTopicResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterEventTopic").withMarshaller((Marshaller)new RegisterEventTopicRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)registerEventTopicRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = registerEventTopicRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, registerEventTopicRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RejectSharedDirectoryResponse> rejectSharedDirectory(RejectSharedDirectoryRequest rejectSharedDirectoryRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RejectSharedDirectory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RejectSharedDirectoryResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RejectSharedDirectory").withMarshaller((Marshaller)new RejectSharedDirectoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)rejectSharedDirectoryRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = rejectSharedDirectoryRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, rejectSharedDirectoryRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RemoveIpRoutesResponse> removeIpRoutes(RemoveIpRoutesRequest removeIpRoutesRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveIpRoutes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveIpRoutesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveIpRoutes").withMarshaller((Marshaller)new RemoveIpRoutesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)removeIpRoutesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = removeIpRoutesRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, removeIpRoutesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RemoveTagsFromResourceResponse> removeTagsFromResource(RemoveTagsFromResourceRequest removeTagsFromResourceRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveTagsFromResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveTagsFromResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveTagsFromResource").withMarshaller((Marshaller)new RemoveTagsFromResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)removeTagsFromResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = removeTagsFromResourceRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, removeTagsFromResourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ResetUserPasswordResponse> resetUserPassword(ResetUserPasswordRequest resetUserPasswordRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ResetUserPassword");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ResetUserPasswordResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResetUserPassword").withMarshaller((Marshaller)new ResetUserPasswordRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)resetUserPasswordRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = resetUserPasswordRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, resetUserPasswordRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RestoreFromSnapshotResponse> restoreFromSnapshot(RestoreFromSnapshotRequest restoreFromSnapshotRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RestoreFromSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RestoreFromSnapshotResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestoreFromSnapshot").withMarshaller((Marshaller)new RestoreFromSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)restoreFromSnapshotRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = restoreFromSnapshotRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, restoreFromSnapshotRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ShareDirectoryResponse> shareDirectory(ShareDirectoryRequest shareDirectoryRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ShareDirectory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ShareDirectoryResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ShareDirectory").withMarshaller((Marshaller)new ShareDirectoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)shareDirectoryRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = shareDirectoryRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, shareDirectoryRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartSchemaExtensionResponse> startSchemaExtension(StartSchemaExtensionRequest startSchemaExtensionRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartSchemaExtension");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartSchemaExtensionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartSchemaExtension").withMarshaller((Marshaller)new StartSchemaExtensionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)startSchemaExtensionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = startSchemaExtensionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, startSchemaExtensionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UnshareDirectoryResponse> unshareDirectory(UnshareDirectoryRequest unshareDirectoryRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UnshareDirectory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UnshareDirectoryResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UnshareDirectory").withMarshaller((Marshaller)new UnshareDirectoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)unshareDirectoryRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = unshareDirectoryRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, unshareDirectoryRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateConditionalForwarderResponse> updateConditionalForwarder(UpdateConditionalForwarderRequest updateConditionalForwarderRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateConditionalForwarder");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateConditionalForwarderResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateConditionalForwarder").withMarshaller((Marshaller)new UpdateConditionalForwarderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)updateConditionalForwarderRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateConditionalForwarderRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateConditionalForwarderRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateNumberOfDomainControllersResponse> updateNumberOfDomainControllers(UpdateNumberOfDomainControllersRequest updateNumberOfDomainControllersRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateNumberOfDomainControllers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateNumberOfDomainControllersResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateNumberOfDomainControllers").withMarshaller((Marshaller)new UpdateNumberOfDomainControllersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)updateNumberOfDomainControllersRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateNumberOfDomainControllersRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateNumberOfDomainControllersRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateRadiusResponse> updateRadius(UpdateRadiusRequest updateRadiusRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateRadius");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateRadiusResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateRadius").withMarshaller((Marshaller)new UpdateRadiusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)updateRadiusRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateRadiusRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateRadiusRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateTrustResponse> updateTrust(UpdateTrustRequest updateTrustRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateTrust");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTrustResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTrust").withMarshaller((Marshaller)new UpdateTrustRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)updateTrustRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateTrustRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateTrustRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<VerifyTrustResponse> verifyTrust(VerifyTrustRequest verifyTrustRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"VerifyTrust");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, VerifyTrustResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("VerifyTrust").withMarshaller((Marshaller)new VerifyTrustRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)verifyTrustRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = verifyTrustRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, verifyTrustRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(DirectoryException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").exceptionBuilderSupplier(DirectoryUnavailableException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidCertificateException").exceptionBuilderSupplier(InvalidCertificateException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").exceptionBuilderSupplier(DirectoryNotSharedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").exceptionBuilderSupplier(EntityDoesNotExistException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").exceptionBuilderSupplier(InvalidNextTokenException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").exceptionBuilderSupplier(UserDoesNotExistException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidPasswordException").exceptionBuilderSupplier(InvalidPasswordException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").exceptionBuilderSupplier(UnsupportedOperationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClientException").exceptionBuilderSupplier(ClientException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").exceptionBuilderSupplier(AuthenticationFailedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").exceptionBuilderSupplier(InsufficientPermissionsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").exceptionBuilderSupplier(CertificateLimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OrganizationsException").exceptionBuilderSupplier(OrganizationsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidParameterException").exceptionBuilderSupplier(InvalidParameterException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceException").exceptionBuilderSupplier(ServiceException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").exceptionBuilderSupplier(NoAvailableCertificateException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTargetException").exceptionBuilderSupplier(InvalidTargetException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TagLimitExceededException").exceptionBuilderSupplier(TagLimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").exceptionBuilderSupplier(ShareLimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CertificateInUseException").exceptionBuilderSupplier(CertificateInUseException::builder).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private <T extends DirectoryRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.13.61").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((DirectoryRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }
}

