/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directory.model.DirectoryResponse;
import software.amazon.awssdk.services.directory.model.SchemaExtensionInfo;
import software.amazon.awssdk.services.directory.model.SchemaExtensionsInfoCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSchemaExtensionsResponse
extends DirectoryResponse
implements ToCopyableBuilder<Builder, ListSchemaExtensionsResponse> {
    private static final SdkField<List<SchemaExtensionInfo>> SCHEMA_EXTENSIONS_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListSchemaExtensionsResponse.getter(ListSchemaExtensionsResponse::schemaExtensionsInfo)).setter(ListSchemaExtensionsResponse.setter(Builder::schemaExtensionsInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaExtensionsInfo").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SchemaExtensionInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListSchemaExtensionsResponse.getter(ListSchemaExtensionsResponse::nextToken)).setter(ListSchemaExtensionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_EXTENSIONS_INFO_FIELD, NEXT_TOKEN_FIELD));
    private final List<SchemaExtensionInfo> schemaExtensionsInfo;
    private final String nextToken;

    private ListSchemaExtensionsResponse(BuilderImpl builder) {
        super(builder);
        this.schemaExtensionsInfo = builder.schemaExtensionsInfo;
        this.nextToken = builder.nextToken;
    }

    public boolean hasSchemaExtensionsInfo() {
        return this.schemaExtensionsInfo != null && !(this.schemaExtensionsInfo instanceof SdkAutoConstructList);
    }

    public List<SchemaExtensionInfo> schemaExtensionsInfo() {
        return this.schemaExtensionsInfo;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaExtensionsInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSchemaExtensionsResponse)) {
            return false;
        }
        ListSchemaExtensionsResponse other = (ListSchemaExtensionsResponse)((Object)obj);
        return Objects.equals(this.schemaExtensionsInfo(), other.schemaExtensionsInfo()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListSchemaExtensionsResponse").add("SchemaExtensionsInfo", this.schemaExtensionsInfo()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SchemaExtensionsInfo": {
                return Optional.ofNullable(clazz.cast(this.schemaExtensionsInfo()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSchemaExtensionsResponse, T> g) {
        return obj -> g.apply((ListSchemaExtensionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectoryResponse.BuilderImpl
    implements Builder {
        private List<SchemaExtensionInfo> schemaExtensionsInfo = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSchemaExtensionsResponse model) {
            super(model);
            this.schemaExtensionsInfo(model.schemaExtensionsInfo);
            this.nextToken(model.nextToken);
        }

        public final Collection<SchemaExtensionInfo.Builder> getSchemaExtensionsInfo() {
            return this.schemaExtensionsInfo != null ? (Collection)this.schemaExtensionsInfo.stream().map(SchemaExtensionInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder schemaExtensionsInfo(Collection<SchemaExtensionInfo> schemaExtensionsInfo) {
            this.schemaExtensionsInfo = SchemaExtensionsInfoCopier.copy(schemaExtensionsInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemaExtensionsInfo(SchemaExtensionInfo ... schemaExtensionsInfo) {
            this.schemaExtensionsInfo(Arrays.asList(schemaExtensionsInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemaExtensionsInfo(Consumer<SchemaExtensionInfo.Builder> ... schemaExtensionsInfo) {
            this.schemaExtensionsInfo(Stream.of(schemaExtensionsInfo).map(c -> (SchemaExtensionInfo)((SchemaExtensionInfo.Builder)SchemaExtensionInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSchemaExtensionsInfo(Collection<SchemaExtensionInfo.BuilderImpl> schemaExtensionsInfo) {
            this.schemaExtensionsInfo = SchemaExtensionsInfoCopier.copyFromBuilder(schemaExtensionsInfo);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListSchemaExtensionsResponse build() {
            return new ListSchemaExtensionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DirectoryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSchemaExtensionsResponse> {
        public Builder schemaExtensionsInfo(Collection<SchemaExtensionInfo> var1);

        public Builder schemaExtensionsInfo(SchemaExtensionInfo ... var1);

        public Builder schemaExtensionsInfo(Consumer<SchemaExtensionInfo.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

