/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directory.model.SelectiveAuth;
import software.amazon.awssdk.services.directory.model.TrustDirection;
import software.amazon.awssdk.services.directory.model.TrustState;
import software.amazon.awssdk.services.directory.model.TrustType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Trust
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Trust> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Trust.getter(Trust::directoryId)).setter(Trust.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()}).build();
    private static final SdkField<String> TRUST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Trust.getter(Trust::trustId)).setter(Trust.setter(Builder::trustId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustId").build()}).build();
    private static final SdkField<String> REMOTE_DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Trust.getter(Trust::remoteDomainName)).setter(Trust.setter(Builder::remoteDomainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoteDomainName").build()}).build();
    private static final SdkField<String> TRUST_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Trust.getter(Trust::trustTypeAsString)).setter(Trust.setter(Builder::trustType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustType").build()}).build();
    private static final SdkField<String> TRUST_DIRECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Trust.getter(Trust::trustDirectionAsString)).setter(Trust.setter(Builder::trustDirection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustDirection").build()}).build();
    private static final SdkField<String> TRUST_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Trust.getter(Trust::trustStateAsString)).setter(Trust.setter(Builder::trustState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustState").build()}).build();
    private static final SdkField<Instant> CREATED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Trust.getter(Trust::createdDateTime)).setter(Trust.setter(Builder::createdDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDateTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Trust.getter(Trust::lastUpdatedDateTime)).setter(Trust.setter(Builder::lastUpdatedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedDateTime").build()}).build();
    private static final SdkField<Instant> STATE_LAST_UPDATED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Trust.getter(Trust::stateLastUpdatedDateTime)).setter(Trust.setter(Builder::stateLastUpdatedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateLastUpdatedDateTime").build()}).build();
    private static final SdkField<String> TRUST_STATE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Trust.getter(Trust::trustStateReason)).setter(Trust.setter(Builder::trustStateReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustStateReason").build()}).build();
    private static final SdkField<String> SELECTIVE_AUTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Trust.getter(Trust::selectiveAuthAsString)).setter(Trust.setter(Builder::selectiveAuth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectiveAuth").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD, TRUST_ID_FIELD, REMOTE_DOMAIN_NAME_FIELD, TRUST_TYPE_FIELD, TRUST_DIRECTION_FIELD, TRUST_STATE_FIELD, CREATED_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD, STATE_LAST_UPDATED_DATE_TIME_FIELD, TRUST_STATE_REASON_FIELD, SELECTIVE_AUTH_FIELD));
    private static final long serialVersionUID = 1L;
    private final String directoryId;
    private final String trustId;
    private final String remoteDomainName;
    private final String trustType;
    private final String trustDirection;
    private final String trustState;
    private final Instant createdDateTime;
    private final Instant lastUpdatedDateTime;
    private final Instant stateLastUpdatedDateTime;
    private final String trustStateReason;
    private final String selectiveAuth;

    private Trust(BuilderImpl builder) {
        this.directoryId = builder.directoryId;
        this.trustId = builder.trustId;
        this.remoteDomainName = builder.remoteDomainName;
        this.trustType = builder.trustType;
        this.trustDirection = builder.trustDirection;
        this.trustState = builder.trustState;
        this.createdDateTime = builder.createdDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
        this.stateLastUpdatedDateTime = builder.stateLastUpdatedDateTime;
        this.trustStateReason = builder.trustStateReason;
        this.selectiveAuth = builder.selectiveAuth;
    }

    public String directoryId() {
        return this.directoryId;
    }

    public String trustId() {
        return this.trustId;
    }

    public String remoteDomainName() {
        return this.remoteDomainName;
    }

    public TrustType trustType() {
        return TrustType.fromValue(this.trustType);
    }

    public String trustTypeAsString() {
        return this.trustType;
    }

    public TrustDirection trustDirection() {
        return TrustDirection.fromValue(this.trustDirection);
    }

    public String trustDirectionAsString() {
        return this.trustDirection;
    }

    public TrustState trustState() {
        return TrustState.fromValue(this.trustState);
    }

    public String trustStateAsString() {
        return this.trustState;
    }

    public Instant createdDateTime() {
        return this.createdDateTime;
    }

    public Instant lastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public Instant stateLastUpdatedDateTime() {
        return this.stateLastUpdatedDateTime;
    }

    public String trustStateReason() {
        return this.trustStateReason;
    }

    public SelectiveAuth selectiveAuth() {
        return SelectiveAuth.fromValue(this.selectiveAuth);
    }

    public String selectiveAuthAsString() {
        return this.selectiveAuth;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.trustId());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteDomainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.trustTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.trustDirectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.trustStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateLastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.trustStateReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectiveAuthAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Trust)) {
            return false;
        }
        Trust other = (Trust)obj;
        return Objects.equals(this.directoryId(), other.directoryId()) && Objects.equals(this.trustId(), other.trustId()) && Objects.equals(this.remoteDomainName(), other.remoteDomainName()) && Objects.equals(this.trustTypeAsString(), other.trustTypeAsString()) && Objects.equals(this.trustDirectionAsString(), other.trustDirectionAsString()) && Objects.equals(this.trustStateAsString(), other.trustStateAsString()) && Objects.equals(this.createdDateTime(), other.createdDateTime()) && Objects.equals(this.lastUpdatedDateTime(), other.lastUpdatedDateTime()) && Objects.equals(this.stateLastUpdatedDateTime(), other.stateLastUpdatedDateTime()) && Objects.equals(this.trustStateReason(), other.trustStateReason()) && Objects.equals(this.selectiveAuthAsString(), other.selectiveAuthAsString());
    }

    public String toString() {
        return ToString.builder((String)"Trust").add("DirectoryId", (Object)this.directoryId()).add("TrustId", (Object)this.trustId()).add("RemoteDomainName", (Object)this.remoteDomainName()).add("TrustType", (Object)this.trustTypeAsString()).add("TrustDirection", (Object)this.trustDirectionAsString()).add("TrustState", (Object)this.trustStateAsString()).add("CreatedDateTime", (Object)this.createdDateTime()).add("LastUpdatedDateTime", (Object)this.lastUpdatedDateTime()).add("StateLastUpdatedDateTime", (Object)this.stateLastUpdatedDateTime()).add("TrustStateReason", (Object)this.trustStateReason()).add("SelectiveAuth", (Object)this.selectiveAuthAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "TrustId": {
                return Optional.ofNullable(clazz.cast(this.trustId()));
            }
            case "RemoteDomainName": {
                return Optional.ofNullable(clazz.cast(this.remoteDomainName()));
            }
            case "TrustType": {
                return Optional.ofNullable(clazz.cast(this.trustTypeAsString()));
            }
            case "TrustDirection": {
                return Optional.ofNullable(clazz.cast(this.trustDirectionAsString()));
            }
            case "TrustState": {
                return Optional.ofNullable(clazz.cast(this.trustStateAsString()));
            }
            case "CreatedDateTime": {
                return Optional.ofNullable(clazz.cast(this.createdDateTime()));
            }
            case "LastUpdatedDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDateTime()));
            }
            case "StateLastUpdatedDateTime": {
                return Optional.ofNullable(clazz.cast(this.stateLastUpdatedDateTime()));
            }
            case "TrustStateReason": {
                return Optional.ofNullable(clazz.cast(this.trustStateReason()));
            }
            case "SelectiveAuth": {
                return Optional.ofNullable(clazz.cast(this.selectiveAuthAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Trust, T> g) {
        return obj -> g.apply((Trust)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String directoryId;
        private String trustId;
        private String remoteDomainName;
        private String trustType;
        private String trustDirection;
        private String trustState;
        private Instant createdDateTime;
        private Instant lastUpdatedDateTime;
        private Instant stateLastUpdatedDateTime;
        private String trustStateReason;
        private String selectiveAuth;

        private BuilderImpl() {
        }

        private BuilderImpl(Trust model) {
            this.directoryId(model.directoryId);
            this.trustId(model.trustId);
            this.remoteDomainName(model.remoteDomainName);
            this.trustType(model.trustType);
            this.trustDirection(model.trustDirection);
            this.trustState(model.trustState);
            this.createdDateTime(model.createdDateTime);
            this.lastUpdatedDateTime(model.lastUpdatedDateTime);
            this.stateLastUpdatedDateTime(model.stateLastUpdatedDateTime);
            this.trustStateReason(model.trustStateReason);
            this.selectiveAuth(model.selectiveAuth);
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        public final String getTrustId() {
            return this.trustId;
        }

        @Override
        public final Builder trustId(String trustId) {
            this.trustId = trustId;
            return this;
        }

        public final void setTrustId(String trustId) {
            this.trustId = trustId;
        }

        public final String getRemoteDomainName() {
            return this.remoteDomainName;
        }

        @Override
        public final Builder remoteDomainName(String remoteDomainName) {
            this.remoteDomainName = remoteDomainName;
            return this;
        }

        public final void setRemoteDomainName(String remoteDomainName) {
            this.remoteDomainName = remoteDomainName;
        }

        public final String getTrustType() {
            return this.trustType;
        }

        @Override
        public final Builder trustType(String trustType) {
            this.trustType = trustType;
            return this;
        }

        @Override
        public final Builder trustType(TrustType trustType) {
            this.trustType(trustType == null ? null : trustType.toString());
            return this;
        }

        public final void setTrustType(String trustType) {
            this.trustType = trustType;
        }

        public final String getTrustDirection() {
            return this.trustDirection;
        }

        @Override
        public final Builder trustDirection(String trustDirection) {
            this.trustDirection = trustDirection;
            return this;
        }

        @Override
        public final Builder trustDirection(TrustDirection trustDirection) {
            this.trustDirection(trustDirection == null ? null : trustDirection.toString());
            return this;
        }

        public final void setTrustDirection(String trustDirection) {
            this.trustDirection = trustDirection;
        }

        public final String getTrustState() {
            return this.trustState;
        }

        @Override
        public final Builder trustState(String trustState) {
            this.trustState = trustState;
            return this;
        }

        @Override
        public final Builder trustState(TrustState trustState) {
            this.trustState(trustState == null ? null : trustState.toString());
            return this;
        }

        public final void setTrustState(String trustState) {
            this.trustState = trustState;
        }

        public final Instant getCreatedDateTime() {
            return this.createdDateTime;
        }

        @Override
        public final Builder createdDateTime(Instant createdDateTime) {
            this.createdDateTime = createdDateTime;
            return this;
        }

        public final void setCreatedDateTime(Instant createdDateTime) {
            this.createdDateTime = createdDateTime;
        }

        public final Instant getLastUpdatedDateTime() {
            return this.lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        public final Instant getStateLastUpdatedDateTime() {
            return this.stateLastUpdatedDateTime;
        }

        @Override
        public final Builder stateLastUpdatedDateTime(Instant stateLastUpdatedDateTime) {
            this.stateLastUpdatedDateTime = stateLastUpdatedDateTime;
            return this;
        }

        public final void setStateLastUpdatedDateTime(Instant stateLastUpdatedDateTime) {
            this.stateLastUpdatedDateTime = stateLastUpdatedDateTime;
        }

        public final String getTrustStateReason() {
            return this.trustStateReason;
        }

        @Override
        public final Builder trustStateReason(String trustStateReason) {
            this.trustStateReason = trustStateReason;
            return this;
        }

        public final void setTrustStateReason(String trustStateReason) {
            this.trustStateReason = trustStateReason;
        }

        public final String getSelectiveAuth() {
            return this.selectiveAuth;
        }

        @Override
        public final Builder selectiveAuth(String selectiveAuth) {
            this.selectiveAuth = selectiveAuth;
            return this;
        }

        @Override
        public final Builder selectiveAuth(SelectiveAuth selectiveAuth) {
            this.selectiveAuth(selectiveAuth == null ? null : selectiveAuth.toString());
            return this;
        }

        public final void setSelectiveAuth(String selectiveAuth) {
            this.selectiveAuth = selectiveAuth;
        }

        public Trust build() {
            return new Trust(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Trust> {
        public Builder directoryId(String var1);

        public Builder trustId(String var1);

        public Builder remoteDomainName(String var1);

        public Builder trustType(String var1);

        public Builder trustType(TrustType var1);

        public Builder trustDirection(String var1);

        public Builder trustDirection(TrustDirection var1);

        public Builder trustState(String var1);

        public Builder trustState(TrustState var1);

        public Builder createdDateTime(Instant var1);

        public Builder lastUpdatedDateTime(Instant var1);

        public Builder stateLastUpdatedDateTime(Instant var1);

        public Builder trustStateReason(String var1);

        public Builder selectiveAuth(String var1);

        public Builder selectiveAuth(SelectiveAuth var1);
    }
}

