/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of a DescribeEventTopic request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEventTopicsResponse extends DirectoryResponse implements
        ToCopyableBuilder<DescribeEventTopicsResponse.Builder, DescribeEventTopicsResponse> {
    private static final SdkField<List<EventTopic>> EVENT_TOPICS_FIELD = SdkField
            .<List<EventTopic>> builder(MarshallingType.LIST)
            .getter(getter(DescribeEventTopicsResponse::eventTopics))
            .setter(setter(Builder::eventTopics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTopics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EventTopic> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventTopic::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_TOPICS_FIELD));

    private final List<EventTopic> eventTopics;

    private DescribeEventTopicsResponse(BuilderImpl builder) {
        super(builder);
        this.eventTopics = builder.eventTopics;
    }

    /**
     * Returns true if the EventTopics property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasEventTopics() {
        return eventTopics != null && !(eventTopics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of SNS topic names that receive status messages from the specified Directory ID.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEventTopics()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of SNS topic names that receive status messages from the specified Directory ID.
     */
    public List<EventTopic> eventTopics() {
        return eventTopics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(eventTopics());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventTopicsResponse)) {
            return false;
        }
        DescribeEventTopicsResponse other = (DescribeEventTopicsResponse) obj;
        return Objects.equals(eventTopics(), other.eventTopics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeEventTopicsResponse").add("EventTopics", eventTopics()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventTopics":
            return Optional.ofNullable(clazz.cast(eventTopics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEventTopicsResponse, T> g) {
        return obj -> g.apply((DescribeEventTopicsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectoryResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeEventTopicsResponse> {
        /**
         * <p>
         * A list of SNS topic names that receive status messages from the specified Directory ID.
         * </p>
         * 
         * @param eventTopics
         *        A list of SNS topic names that receive status messages from the specified Directory ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTopics(Collection<EventTopic> eventTopics);

        /**
         * <p>
         * A list of SNS topic names that receive status messages from the specified Directory ID.
         * </p>
         * 
         * @param eventTopics
         *        A list of SNS topic names that receive status messages from the specified Directory ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTopics(EventTopic... eventTopics);

        /**
         * <p>
         * A list of SNS topic names that receive status messages from the specified Directory ID.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EventTopic>.Builder} avoiding the need to
         * create one manually via {@link List<EventTopic>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EventTopic>.Builder#build()} is called immediately and its
         * result is passed to {@link #eventTopics(List<EventTopic>)}.
         * 
         * @param eventTopics
         *        a consumer that will call methods on {@link List<EventTopic>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventTopics(List<EventTopic>)
         */
        Builder eventTopics(Consumer<EventTopic.Builder>... eventTopics);
    }

    static final class BuilderImpl extends DirectoryResponse.BuilderImpl implements Builder {
        private List<EventTopic> eventTopics = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventTopicsResponse model) {
            super(model);
            eventTopics(model.eventTopics);
        }

        public final Collection<EventTopic.Builder> getEventTopics() {
            return eventTopics != null ? eventTopics.stream().map(EventTopic::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder eventTopics(Collection<EventTopic> eventTopics) {
            this.eventTopics = EventTopicsCopier.copy(eventTopics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTopics(EventTopic... eventTopics) {
            eventTopics(Arrays.asList(eventTopics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTopics(Consumer<EventTopic.Builder>... eventTopics) {
            eventTopics(Stream.of(eventTopics).map(c -> EventTopic.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEventTopics(Collection<EventTopic.BuilderImpl> eventTopics) {
            this.eventTopics = EventTopicsCopier.copyFromBuilder(eventTopics);
        }

        @Override
        public DescribeEventTopicsResponse build() {
            return new DescribeEventTopicsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
