/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResetUserPasswordRequest extends DirectoryRequest implements
        ToCopyableBuilder<ResetUserPasswordRequest.Builder, ResetUserPasswordRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResetUserPasswordRequest::directoryId)).setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResetUserPasswordRequest::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final SdkField<String> NEW_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResetUserPasswordRequest::newPassword)).setter(setter(Builder::newPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewPassword").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD,
            USER_NAME_FIELD, NEW_PASSWORD_FIELD));

    private final String directoryId;

    private final String userName;

    private final String newPassword;

    private ResetUserPasswordRequest(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.userName = builder.userName;
        this.newPassword = builder.newPassword;
    }

    /**
     * <p>
     * Identifier of the AWS Managed Microsoft AD or Simple AD directory in which the user resides.
     * </p>
     * 
     * @return Identifier of the AWS Managed Microsoft AD or Simple AD directory in which the user resides.
     */
    public String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * The user name of the user whose password will be reset.
     * </p>
     * 
     * @return The user name of the user whose password will be reset.
     */
    public String userName() {
        return userName;
    }

    /**
     * <p>
     * The new password that will be reset.
     * </p>
     * 
     * @return The new password that will be reset.
     */
    public String newPassword() {
        return newPassword;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        hashCode = 31 * hashCode + Objects.hashCode(newPassword());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResetUserPasswordRequest)) {
            return false;
        }
        ResetUserPasswordRequest other = (ResetUserPasswordRequest) obj;
        return Objects.equals(directoryId(), other.directoryId()) && Objects.equals(userName(), other.userName())
                && Objects.equals(newPassword(), other.newPassword());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ResetUserPasswordRequest").add("DirectoryId", directoryId()).add("UserName", userName())
                .add("NewPassword", newPassword() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        case "NewPassword":
            return Optional.ofNullable(clazz.cast(newPassword()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResetUserPasswordRequest, T> g) {
        return obj -> g.apply((ResetUserPasswordRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectoryRequest.Builder, SdkPojo, CopyableBuilder<Builder, ResetUserPasswordRequest> {
        /**
         * <p>
         * Identifier of the AWS Managed Microsoft AD or Simple AD directory in which the user resides.
         * </p>
         * 
         * @param directoryId
         *        Identifier of the AWS Managed Microsoft AD or Simple AD directory in which the user resides.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * The user name of the user whose password will be reset.
         * </p>
         * 
         * @param userName
         *        The user name of the user whose password will be reset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);

        /**
         * <p>
         * The new password that will be reset.
         * </p>
         * 
         * @param newPassword
         *        The new password that will be reset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newPassword(String newPassword);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectoryRequest.BuilderImpl implements Builder {
        private String directoryId;

        private String userName;

        private String newPassword;

        private BuilderImpl() {
        }

        private BuilderImpl(ResetUserPasswordRequest model) {
            super(model);
            directoryId(model.directoryId);
            userName(model.userName);
            newPassword(model.newPassword);
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        public final String getUserName() {
            return userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getNewPassword() {
            return newPassword;
        }

        @Override
        public final Builder newPassword(String newPassword) {
            this.newPassword = newPassword;
            return this;
        }

        public final void setNewPassword(String newPassword) {
            this.newPassword = newPassword;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ResetUserPasswordRequest build() {
            return new ResetUserPasswordRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
