/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DirectoryType {
    SIMPLE_AD("SimpleAD"),
    AD_CONNECTOR("ADConnector"),
    MICROSOFT_AD("MicrosoftAD"),
    SHARED_MICROSOFT_AD("SharedMicrosoftAD"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DirectoryType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DirectoryType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DirectoryType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DirectoryType> knownValues() {
        return Stream.of(DirectoryType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

