/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum TopicStatus {
    REGISTERED("Registered"),
    TOPIC_NOT_FOUND("Topic not found"),
    FAILED("Failed"),
    DELETED("Deleted"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private TopicStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TopicStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(TopicStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TopicStatus> knownValues() {
        return Stream.of(TopicStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

