/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a conditional forwarder.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeConditionalForwardersRequest extends DirectoryRequest implements
        ToCopyableBuilder<DescribeConditionalForwardersRequest.Builder, DescribeConditionalForwardersRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(DescribeConditionalForwardersRequest::directoryId))
            .setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<List<String>> REMOTE_DOMAIN_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RemoteDomainNames")
            .getter(getter(DescribeConditionalForwardersRequest::remoteDomainNames))
            .setter(setter(Builder::remoteDomainNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoteDomainNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD,
            REMOTE_DOMAIN_NAMES_FIELD));

    private final String directoryId;

    private final List<String> remoteDomainNames;

    private DescribeConditionalForwardersRequest(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.remoteDomainNames = builder.remoteDomainNames;
    }

    /**
     * <p>
     * The directory ID for which to get the list of associated conditional forwarders.
     * </p>
     * 
     * @return The directory ID for which to get the list of associated conditional forwarders.
     */
    public String directoryId() {
        return directoryId;
    }

    /**
     * Returns true if the RemoteDomainNames property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasRemoteDomainNames() {
        return remoteDomainNames != null && !(remoteDomainNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The fully qualified domain names (FQDN) of the remote domains for which to get the list of associated conditional
     * forwarders. If this member is null, all conditional forwarders are returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRemoteDomainNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The fully qualified domain names (FQDN) of the remote domains for which to get the list of associated
     *         conditional forwarders. If this member is null, all conditional forwarders are returned.
     */
    public List<String> remoteDomainNames() {
        return remoteDomainNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(hasRemoteDomainNames() ? remoteDomainNames() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConditionalForwardersRequest)) {
            return false;
        }
        DescribeConditionalForwardersRequest other = (DescribeConditionalForwardersRequest) obj;
        return Objects.equals(directoryId(), other.directoryId()) && hasRemoteDomainNames() == other.hasRemoteDomainNames()
                && Objects.equals(remoteDomainNames(), other.remoteDomainNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeConditionalForwardersRequest").add("DirectoryId", directoryId())
                .add("RemoteDomainNames", hasRemoteDomainNames() ? remoteDomainNames() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "RemoteDomainNames":
            return Optional.ofNullable(clazz.cast(remoteDomainNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConditionalForwardersRequest, T> g) {
        return obj -> g.apply((DescribeConditionalForwardersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectoryRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeConditionalForwardersRequest> {
        /**
         * <p>
         * The directory ID for which to get the list of associated conditional forwarders.
         * </p>
         * 
         * @param directoryId
         *        The directory ID for which to get the list of associated conditional forwarders.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * The fully qualified domain names (FQDN) of the remote domains for which to get the list of associated
         * conditional forwarders. If this member is null, all conditional forwarders are returned.
         * </p>
         * 
         * @param remoteDomainNames
         *        The fully qualified domain names (FQDN) of the remote domains for which to get the list of associated
         *        conditional forwarders. If this member is null, all conditional forwarders are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteDomainNames(Collection<String> remoteDomainNames);

        /**
         * <p>
         * The fully qualified domain names (FQDN) of the remote domains for which to get the list of associated
         * conditional forwarders. If this member is null, all conditional forwarders are returned.
         * </p>
         * 
         * @param remoteDomainNames
         *        The fully qualified domain names (FQDN) of the remote domains for which to get the list of associated
         *        conditional forwarders. If this member is null, all conditional forwarders are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteDomainNames(String... remoteDomainNames);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectoryRequest.BuilderImpl implements Builder {
        private String directoryId;

        private List<String> remoteDomainNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConditionalForwardersRequest model) {
            super(model);
            directoryId(model.directoryId);
            remoteDomainNames(model.remoteDomainNames);
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        public final Collection<String> getRemoteDomainNames() {
            if (remoteDomainNames instanceof SdkAutoConstructList) {
                return null;
            }
            return remoteDomainNames;
        }

        @Override
        public final Builder remoteDomainNames(Collection<String> remoteDomainNames) {
            this.remoteDomainNames = RemoteDomainNamesCopier.copy(remoteDomainNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remoteDomainNames(String... remoteDomainNames) {
            remoteDomainNames(Arrays.asList(remoteDomainNames));
            return this;
        }

        public final void setRemoteDomainNames(Collection<String> remoteDomainNames) {
            this.remoteDomainNames = RemoteDomainNamesCopier.copy(remoteDomainNames);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeConditionalForwardersRequest build() {
            return new DescribeConditionalForwardersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
