/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLdapsSettingsResponse extends DirectoryResponse implements
        ToCopyableBuilder<DescribeLdapsSettingsResponse.Builder, DescribeLdapsSettingsResponse> {
    private static final SdkField<List<LDAPSSettingInfo>> LDAPS_SETTINGS_INFO_FIELD = SdkField
            .<List<LDAPSSettingInfo>> builder(MarshallingType.LIST)
            .memberName("LDAPSSettingsInfo")
            .getter(getter(DescribeLdapsSettingsResponse::ldapsSettingsInfo))
            .setter(setter(Builder::ldapsSettingsInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LDAPSSettingsInfo").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LDAPSSettingInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(LDAPSSettingInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeLdapsSettingsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LDAPS_SETTINGS_INFO_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<LDAPSSettingInfo> ldapsSettingsInfo;

    private final String nextToken;

    private DescribeLdapsSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.ldapsSettingsInfo = builder.ldapsSettingsInfo;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the LDAPSSettingsInfo property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasLdapsSettingsInfo() {
        return ldapsSettingsInfo != null && !(ldapsSettingsInfo instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about LDAP security for the specified directory, including status of enablement, state last updated
     * date time, and the reason for the state.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLdapsSettingsInfo()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about LDAP security for the specified directory, including status of enablement, state last
     *         updated date time, and the reason for the state.
     */
    public List<LDAPSSettingInfo> ldapsSettingsInfo() {
        return ldapsSettingsInfo;
    }

    /**
     * <p>
     * The next token used to retrieve the LDAPS settings if the number of setting types exceeds page limit and there is
     * another page.
     * </p>
     * 
     * @return The next token used to retrieve the LDAPS settings if the number of setting types exceeds page limit and
     *         there is another page.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLdapsSettingsInfo() ? ldapsSettingsInfo() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLdapsSettingsResponse)) {
            return false;
        }
        DescribeLdapsSettingsResponse other = (DescribeLdapsSettingsResponse) obj;
        return hasLdapsSettingsInfo() == other.hasLdapsSettingsInfo()
                && Objects.equals(ldapsSettingsInfo(), other.ldapsSettingsInfo())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeLdapsSettingsResponse")
                .add("LDAPSSettingsInfo", hasLdapsSettingsInfo() ? ldapsSettingsInfo() : null).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LDAPSSettingsInfo":
            return Optional.ofNullable(clazz.cast(ldapsSettingsInfo()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLdapsSettingsResponse, T> g) {
        return obj -> g.apply((DescribeLdapsSettingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectoryResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeLdapsSettingsResponse> {
        /**
         * <p>
         * Information about LDAP security for the specified directory, including status of enablement, state last
         * updated date time, and the reason for the state.
         * </p>
         * 
         * @param ldapsSettingsInfo
         *        Information about LDAP security for the specified directory, including status of enablement, state
         *        last updated date time, and the reason for the state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ldapsSettingsInfo(Collection<LDAPSSettingInfo> ldapsSettingsInfo);

        /**
         * <p>
         * Information about LDAP security for the specified directory, including status of enablement, state last
         * updated date time, and the reason for the state.
         * </p>
         * 
         * @param ldapsSettingsInfo
         *        Information about LDAP security for the specified directory, including status of enablement, state
         *        last updated date time, and the reason for the state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ldapsSettingsInfo(LDAPSSettingInfo... ldapsSettingsInfo);

        /**
         * <p>
         * Information about LDAP security for the specified directory, including status of enablement, state last
         * updated date time, and the reason for the state.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LDAPSSettingInfo>.Builder} avoiding the
         * need to create one manually via {@link List<LDAPSSettingInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LDAPSSettingInfo>.Builder#build()} is called immediately and
         * its result is passed to {@link #ldapsSettingsInfo(List<LDAPSSettingInfo>)}.
         * 
         * @param ldapsSettingsInfo
         *        a consumer that will call methods on {@link List<LDAPSSettingInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ldapsSettingsInfo(List<LDAPSSettingInfo>)
         */
        Builder ldapsSettingsInfo(Consumer<LDAPSSettingInfo.Builder>... ldapsSettingsInfo);

        /**
         * <p>
         * The next token used to retrieve the LDAPS settings if the number of setting types exceeds page limit and
         * there is another page.
         * </p>
         * 
         * @param nextToken
         *        The next token used to retrieve the LDAPS settings if the number of setting types exceeds page limit
         *        and there is another page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DirectoryResponse.BuilderImpl implements Builder {
        private List<LDAPSSettingInfo> ldapsSettingsInfo = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLdapsSettingsResponse model) {
            super(model);
            ldapsSettingsInfo(model.ldapsSettingsInfo);
            nextToken(model.nextToken);
        }

        public final Collection<LDAPSSettingInfo.Builder> getLdapsSettingsInfo() {
            if (ldapsSettingsInfo instanceof SdkAutoConstructList) {
                return null;
            }
            return ldapsSettingsInfo != null ? ldapsSettingsInfo.stream().map(LDAPSSettingInfo::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ldapsSettingsInfo(Collection<LDAPSSettingInfo> ldapsSettingsInfo) {
            this.ldapsSettingsInfo = LDAPSSettingsInfoCopier.copy(ldapsSettingsInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ldapsSettingsInfo(LDAPSSettingInfo... ldapsSettingsInfo) {
            ldapsSettingsInfo(Arrays.asList(ldapsSettingsInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ldapsSettingsInfo(Consumer<LDAPSSettingInfo.Builder>... ldapsSettingsInfo) {
            ldapsSettingsInfo(Stream.of(ldapsSettingsInfo).map(c -> LDAPSSettingInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setLdapsSettingsInfo(Collection<LDAPSSettingInfo.BuilderImpl> ldapsSettingsInfo) {
            this.ldapsSettingsInfo = LDAPSSettingsInfoCopier.copyFromBuilder(ldapsSettingsInfo);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeLdapsSettingsResponse build() {
            return new DescribeLdapsSettingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
