/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the results of the <a>DescribeSnapshots</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSnapshotsResponse extends DirectoryResponse implements
        ToCopyableBuilder<DescribeSnapshotsResponse.Builder, DescribeSnapshotsResponse> {
    private static final SdkField<List<Snapshot>> SNAPSHOTS_FIELD = SdkField
            .<List<Snapshot>> builder(MarshallingType.LIST)
            .memberName("Snapshots")
            .getter(getter(DescribeSnapshotsResponse::snapshots))
            .setter(setter(Builder::snapshots))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Snapshots").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Snapshot> builder(MarshallingType.SDK_POJO)
                                            .constructor(Snapshot::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeSnapshotsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Snapshot> snapshots;

    private final String nextToken;

    private DescribeSnapshotsResponse(BuilderImpl builder) {
        super(builder);
        this.snapshots = builder.snapshots;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Snapshots property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSnapshots() {
        return snapshots != null && !(snapshots instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of <a>Snapshot</a> objects that were retrieved.
     * </p>
     * <p>
     * It is possible that this list contains less than the number of items specified in the <i>Limit</i> member of the
     * request. This occurs if there are less than the requested number of items left to retrieve, or if the limitations
     * of the operation have been exceeded.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSnapshots()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of <a>Snapshot</a> objects that were retrieved.</p>
     *         <p>
     *         It is possible that this list contains less than the number of items specified in the <i>Limit</i> member
     *         of the request. This occurs if there are less than the requested number of items left to retrieve, or if
     *         the limitations of the operation have been exceeded.
     */
    public List<Snapshot> snapshots() {
        return snapshots;
    }

    /**
     * <p>
     * If not null, more results are available. Pass this value in the <i>NextToken</i> member of a subsequent call to
     * <a>DescribeSnapshots</a>.
     * </p>
     * 
     * @return If not null, more results are available. Pass this value in the <i>NextToken</i> member of a subsequent
     *         call to <a>DescribeSnapshots</a>.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSnapshots() ? snapshots() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSnapshotsResponse)) {
            return false;
        }
        DescribeSnapshotsResponse other = (DescribeSnapshotsResponse) obj;
        return hasSnapshots() == other.hasSnapshots() && Objects.equals(snapshots(), other.snapshots())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeSnapshotsResponse").add("Snapshots", hasSnapshots() ? snapshots() : null)
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Snapshots":
            return Optional.ofNullable(clazz.cast(snapshots()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSnapshotsResponse, T> g) {
        return obj -> g.apply((DescribeSnapshotsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectoryResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeSnapshotsResponse> {
        /**
         * <p>
         * The list of <a>Snapshot</a> objects that were retrieved.
         * </p>
         * <p>
         * It is possible that this list contains less than the number of items specified in the <i>Limit</i> member of
         * the request. This occurs if there are less than the requested number of items left to retrieve, or if the
         * limitations of the operation have been exceeded.
         * </p>
         * 
         * @param snapshots
         *        The list of <a>Snapshot</a> objects that were retrieved.</p>
         *        <p>
         *        It is possible that this list contains less than the number of items specified in the <i>Limit</i>
         *        member of the request. This occurs if there are less than the requested number of items left to
         *        retrieve, or if the limitations of the operation have been exceeded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshots(Collection<Snapshot> snapshots);

        /**
         * <p>
         * The list of <a>Snapshot</a> objects that were retrieved.
         * </p>
         * <p>
         * It is possible that this list contains less than the number of items specified in the <i>Limit</i> member of
         * the request. This occurs if there are less than the requested number of items left to retrieve, or if the
         * limitations of the operation have been exceeded.
         * </p>
         * 
         * @param snapshots
         *        The list of <a>Snapshot</a> objects that were retrieved.</p>
         *        <p>
         *        It is possible that this list contains less than the number of items specified in the <i>Limit</i>
         *        member of the request. This occurs if there are less than the requested number of items left to
         *        retrieve, or if the limitations of the operation have been exceeded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshots(Snapshot... snapshots);

        /**
         * <p>
         * The list of <a>Snapshot</a> objects that were retrieved.
         * </p>
         * <p>
         * It is possible that this list contains less than the number of items specified in the <i>Limit</i> member of
         * the request. This occurs if there are less than the requested number of items left to retrieve, or if the
         * limitations of the operation have been exceeded.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Snapshot>.Builder} avoiding the need to
         * create one manually via {@link List<Snapshot>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Snapshot>.Builder#build()} is called immediately and its
         * result is passed to {@link #snapshots(List<Snapshot>)}.
         * 
         * @param snapshots
         *        a consumer that will call methods on {@link List<Snapshot>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snapshots(List<Snapshot>)
         */
        Builder snapshots(Consumer<Snapshot.Builder>... snapshots);

        /**
         * <p>
         * If not null, more results are available. Pass this value in the <i>NextToken</i> member of a subsequent call
         * to <a>DescribeSnapshots</a>.
         * </p>
         * 
         * @param nextToken
         *        If not null, more results are available. Pass this value in the <i>NextToken</i> member of a
         *        subsequent call to <a>DescribeSnapshots</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DirectoryResponse.BuilderImpl implements Builder {
        private List<Snapshot> snapshots = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSnapshotsResponse model) {
            super(model);
            snapshots(model.snapshots);
            nextToken(model.nextToken);
        }

        public final Collection<Snapshot.Builder> getSnapshots() {
            if (snapshots instanceof SdkAutoConstructList) {
                return null;
            }
            return snapshots != null ? snapshots.stream().map(Snapshot::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder snapshots(Collection<Snapshot> snapshots) {
            this.snapshots = SnapshotsCopier.copy(snapshots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshots(Snapshot... snapshots) {
            snapshots(Arrays.asList(snapshots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshots(Consumer<Snapshot.Builder>... snapshots) {
            snapshots(Stream.of(snapshots).map(c -> Snapshot.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSnapshots(Collection<Snapshot.BuilderImpl> snapshots) {
            this.snapshots = SnapshotsCopier.copyFromBuilder(snapshots);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeSnapshotsResponse build() {
            return new DescribeSnapshotsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
