/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a schema extension.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SchemaExtensionInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<SchemaExtensionInfo.Builder, SchemaExtensionInfo> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(SchemaExtensionInfo::directoryId)).setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<String> SCHEMA_EXTENSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaExtensionId").getter(getter(SchemaExtensionInfo::schemaExtensionId))
            .setter(setter(Builder::schemaExtensionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaExtensionId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(SchemaExtensionInfo::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> SCHEMA_EXTENSION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaExtensionStatus").getter(getter(SchemaExtensionInfo::schemaExtensionStatusAsString))
            .setter(setter(Builder::schemaExtensionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaExtensionStatus").build())
            .build();

    private static final SdkField<String> SCHEMA_EXTENSION_STATUS_REASON_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SchemaExtensionStatusReason")
            .getter(getter(SchemaExtensionInfo::schemaExtensionStatusReason))
            .setter(setter(Builder::schemaExtensionStatusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaExtensionStatusReason")
                    .build()).build();

    private static final SdkField<Instant> START_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartDateTime").getter(getter(SchemaExtensionInfo::startDateTime))
            .setter(setter(Builder::startDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDateTime").build()).build();

    private static final SdkField<Instant> END_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndDateTime").getter(getter(SchemaExtensionInfo::endDateTime)).setter(setter(Builder::endDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD,
            SCHEMA_EXTENSION_ID_FIELD, DESCRIPTION_FIELD, SCHEMA_EXTENSION_STATUS_FIELD, SCHEMA_EXTENSION_STATUS_REASON_FIELD,
            START_DATE_TIME_FIELD, END_DATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String directoryId;

    private final String schemaExtensionId;

    private final String description;

    private final String schemaExtensionStatus;

    private final String schemaExtensionStatusReason;

    private final Instant startDateTime;

    private final Instant endDateTime;

    private SchemaExtensionInfo(BuilderImpl builder) {
        this.directoryId = builder.directoryId;
        this.schemaExtensionId = builder.schemaExtensionId;
        this.description = builder.description;
        this.schemaExtensionStatus = builder.schemaExtensionStatus;
        this.schemaExtensionStatusReason = builder.schemaExtensionStatusReason;
        this.startDateTime = builder.startDateTime;
        this.endDateTime = builder.endDateTime;
    }

    /**
     * <p>
     * The identifier of the directory to which the schema extension is applied.
     * </p>
     * 
     * @return The identifier of the directory to which the schema extension is applied.
     */
    public String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * The identifier of the schema extension.
     * </p>
     * 
     * @return The identifier of the schema extension.
     */
    public String schemaExtensionId() {
        return schemaExtensionId;
    }

    /**
     * <p>
     * A description of the schema extension.
     * </p>
     * 
     * @return A description of the schema extension.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The current status of the schema extension.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #schemaExtensionStatus} will return {@link SchemaExtensionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #schemaExtensionStatusAsString}.
     * </p>
     * 
     * @return The current status of the schema extension.
     * @see SchemaExtensionStatus
     */
    public SchemaExtensionStatus schemaExtensionStatus() {
        return SchemaExtensionStatus.fromValue(schemaExtensionStatus);
    }

    /**
     * <p>
     * The current status of the schema extension.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #schemaExtensionStatus} will return {@link SchemaExtensionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #schemaExtensionStatusAsString}.
     * </p>
     * 
     * @return The current status of the schema extension.
     * @see SchemaExtensionStatus
     */
    public String schemaExtensionStatusAsString() {
        return schemaExtensionStatus;
    }

    /**
     * <p>
     * The reason for the <code>SchemaExtensionStatus</code>.
     * </p>
     * 
     * @return The reason for the <code>SchemaExtensionStatus</code>.
     */
    public String schemaExtensionStatusReason() {
        return schemaExtensionStatusReason;
    }

    /**
     * <p>
     * The date and time that the schema extension started being applied to the directory.
     * </p>
     * 
     * @return The date and time that the schema extension started being applied to the directory.
     */
    public Instant startDateTime() {
        return startDateTime;
    }

    /**
     * <p>
     * The date and time that the schema extension was completed.
     * </p>
     * 
     * @return The date and time that the schema extension was completed.
     */
    public Instant endDateTime() {
        return endDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(schemaExtensionId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(schemaExtensionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(schemaExtensionStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(startDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(endDateTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaExtensionInfo)) {
            return false;
        }
        SchemaExtensionInfo other = (SchemaExtensionInfo) obj;
        return Objects.equals(directoryId(), other.directoryId())
                && Objects.equals(schemaExtensionId(), other.schemaExtensionId())
                && Objects.equals(description(), other.description())
                && Objects.equals(schemaExtensionStatusAsString(), other.schemaExtensionStatusAsString())
                && Objects.equals(schemaExtensionStatusReason(), other.schemaExtensionStatusReason())
                && Objects.equals(startDateTime(), other.startDateTime()) && Objects.equals(endDateTime(), other.endDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SchemaExtensionInfo").add("DirectoryId", directoryId())
                .add("SchemaExtensionId", schemaExtensionId()).add("Description", description())
                .add("SchemaExtensionStatus", schemaExtensionStatusAsString())
                .add("SchemaExtensionStatusReason", schemaExtensionStatusReason()).add("StartDateTime", startDateTime())
                .add("EndDateTime", endDateTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "SchemaExtensionId":
            return Optional.ofNullable(clazz.cast(schemaExtensionId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "SchemaExtensionStatus":
            return Optional.ofNullable(clazz.cast(schemaExtensionStatusAsString()));
        case "SchemaExtensionStatusReason":
            return Optional.ofNullable(clazz.cast(schemaExtensionStatusReason()));
        case "StartDateTime":
            return Optional.ofNullable(clazz.cast(startDateTime()));
        case "EndDateTime":
            return Optional.ofNullable(clazz.cast(endDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SchemaExtensionInfo, T> g) {
        return obj -> g.apply((SchemaExtensionInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SchemaExtensionInfo> {
        /**
         * <p>
         * The identifier of the directory to which the schema extension is applied.
         * </p>
         * 
         * @param directoryId
         *        The identifier of the directory to which the schema extension is applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * The identifier of the schema extension.
         * </p>
         * 
         * @param schemaExtensionId
         *        The identifier of the schema extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaExtensionId(String schemaExtensionId);

        /**
         * <p>
         * A description of the schema extension.
         * </p>
         * 
         * @param description
         *        A description of the schema extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The current status of the schema extension.
         * </p>
         * 
         * @param schemaExtensionStatus
         *        The current status of the schema extension.
         * @see SchemaExtensionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchemaExtensionStatus
         */
        Builder schemaExtensionStatus(String schemaExtensionStatus);

        /**
         * <p>
         * The current status of the schema extension.
         * </p>
         * 
         * @param schemaExtensionStatus
         *        The current status of the schema extension.
         * @see SchemaExtensionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchemaExtensionStatus
         */
        Builder schemaExtensionStatus(SchemaExtensionStatus schemaExtensionStatus);

        /**
         * <p>
         * The reason for the <code>SchemaExtensionStatus</code>.
         * </p>
         * 
         * @param schemaExtensionStatusReason
         *        The reason for the <code>SchemaExtensionStatus</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaExtensionStatusReason(String schemaExtensionStatusReason);

        /**
         * <p>
         * The date and time that the schema extension started being applied to the directory.
         * </p>
         * 
         * @param startDateTime
         *        The date and time that the schema extension started being applied to the directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDateTime(Instant startDateTime);

        /**
         * <p>
         * The date and time that the schema extension was completed.
         * </p>
         * 
         * @param endDateTime
         *        The date and time that the schema extension was completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endDateTime(Instant endDateTime);
    }

    static final class BuilderImpl implements Builder {
        private String directoryId;

        private String schemaExtensionId;

        private String description;

        private String schemaExtensionStatus;

        private String schemaExtensionStatusReason;

        private Instant startDateTime;

        private Instant endDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(SchemaExtensionInfo model) {
            directoryId(model.directoryId);
            schemaExtensionId(model.schemaExtensionId);
            description(model.description);
            schemaExtensionStatus(model.schemaExtensionStatus);
            schemaExtensionStatusReason(model.schemaExtensionStatusReason);
            startDateTime(model.startDateTime);
            endDateTime(model.endDateTime);
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        public final String getSchemaExtensionId() {
            return schemaExtensionId;
        }

        @Override
        public final Builder schemaExtensionId(String schemaExtensionId) {
            this.schemaExtensionId = schemaExtensionId;
            return this;
        }

        public final void setSchemaExtensionId(String schemaExtensionId) {
            this.schemaExtensionId = schemaExtensionId;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getSchemaExtensionStatus() {
            return schemaExtensionStatus;
        }

        @Override
        public final Builder schemaExtensionStatus(String schemaExtensionStatus) {
            this.schemaExtensionStatus = schemaExtensionStatus;
            return this;
        }

        @Override
        public final Builder schemaExtensionStatus(SchemaExtensionStatus schemaExtensionStatus) {
            this.schemaExtensionStatus(schemaExtensionStatus == null ? null : schemaExtensionStatus.toString());
            return this;
        }

        public final void setSchemaExtensionStatus(String schemaExtensionStatus) {
            this.schemaExtensionStatus = schemaExtensionStatus;
        }

        public final String getSchemaExtensionStatusReason() {
            return schemaExtensionStatusReason;
        }

        @Override
        public final Builder schemaExtensionStatusReason(String schemaExtensionStatusReason) {
            this.schemaExtensionStatusReason = schemaExtensionStatusReason;
            return this;
        }

        public final void setSchemaExtensionStatusReason(String schemaExtensionStatusReason) {
            this.schemaExtensionStatusReason = schemaExtensionStatusReason;
        }

        public final Instant getStartDateTime() {
            return startDateTime;
        }

        @Override
        public final Builder startDateTime(Instant startDateTime) {
            this.startDateTime = startDateTime;
            return this;
        }

        public final void setStartDateTime(Instant startDateTime) {
            this.startDateTime = startDateTime;
        }

        public final Instant getEndDateTime() {
            return endDateTime;
        }

        @Override
        public final Builder endDateTime(Instant endDateTime) {
            this.endDateTime = endDateTime;
            return this;
        }

        public final void setEndDateTime(Instant endDateTime) {
            this.endDateTime = endDateTime;
        }

        @Override
        public SchemaExtensionInfo build() {
            return new SchemaExtensionInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
