/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directory.model.CertificateState;
import software.amazon.awssdk.services.directory.model.CertificateType;
import software.amazon.awssdk.services.directory.model.ClientCertAuthSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Certificate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Certificate> {
    private static final SdkField<String> CERTIFICATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateId").getter(Certificate.getter(Certificate::certificateId)).setter(Certificate.setter(Builder::certificateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(Certificate.getter(Certificate::stateAsString)).setter(Certificate.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> STATE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateReason").getter(Certificate.getter(Certificate::stateReason)).setter(Certificate.setter(Builder::stateReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason").build()}).build();
    private static final SdkField<String> COMMON_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CommonName").getter(Certificate.getter(Certificate::commonName)).setter(Certificate.setter(Builder::commonName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommonName").build()}).build();
    private static final SdkField<Instant> REGISTERED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("RegisteredDateTime").getter(Certificate.getter(Certificate::registeredDateTime)).setter(Certificate.setter(Builder::registeredDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegisteredDateTime").build()}).build();
    private static final SdkField<Instant> EXPIRY_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExpiryDateTime").getter(Certificate.getter(Certificate::expiryDateTime)).setter(Certificate.setter(Builder::expiryDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpiryDateTime").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(Certificate.getter(Certificate::typeAsString)).setter(Certificate.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<ClientCertAuthSettings> CLIENT_CERT_AUTH_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ClientCertAuthSettings").getter(Certificate.getter(Certificate::clientCertAuthSettings)).setter(Certificate.setter(Builder::clientCertAuthSettings)).constructor(ClientCertAuthSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientCertAuthSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_ID_FIELD, STATE_FIELD, STATE_REASON_FIELD, COMMON_NAME_FIELD, REGISTERED_DATE_TIME_FIELD, EXPIRY_DATE_TIME_FIELD, TYPE_FIELD, CLIENT_CERT_AUTH_SETTINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String certificateId;
    private final String state;
    private final String stateReason;
    private final String commonName;
    private final Instant registeredDateTime;
    private final Instant expiryDateTime;
    private final String type;
    private final ClientCertAuthSettings clientCertAuthSettings;

    private Certificate(BuilderImpl builder) {
        this.certificateId = builder.certificateId;
        this.state = builder.state;
        this.stateReason = builder.stateReason;
        this.commonName = builder.commonName;
        this.registeredDateTime = builder.registeredDateTime;
        this.expiryDateTime = builder.expiryDateTime;
        this.type = builder.type;
        this.clientCertAuthSettings = builder.clientCertAuthSettings;
    }

    public String certificateId() {
        return this.certificateId;
    }

    public CertificateState state() {
        return CertificateState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public String stateReason() {
        return this.stateReason;
    }

    public String commonName() {
        return this.commonName;
    }

    public Instant registeredDateTime() {
        return this.registeredDateTime;
    }

    public Instant expiryDateTime() {
        return this.expiryDateTime;
    }

    public CertificateType type() {
        return CertificateType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public ClientCertAuthSettings clientCertAuthSettings() {
        return this.clientCertAuthSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.commonName());
        hashCode = 31 * hashCode + Objects.hashCode(this.registeredDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiryDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientCertAuthSettings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Certificate)) {
            return false;
        }
        Certificate other = (Certificate)obj;
        return Objects.equals(this.certificateId(), other.certificateId()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stateReason(), other.stateReason()) && Objects.equals(this.commonName(), other.commonName()) && Objects.equals(this.registeredDateTime(), other.registeredDateTime()) && Objects.equals(this.expiryDateTime(), other.expiryDateTime()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.clientCertAuthSettings(), other.clientCertAuthSettings());
    }

    public String toString() {
        return ToString.builder((String)"Certificate").add("CertificateId", (Object)this.certificateId()).add("State", (Object)this.stateAsString()).add("StateReason", (Object)this.stateReason()).add("CommonName", (Object)this.commonName()).add("RegisteredDateTime", (Object)this.registeredDateTime()).add("ExpiryDateTime", (Object)this.expiryDateTime()).add("Type", (Object)this.typeAsString()).add("ClientCertAuthSettings", (Object)this.clientCertAuthSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CertificateId": {
                return Optional.ofNullable(clazz.cast(this.certificateId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StateReason": {
                return Optional.ofNullable(clazz.cast(this.stateReason()));
            }
            case "CommonName": {
                return Optional.ofNullable(clazz.cast(this.commonName()));
            }
            case "RegisteredDateTime": {
                return Optional.ofNullable(clazz.cast(this.registeredDateTime()));
            }
            case "ExpiryDateTime": {
                return Optional.ofNullable(clazz.cast(this.expiryDateTime()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "ClientCertAuthSettings": {
                return Optional.ofNullable(clazz.cast(this.clientCertAuthSettings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Certificate, T> g) {
        return obj -> g.apply((Certificate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String certificateId;
        private String state;
        private String stateReason;
        private String commonName;
        private Instant registeredDateTime;
        private Instant expiryDateTime;
        private String type;
        private ClientCertAuthSettings clientCertAuthSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(Certificate model) {
            this.certificateId(model.certificateId);
            this.state(model.state);
            this.stateReason(model.stateReason);
            this.commonName(model.commonName);
            this.registeredDateTime(model.registeredDateTime);
            this.expiryDateTime(model.expiryDateTime);
            this.type(model.type);
            this.clientCertAuthSettings(model.clientCertAuthSettings);
        }

        public final String getCertificateId() {
            return this.certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CertificateState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStateReason() {
            return this.stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        public final String getCommonName() {
            return this.commonName;
        }

        @Override
        public final Builder commonName(String commonName) {
            this.commonName = commonName;
            return this;
        }

        public final void setCommonName(String commonName) {
            this.commonName = commonName;
        }

        public final Instant getRegisteredDateTime() {
            return this.registeredDateTime;
        }

        @Override
        public final Builder registeredDateTime(Instant registeredDateTime) {
            this.registeredDateTime = registeredDateTime;
            return this;
        }

        public final void setRegisteredDateTime(Instant registeredDateTime) {
            this.registeredDateTime = registeredDateTime;
        }

        public final Instant getExpiryDateTime() {
            return this.expiryDateTime;
        }

        @Override
        public final Builder expiryDateTime(Instant expiryDateTime) {
            this.expiryDateTime = expiryDateTime;
            return this;
        }

        public final void setExpiryDateTime(Instant expiryDateTime) {
            this.expiryDateTime = expiryDateTime;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CertificateType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final ClientCertAuthSettings.Builder getClientCertAuthSettings() {
            return this.clientCertAuthSettings != null ? this.clientCertAuthSettings.toBuilder() : null;
        }

        @Override
        public final Builder clientCertAuthSettings(ClientCertAuthSettings clientCertAuthSettings) {
            this.clientCertAuthSettings = clientCertAuthSettings;
            return this;
        }

        public final void setClientCertAuthSettings(ClientCertAuthSettings.BuilderImpl clientCertAuthSettings) {
            this.clientCertAuthSettings = clientCertAuthSettings != null ? clientCertAuthSettings.build() : null;
        }

        public Certificate build() {
            return new Certificate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Certificate> {
        public Builder certificateId(String var1);

        public Builder state(String var1);

        public Builder state(CertificateState var1);

        public Builder stateReason(String var1);

        public Builder commonName(String var1);

        public Builder registeredDateTime(Instant var1);

        public Builder expiryDateTime(Instant var1);

        public Builder type(String var1);

        public Builder type(CertificateType var1);

        public Builder clientCertAuthSettings(ClientCertAuthSettings var1);

        default public Builder clientCertAuthSettings(Consumer<ClientCertAuthSettings.Builder> clientCertAuthSettings) {
            return this.clientCertAuthSettings((ClientCertAuthSettings)((ClientCertAuthSettings.Builder)ClientCertAuthSettings.builder().applyMutation(clientCertAuthSettings)).build());
        }
    }
}

