/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains directory limit information for a Region.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DirectoryLimits implements SdkPojo, Serializable, ToCopyableBuilder<DirectoryLimits.Builder, DirectoryLimits> {
    private static final SdkField<Integer> CLOUD_ONLY_DIRECTORIES_LIMIT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("CloudOnlyDirectoriesLimit")
            .getter(getter(DirectoryLimits::cloudOnlyDirectoriesLimit)).setter(setter(Builder::cloudOnlyDirectoriesLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudOnlyDirectoriesLimit").build())
            .build();

    private static final SdkField<Integer> CLOUD_ONLY_DIRECTORIES_CURRENT_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("CloudOnlyDirectoriesCurrentCount")
            .getter(getter(DirectoryLimits::cloudOnlyDirectoriesCurrentCount))
            .setter(setter(Builder::cloudOnlyDirectoriesCurrentCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudOnlyDirectoriesCurrentCount")
                    .build()).build();

    private static final SdkField<Boolean> CLOUD_ONLY_DIRECTORIES_LIMIT_REACHED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CloudOnlyDirectoriesLimitReached")
            .getter(getter(DirectoryLimits::cloudOnlyDirectoriesLimitReached))
            .setter(setter(Builder::cloudOnlyDirectoriesLimitReached))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudOnlyDirectoriesLimitReached")
                    .build()).build();

    private static final SdkField<Integer> CLOUD_ONLY_MICROSOFT_AD_LIMIT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("CloudOnlyMicrosoftADLimit")
            .getter(getter(DirectoryLimits::cloudOnlyMicrosoftADLimit)).setter(setter(Builder::cloudOnlyMicrosoftADLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudOnlyMicrosoftADLimit").build())
            .build();

    private static final SdkField<Integer> CLOUD_ONLY_MICROSOFT_AD_CURRENT_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("CloudOnlyMicrosoftADCurrentCount")
            .getter(getter(DirectoryLimits::cloudOnlyMicrosoftADCurrentCount))
            .setter(setter(Builder::cloudOnlyMicrosoftADCurrentCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudOnlyMicrosoftADCurrentCount")
                    .build()).build();

    private static final SdkField<Boolean> CLOUD_ONLY_MICROSOFT_AD_LIMIT_REACHED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CloudOnlyMicrosoftADLimitReached")
            .getter(getter(DirectoryLimits::cloudOnlyMicrosoftADLimitReached))
            .setter(setter(Builder::cloudOnlyMicrosoftADLimitReached))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudOnlyMicrosoftADLimitReached")
                    .build()).build();

    private static final SdkField<Integer> CONNECTED_DIRECTORIES_LIMIT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("ConnectedDirectoriesLimit")
            .getter(getter(DirectoryLimits::connectedDirectoriesLimit)).setter(setter(Builder::connectedDirectoriesLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectedDirectoriesLimit").build())
            .build();

    private static final SdkField<Integer> CONNECTED_DIRECTORIES_CURRENT_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("ConnectedDirectoriesCurrentCount")
            .getter(getter(DirectoryLimits::connectedDirectoriesCurrentCount))
            .setter(setter(Builder::connectedDirectoriesCurrentCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectedDirectoriesCurrentCount")
                    .build()).build();

    private static final SdkField<Boolean> CONNECTED_DIRECTORIES_LIMIT_REACHED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ConnectedDirectoriesLimitReached")
            .getter(getter(DirectoryLimits::connectedDirectoriesLimitReached))
            .setter(setter(Builder::connectedDirectoriesLimitReached))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectedDirectoriesLimitReached")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CLOUD_ONLY_DIRECTORIES_LIMIT_FIELD, CLOUD_ONLY_DIRECTORIES_CURRENT_COUNT_FIELD,
            CLOUD_ONLY_DIRECTORIES_LIMIT_REACHED_FIELD, CLOUD_ONLY_MICROSOFT_AD_LIMIT_FIELD,
            CLOUD_ONLY_MICROSOFT_AD_CURRENT_COUNT_FIELD, CLOUD_ONLY_MICROSOFT_AD_LIMIT_REACHED_FIELD,
            CONNECTED_DIRECTORIES_LIMIT_FIELD, CONNECTED_DIRECTORIES_CURRENT_COUNT_FIELD,
            CONNECTED_DIRECTORIES_LIMIT_REACHED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer cloudOnlyDirectoriesLimit;

    private final Integer cloudOnlyDirectoriesCurrentCount;

    private final Boolean cloudOnlyDirectoriesLimitReached;

    private final Integer cloudOnlyMicrosoftADLimit;

    private final Integer cloudOnlyMicrosoftADCurrentCount;

    private final Boolean cloudOnlyMicrosoftADLimitReached;

    private final Integer connectedDirectoriesLimit;

    private final Integer connectedDirectoriesCurrentCount;

    private final Boolean connectedDirectoriesLimitReached;

    private DirectoryLimits(BuilderImpl builder) {
        this.cloudOnlyDirectoriesLimit = builder.cloudOnlyDirectoriesLimit;
        this.cloudOnlyDirectoriesCurrentCount = builder.cloudOnlyDirectoriesCurrentCount;
        this.cloudOnlyDirectoriesLimitReached = builder.cloudOnlyDirectoriesLimitReached;
        this.cloudOnlyMicrosoftADLimit = builder.cloudOnlyMicrosoftADLimit;
        this.cloudOnlyMicrosoftADCurrentCount = builder.cloudOnlyMicrosoftADCurrentCount;
        this.cloudOnlyMicrosoftADLimitReached = builder.cloudOnlyMicrosoftADLimitReached;
        this.connectedDirectoriesLimit = builder.connectedDirectoriesLimit;
        this.connectedDirectoriesCurrentCount = builder.connectedDirectoriesCurrentCount;
        this.connectedDirectoriesLimitReached = builder.connectedDirectoriesLimitReached;
    }

    /**
     * <p>
     * The maximum number of cloud directories allowed in the Region.
     * </p>
     * 
     * @return The maximum number of cloud directories allowed in the Region.
     */
    public Integer cloudOnlyDirectoriesLimit() {
        return cloudOnlyDirectoriesLimit;
    }

    /**
     * <p>
     * The current number of cloud directories in the Region.
     * </p>
     * 
     * @return The current number of cloud directories in the Region.
     */
    public Integer cloudOnlyDirectoriesCurrentCount() {
        return cloudOnlyDirectoriesCurrentCount;
    }

    /**
     * <p>
     * Indicates if the cloud directory limit has been reached.
     * </p>
     * 
     * @return Indicates if the cloud directory limit has been reached.
     */
    public Boolean cloudOnlyDirectoriesLimitReached() {
        return cloudOnlyDirectoriesLimitReached;
    }

    /**
     * <p>
     * The maximum number of AWS Managed Microsoft AD directories allowed in the region.
     * </p>
     * 
     * @return The maximum number of AWS Managed Microsoft AD directories allowed in the region.
     */
    public Integer cloudOnlyMicrosoftADLimit() {
        return cloudOnlyMicrosoftADLimit;
    }

    /**
     * <p>
     * The current number of AWS Managed Microsoft AD directories in the region.
     * </p>
     * 
     * @return The current number of AWS Managed Microsoft AD directories in the region.
     */
    public Integer cloudOnlyMicrosoftADCurrentCount() {
        return cloudOnlyMicrosoftADCurrentCount;
    }

    /**
     * <p>
     * Indicates if the AWS Managed Microsoft AD directory limit has been reached.
     * </p>
     * 
     * @return Indicates if the AWS Managed Microsoft AD directory limit has been reached.
     */
    public Boolean cloudOnlyMicrosoftADLimitReached() {
        return cloudOnlyMicrosoftADLimitReached;
    }

    /**
     * <p>
     * The maximum number of connected directories allowed in the Region.
     * </p>
     * 
     * @return The maximum number of connected directories allowed in the Region.
     */
    public Integer connectedDirectoriesLimit() {
        return connectedDirectoriesLimit;
    }

    /**
     * <p>
     * The current number of connected directories in the Region.
     * </p>
     * 
     * @return The current number of connected directories in the Region.
     */
    public Integer connectedDirectoriesCurrentCount() {
        return connectedDirectoriesCurrentCount;
    }

    /**
     * <p>
     * Indicates if the connected directory limit has been reached.
     * </p>
     * 
     * @return Indicates if the connected directory limit has been reached.
     */
    public Boolean connectedDirectoriesLimitReached() {
        return connectedDirectoriesLimitReached;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudOnlyDirectoriesLimit());
        hashCode = 31 * hashCode + Objects.hashCode(cloudOnlyDirectoriesCurrentCount());
        hashCode = 31 * hashCode + Objects.hashCode(cloudOnlyDirectoriesLimitReached());
        hashCode = 31 * hashCode + Objects.hashCode(cloudOnlyMicrosoftADLimit());
        hashCode = 31 * hashCode + Objects.hashCode(cloudOnlyMicrosoftADCurrentCount());
        hashCode = 31 * hashCode + Objects.hashCode(cloudOnlyMicrosoftADLimitReached());
        hashCode = 31 * hashCode + Objects.hashCode(connectedDirectoriesLimit());
        hashCode = 31 * hashCode + Objects.hashCode(connectedDirectoriesCurrentCount());
        hashCode = 31 * hashCode + Objects.hashCode(connectedDirectoriesLimitReached());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DirectoryLimits)) {
            return false;
        }
        DirectoryLimits other = (DirectoryLimits) obj;
        return Objects.equals(cloudOnlyDirectoriesLimit(), other.cloudOnlyDirectoriesLimit())
                && Objects.equals(cloudOnlyDirectoriesCurrentCount(), other.cloudOnlyDirectoriesCurrentCount())
                && Objects.equals(cloudOnlyDirectoriesLimitReached(), other.cloudOnlyDirectoriesLimitReached())
                && Objects.equals(cloudOnlyMicrosoftADLimit(), other.cloudOnlyMicrosoftADLimit())
                && Objects.equals(cloudOnlyMicrosoftADCurrentCount(), other.cloudOnlyMicrosoftADCurrentCount())
                && Objects.equals(cloudOnlyMicrosoftADLimitReached(), other.cloudOnlyMicrosoftADLimitReached())
                && Objects.equals(connectedDirectoriesLimit(), other.connectedDirectoriesLimit())
                && Objects.equals(connectedDirectoriesCurrentCount(), other.connectedDirectoriesCurrentCount())
                && Objects.equals(connectedDirectoriesLimitReached(), other.connectedDirectoriesLimitReached());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DirectoryLimits").add("CloudOnlyDirectoriesLimit", cloudOnlyDirectoriesLimit())
                .add("CloudOnlyDirectoriesCurrentCount", cloudOnlyDirectoriesCurrentCount())
                .add("CloudOnlyDirectoriesLimitReached", cloudOnlyDirectoriesLimitReached())
                .add("CloudOnlyMicrosoftADLimit", cloudOnlyMicrosoftADLimit())
                .add("CloudOnlyMicrosoftADCurrentCount", cloudOnlyMicrosoftADCurrentCount())
                .add("CloudOnlyMicrosoftADLimitReached", cloudOnlyMicrosoftADLimitReached())
                .add("ConnectedDirectoriesLimit", connectedDirectoriesLimit())
                .add("ConnectedDirectoriesCurrentCount", connectedDirectoriesCurrentCount())
                .add("ConnectedDirectoriesLimitReached", connectedDirectoriesLimitReached()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CloudOnlyDirectoriesLimit":
            return Optional.ofNullable(clazz.cast(cloudOnlyDirectoriesLimit()));
        case "CloudOnlyDirectoriesCurrentCount":
            return Optional.ofNullable(clazz.cast(cloudOnlyDirectoriesCurrentCount()));
        case "CloudOnlyDirectoriesLimitReached":
            return Optional.ofNullable(clazz.cast(cloudOnlyDirectoriesLimitReached()));
        case "CloudOnlyMicrosoftADLimit":
            return Optional.ofNullable(clazz.cast(cloudOnlyMicrosoftADLimit()));
        case "CloudOnlyMicrosoftADCurrentCount":
            return Optional.ofNullable(clazz.cast(cloudOnlyMicrosoftADCurrentCount()));
        case "CloudOnlyMicrosoftADLimitReached":
            return Optional.ofNullable(clazz.cast(cloudOnlyMicrosoftADLimitReached()));
        case "ConnectedDirectoriesLimit":
            return Optional.ofNullable(clazz.cast(connectedDirectoriesLimit()));
        case "ConnectedDirectoriesCurrentCount":
            return Optional.ofNullable(clazz.cast(connectedDirectoriesCurrentCount()));
        case "ConnectedDirectoriesLimitReached":
            return Optional.ofNullable(clazz.cast(connectedDirectoriesLimitReached()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DirectoryLimits, T> g) {
        return obj -> g.apply((DirectoryLimits) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DirectoryLimits> {
        /**
         * <p>
         * The maximum number of cloud directories allowed in the Region.
         * </p>
         * 
         * @param cloudOnlyDirectoriesLimit
         *        The maximum number of cloud directories allowed in the Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudOnlyDirectoriesLimit(Integer cloudOnlyDirectoriesLimit);

        /**
         * <p>
         * The current number of cloud directories in the Region.
         * </p>
         * 
         * @param cloudOnlyDirectoriesCurrentCount
         *        The current number of cloud directories in the Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudOnlyDirectoriesCurrentCount(Integer cloudOnlyDirectoriesCurrentCount);

        /**
         * <p>
         * Indicates if the cloud directory limit has been reached.
         * </p>
         * 
         * @param cloudOnlyDirectoriesLimitReached
         *        Indicates if the cloud directory limit has been reached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudOnlyDirectoriesLimitReached(Boolean cloudOnlyDirectoriesLimitReached);

        /**
         * <p>
         * The maximum number of AWS Managed Microsoft AD directories allowed in the region.
         * </p>
         * 
         * @param cloudOnlyMicrosoftADLimit
         *        The maximum number of AWS Managed Microsoft AD directories allowed in the region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudOnlyMicrosoftADLimit(Integer cloudOnlyMicrosoftADLimit);

        /**
         * <p>
         * The current number of AWS Managed Microsoft AD directories in the region.
         * </p>
         * 
         * @param cloudOnlyMicrosoftADCurrentCount
         *        The current number of AWS Managed Microsoft AD directories in the region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudOnlyMicrosoftADCurrentCount(Integer cloudOnlyMicrosoftADCurrentCount);

        /**
         * <p>
         * Indicates if the AWS Managed Microsoft AD directory limit has been reached.
         * </p>
         * 
         * @param cloudOnlyMicrosoftADLimitReached
         *        Indicates if the AWS Managed Microsoft AD directory limit has been reached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudOnlyMicrosoftADLimitReached(Boolean cloudOnlyMicrosoftADLimitReached);

        /**
         * <p>
         * The maximum number of connected directories allowed in the Region.
         * </p>
         * 
         * @param connectedDirectoriesLimit
         *        The maximum number of connected directories allowed in the Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectedDirectoriesLimit(Integer connectedDirectoriesLimit);

        /**
         * <p>
         * The current number of connected directories in the Region.
         * </p>
         * 
         * @param connectedDirectoriesCurrentCount
         *        The current number of connected directories in the Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectedDirectoriesCurrentCount(Integer connectedDirectoriesCurrentCount);

        /**
         * <p>
         * Indicates if the connected directory limit has been reached.
         * </p>
         * 
         * @param connectedDirectoriesLimitReached
         *        Indicates if the connected directory limit has been reached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectedDirectoriesLimitReached(Boolean connectedDirectoriesLimitReached);
    }

    static final class BuilderImpl implements Builder {
        private Integer cloudOnlyDirectoriesLimit;

        private Integer cloudOnlyDirectoriesCurrentCount;

        private Boolean cloudOnlyDirectoriesLimitReached;

        private Integer cloudOnlyMicrosoftADLimit;

        private Integer cloudOnlyMicrosoftADCurrentCount;

        private Boolean cloudOnlyMicrosoftADLimitReached;

        private Integer connectedDirectoriesLimit;

        private Integer connectedDirectoriesCurrentCount;

        private Boolean connectedDirectoriesLimitReached;

        private BuilderImpl() {
        }

        private BuilderImpl(DirectoryLimits model) {
            cloudOnlyDirectoriesLimit(model.cloudOnlyDirectoriesLimit);
            cloudOnlyDirectoriesCurrentCount(model.cloudOnlyDirectoriesCurrentCount);
            cloudOnlyDirectoriesLimitReached(model.cloudOnlyDirectoriesLimitReached);
            cloudOnlyMicrosoftADLimit(model.cloudOnlyMicrosoftADLimit);
            cloudOnlyMicrosoftADCurrentCount(model.cloudOnlyMicrosoftADCurrentCount);
            cloudOnlyMicrosoftADLimitReached(model.cloudOnlyMicrosoftADLimitReached);
            connectedDirectoriesLimit(model.connectedDirectoriesLimit);
            connectedDirectoriesCurrentCount(model.connectedDirectoriesCurrentCount);
            connectedDirectoriesLimitReached(model.connectedDirectoriesLimitReached);
        }

        public final Integer getCloudOnlyDirectoriesLimit() {
            return cloudOnlyDirectoriesLimit;
        }

        @Override
        public final Builder cloudOnlyDirectoriesLimit(Integer cloudOnlyDirectoriesLimit) {
            this.cloudOnlyDirectoriesLimit = cloudOnlyDirectoriesLimit;
            return this;
        }

        public final void setCloudOnlyDirectoriesLimit(Integer cloudOnlyDirectoriesLimit) {
            this.cloudOnlyDirectoriesLimit = cloudOnlyDirectoriesLimit;
        }

        public final Integer getCloudOnlyDirectoriesCurrentCount() {
            return cloudOnlyDirectoriesCurrentCount;
        }

        @Override
        public final Builder cloudOnlyDirectoriesCurrentCount(Integer cloudOnlyDirectoriesCurrentCount) {
            this.cloudOnlyDirectoriesCurrentCount = cloudOnlyDirectoriesCurrentCount;
            return this;
        }

        public final void setCloudOnlyDirectoriesCurrentCount(Integer cloudOnlyDirectoriesCurrentCount) {
            this.cloudOnlyDirectoriesCurrentCount = cloudOnlyDirectoriesCurrentCount;
        }

        public final Boolean getCloudOnlyDirectoriesLimitReached() {
            return cloudOnlyDirectoriesLimitReached;
        }

        @Override
        public final Builder cloudOnlyDirectoriesLimitReached(Boolean cloudOnlyDirectoriesLimitReached) {
            this.cloudOnlyDirectoriesLimitReached = cloudOnlyDirectoriesLimitReached;
            return this;
        }

        public final void setCloudOnlyDirectoriesLimitReached(Boolean cloudOnlyDirectoriesLimitReached) {
            this.cloudOnlyDirectoriesLimitReached = cloudOnlyDirectoriesLimitReached;
        }

        public final Integer getCloudOnlyMicrosoftADLimit() {
            return cloudOnlyMicrosoftADLimit;
        }

        @Override
        public final Builder cloudOnlyMicrosoftADLimit(Integer cloudOnlyMicrosoftADLimit) {
            this.cloudOnlyMicrosoftADLimit = cloudOnlyMicrosoftADLimit;
            return this;
        }

        public final void setCloudOnlyMicrosoftADLimit(Integer cloudOnlyMicrosoftADLimit) {
            this.cloudOnlyMicrosoftADLimit = cloudOnlyMicrosoftADLimit;
        }

        public final Integer getCloudOnlyMicrosoftADCurrentCount() {
            return cloudOnlyMicrosoftADCurrentCount;
        }

        @Override
        public final Builder cloudOnlyMicrosoftADCurrentCount(Integer cloudOnlyMicrosoftADCurrentCount) {
            this.cloudOnlyMicrosoftADCurrentCount = cloudOnlyMicrosoftADCurrentCount;
            return this;
        }

        public final void setCloudOnlyMicrosoftADCurrentCount(Integer cloudOnlyMicrosoftADCurrentCount) {
            this.cloudOnlyMicrosoftADCurrentCount = cloudOnlyMicrosoftADCurrentCount;
        }

        public final Boolean getCloudOnlyMicrosoftADLimitReached() {
            return cloudOnlyMicrosoftADLimitReached;
        }

        @Override
        public final Builder cloudOnlyMicrosoftADLimitReached(Boolean cloudOnlyMicrosoftADLimitReached) {
            this.cloudOnlyMicrosoftADLimitReached = cloudOnlyMicrosoftADLimitReached;
            return this;
        }

        public final void setCloudOnlyMicrosoftADLimitReached(Boolean cloudOnlyMicrosoftADLimitReached) {
            this.cloudOnlyMicrosoftADLimitReached = cloudOnlyMicrosoftADLimitReached;
        }

        public final Integer getConnectedDirectoriesLimit() {
            return connectedDirectoriesLimit;
        }

        @Override
        public final Builder connectedDirectoriesLimit(Integer connectedDirectoriesLimit) {
            this.connectedDirectoriesLimit = connectedDirectoriesLimit;
            return this;
        }

        public final void setConnectedDirectoriesLimit(Integer connectedDirectoriesLimit) {
            this.connectedDirectoriesLimit = connectedDirectoriesLimit;
        }

        public final Integer getConnectedDirectoriesCurrentCount() {
            return connectedDirectoriesCurrentCount;
        }

        @Override
        public final Builder connectedDirectoriesCurrentCount(Integer connectedDirectoriesCurrentCount) {
            this.connectedDirectoriesCurrentCount = connectedDirectoriesCurrentCount;
            return this;
        }

        public final void setConnectedDirectoriesCurrentCount(Integer connectedDirectoriesCurrentCount) {
            this.connectedDirectoriesCurrentCount = connectedDirectoriesCurrentCount;
        }

        public final Boolean getConnectedDirectoriesLimitReached() {
            return connectedDirectoriesLimitReached;
        }

        @Override
        public final Builder connectedDirectoriesLimitReached(Boolean connectedDirectoriesLimitReached) {
            this.connectedDirectoriesLimitReached = connectedDirectoriesLimitReached;
            return this;
        }

        public final void setConnectedDirectoriesLimitReached(Boolean connectedDirectoriesLimitReached) {
            this.connectedDirectoriesLimitReached = connectedDirectoriesLimitReached;
        }

        @Override
        public DirectoryLimits build() {
            return new DirectoryLimits(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
