/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCertificatesResponse extends DirectoryResponse implements
        ToCopyableBuilder<ListCertificatesResponse.Builder, ListCertificatesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListCertificatesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<CertificateInfo>> CERTIFICATES_INFO_FIELD = SdkField
            .<List<CertificateInfo>> builder(MarshallingType.LIST)
            .memberName("CertificatesInfo")
            .getter(getter(ListCertificatesResponse::certificatesInfo))
            .setter(setter(Builder::certificatesInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificatesInfo").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CertificateInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(CertificateInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            CERTIFICATES_INFO_FIELD));

    private final String nextToken;

    private final List<CertificateInfo> certificatesInfo;

    private ListCertificatesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.certificatesInfo = builder.certificatesInfo;
    }

    /**
     * <p>
     * Indicates whether another page of certificates is available when the number of available certificates exceeds the
     * page limit.
     * </p>
     * 
     * @return Indicates whether another page of certificates is available when the number of available certificates
     *         exceeds the page limit.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the CertificatesInfo property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasCertificatesInfo() {
        return certificatesInfo != null && !(certificatesInfo instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of certificates with basic details including certificate ID, certificate common name, certificate state.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCertificatesInfo()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of certificates with basic details including certificate ID, certificate common name, certificate
     *         state.
     */
    public List<CertificateInfo> certificatesInfo() {
        return certificatesInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasCertificatesInfo() ? certificatesInfo() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCertificatesResponse)) {
            return false;
        }
        ListCertificatesResponse other = (ListCertificatesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasCertificatesInfo() == other.hasCertificatesInfo()
                && Objects.equals(certificatesInfo(), other.certificatesInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListCertificatesResponse").add("NextToken", nextToken())
                .add("CertificatesInfo", hasCertificatesInfo() ? certificatesInfo() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "CertificatesInfo":
            return Optional.ofNullable(clazz.cast(certificatesInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCertificatesResponse, T> g) {
        return obj -> g.apply((ListCertificatesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectoryResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListCertificatesResponse> {
        /**
         * <p>
         * Indicates whether another page of certificates is available when the number of available certificates exceeds
         * the page limit.
         * </p>
         * 
         * @param nextToken
         *        Indicates whether another page of certificates is available when the number of available certificates
         *        exceeds the page limit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of certificates with basic details including certificate ID, certificate common name, certificate
         * state.
         * </p>
         * 
         * @param certificatesInfo
         *        A list of certificates with basic details including certificate ID, certificate common name,
         *        certificate state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificatesInfo(Collection<CertificateInfo> certificatesInfo);

        /**
         * <p>
         * A list of certificates with basic details including certificate ID, certificate common name, certificate
         * state.
         * </p>
         * 
         * @param certificatesInfo
         *        A list of certificates with basic details including certificate ID, certificate common name,
         *        certificate state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificatesInfo(CertificateInfo... certificatesInfo);

        /**
         * <p>
         * A list of certificates with basic details including certificate ID, certificate common name, certificate
         * state.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CertificateInfo>.Builder} avoiding the need
         * to create one manually via {@link List<CertificateInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CertificateInfo>.Builder#build()} is called immediately and
         * its result is passed to {@link #certificatesInfo(List<CertificateInfo>)}.
         * 
         * @param certificatesInfo
         *        a consumer that will call methods on {@link List<CertificateInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #certificatesInfo(List<CertificateInfo>)
         */
        Builder certificatesInfo(Consumer<CertificateInfo.Builder>... certificatesInfo);
    }

    static final class BuilderImpl extends DirectoryResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<CertificateInfo> certificatesInfo = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCertificatesResponse model) {
            super(model);
            nextToken(model.nextToken);
            certificatesInfo(model.certificatesInfo);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<CertificateInfo.Builder> getCertificatesInfo() {
            if (certificatesInfo instanceof SdkAutoConstructList) {
                return null;
            }
            return certificatesInfo != null ? certificatesInfo.stream().map(CertificateInfo::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder certificatesInfo(Collection<CertificateInfo> certificatesInfo) {
            this.certificatesInfo = CertificatesInfoCopier.copy(certificatesInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificatesInfo(CertificateInfo... certificatesInfo) {
            certificatesInfo(Arrays.asList(certificatesInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificatesInfo(Consumer<CertificateInfo.Builder>... certificatesInfo) {
            certificatesInfo(Stream.of(certificatesInfo).map(c -> CertificateInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setCertificatesInfo(Collection<CertificateInfo.BuilderImpl> certificatesInfo) {
            this.certificatesInfo = CertificatesInfoCopier.copyFromBuilder(certificatesInfo);
        }

        @Override
        public ListCertificatesResponse build() {
            return new ListCertificatesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
