/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a Remote Authentication Dial In User Service (RADIUS) server.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RadiusSettings implements SdkPojo, Serializable, ToCopyableBuilder<RadiusSettings.Builder, RadiusSettings> {
    private static final SdkField<List<String>> RADIUS_SERVERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RadiusServers")
            .getter(getter(RadiusSettings::radiusServers))
            .setter(setter(Builder::radiusServers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RadiusServers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> RADIUS_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RadiusPort").getter(getter(RadiusSettings::radiusPort)).setter(setter(Builder::radiusPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RadiusPort").build()).build();

    private static final SdkField<Integer> RADIUS_TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RadiusTimeout").getter(getter(RadiusSettings::radiusTimeout)).setter(setter(Builder::radiusTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RadiusTimeout").build()).build();

    private static final SdkField<Integer> RADIUS_RETRIES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RadiusRetries").getter(getter(RadiusSettings::radiusRetries)).setter(setter(Builder::radiusRetries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RadiusRetries").build()).build();

    private static final SdkField<String> SHARED_SECRET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SharedSecret").getter(getter(RadiusSettings::sharedSecret)).setter(setter(Builder::sharedSecret))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedSecret").build()).build();

    private static final SdkField<String> AUTHENTICATION_PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthenticationProtocol").getter(getter(RadiusSettings::authenticationProtocolAsString))
            .setter(setter(Builder::authenticationProtocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationProtocol").build())
            .build();

    private static final SdkField<String> DISPLAY_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayLabel").getter(getter(RadiusSettings::displayLabel)).setter(setter(Builder::displayLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayLabel").build()).build();

    private static final SdkField<Boolean> USE_SAME_USERNAME_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UseSameUsername").getter(getter(RadiusSettings::useSameUsername))
            .setter(setter(Builder::useSameUsername))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseSameUsername").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RADIUS_SERVERS_FIELD,
            RADIUS_PORT_FIELD, RADIUS_TIMEOUT_FIELD, RADIUS_RETRIES_FIELD, SHARED_SECRET_FIELD, AUTHENTICATION_PROTOCOL_FIELD,
            DISPLAY_LABEL_FIELD, USE_SAME_USERNAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> radiusServers;

    private final Integer radiusPort;

    private final Integer radiusTimeout;

    private final Integer radiusRetries;

    private final String sharedSecret;

    private final String authenticationProtocol;

    private final String displayLabel;

    private final Boolean useSameUsername;

    private RadiusSettings(BuilderImpl builder) {
        this.radiusServers = builder.radiusServers;
        this.radiusPort = builder.radiusPort;
        this.radiusTimeout = builder.radiusTimeout;
        this.radiusRetries = builder.radiusRetries;
        this.sharedSecret = builder.sharedSecret;
        this.authenticationProtocol = builder.authenticationProtocol;
        this.displayLabel = builder.displayLabel;
        this.useSameUsername = builder.useSameUsername;
    }

    /**
     * Returns true if the RadiusServers property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasRadiusServers() {
        return radiusServers != null && !(radiusServers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of strings that contains the fully qualified domain name (FQDN) or IP addresses of the RADIUS server
     * endpoints, or the FQDN or IP addresses of your RADIUS server load balancer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRadiusServers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of strings that contains the fully qualified domain name (FQDN) or IP addresses of the RADIUS
     *         server endpoints, or the FQDN or IP addresses of your RADIUS server load balancer.
     */
    public List<String> radiusServers() {
        return radiusServers;
    }

    /**
     * <p>
     * The port that your RADIUS server is using for communications. Your on-premises network must allow inbound traffic
     * over this port from the AWS Directory Service servers.
     * </p>
     * 
     * @return The port that your RADIUS server is using for communications. Your on-premises network must allow inbound
     *         traffic over this port from the AWS Directory Service servers.
     */
    public Integer radiusPort() {
        return radiusPort;
    }

    /**
     * <p>
     * The amount of time, in seconds, to wait for the RADIUS server to respond.
     * </p>
     * 
     * @return The amount of time, in seconds, to wait for the RADIUS server to respond.
     */
    public Integer radiusTimeout() {
        return radiusTimeout;
    }

    /**
     * <p>
     * The maximum number of times that communication with the RADIUS server is attempted.
     * </p>
     * 
     * @return The maximum number of times that communication with the RADIUS server is attempted.
     */
    public Integer radiusRetries() {
        return radiusRetries;
    }

    /**
     * <p>
     * Required for enabling RADIUS on the directory.
     * </p>
     * 
     * @return Required for enabling RADIUS on the directory.
     */
    public String sharedSecret() {
        return sharedSecret;
    }

    /**
     * <p>
     * The protocol specified for your RADIUS endpoints.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationProtocol} will return {@link RadiusAuthenticationProtocol#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #authenticationProtocolAsString}.
     * </p>
     * 
     * @return The protocol specified for your RADIUS endpoints.
     * @see RadiusAuthenticationProtocol
     */
    public RadiusAuthenticationProtocol authenticationProtocol() {
        return RadiusAuthenticationProtocol.fromValue(authenticationProtocol);
    }

    /**
     * <p>
     * The protocol specified for your RADIUS endpoints.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationProtocol} will return {@link RadiusAuthenticationProtocol#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #authenticationProtocolAsString}.
     * </p>
     * 
     * @return The protocol specified for your RADIUS endpoints.
     * @see RadiusAuthenticationProtocol
     */
    public String authenticationProtocolAsString() {
        return authenticationProtocol;
    }

    /**
     * <p>
     * Not currently used.
     * </p>
     * 
     * @return Not currently used.
     */
    public String displayLabel() {
        return displayLabel;
    }

    /**
     * <p>
     * Not currently used.
     * </p>
     * 
     * @return Not currently used.
     */
    public Boolean useSameUsername() {
        return useSameUsername;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasRadiusServers() ? radiusServers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(radiusPort());
        hashCode = 31 * hashCode + Objects.hashCode(radiusTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(radiusRetries());
        hashCode = 31 * hashCode + Objects.hashCode(sharedSecret());
        hashCode = 31 * hashCode + Objects.hashCode(authenticationProtocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(displayLabel());
        hashCode = 31 * hashCode + Objects.hashCode(useSameUsername());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RadiusSettings)) {
            return false;
        }
        RadiusSettings other = (RadiusSettings) obj;
        return hasRadiusServers() == other.hasRadiusServers() && Objects.equals(radiusServers(), other.radiusServers())
                && Objects.equals(radiusPort(), other.radiusPort()) && Objects.equals(radiusTimeout(), other.radiusTimeout())
                && Objects.equals(radiusRetries(), other.radiusRetries()) && Objects.equals(sharedSecret(), other.sharedSecret())
                && Objects.equals(authenticationProtocolAsString(), other.authenticationProtocolAsString())
                && Objects.equals(displayLabel(), other.displayLabel())
                && Objects.equals(useSameUsername(), other.useSameUsername());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RadiusSettings").add("RadiusServers", hasRadiusServers() ? radiusServers() : null)
                .add("RadiusPort", radiusPort()).add("RadiusTimeout", radiusTimeout()).add("RadiusRetries", radiusRetries())
                .add("SharedSecret", sharedSecret() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AuthenticationProtocol", authenticationProtocolAsString()).add("DisplayLabel", displayLabel())
                .add("UseSameUsername", useSameUsername()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RadiusServers":
            return Optional.ofNullable(clazz.cast(radiusServers()));
        case "RadiusPort":
            return Optional.ofNullable(clazz.cast(radiusPort()));
        case "RadiusTimeout":
            return Optional.ofNullable(clazz.cast(radiusTimeout()));
        case "RadiusRetries":
            return Optional.ofNullable(clazz.cast(radiusRetries()));
        case "SharedSecret":
            return Optional.ofNullable(clazz.cast(sharedSecret()));
        case "AuthenticationProtocol":
            return Optional.ofNullable(clazz.cast(authenticationProtocolAsString()));
        case "DisplayLabel":
            return Optional.ofNullable(clazz.cast(displayLabel()));
        case "UseSameUsername":
            return Optional.ofNullable(clazz.cast(useSameUsername()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RadiusSettings, T> g) {
        return obj -> g.apply((RadiusSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RadiusSettings> {
        /**
         * <p>
         * An array of strings that contains the fully qualified domain name (FQDN) or IP addresses of the RADIUS server
         * endpoints, or the FQDN or IP addresses of your RADIUS server load balancer.
         * </p>
         * 
         * @param radiusServers
         *        An array of strings that contains the fully qualified domain name (FQDN) or IP addresses of the RADIUS
         *        server endpoints, or the FQDN or IP addresses of your RADIUS server load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder radiusServers(Collection<String> radiusServers);

        /**
         * <p>
         * An array of strings that contains the fully qualified domain name (FQDN) or IP addresses of the RADIUS server
         * endpoints, or the FQDN or IP addresses of your RADIUS server load balancer.
         * </p>
         * 
         * @param radiusServers
         *        An array of strings that contains the fully qualified domain name (FQDN) or IP addresses of the RADIUS
         *        server endpoints, or the FQDN or IP addresses of your RADIUS server load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder radiusServers(String... radiusServers);

        /**
         * <p>
         * The port that your RADIUS server is using for communications. Your on-premises network must allow inbound
         * traffic over this port from the AWS Directory Service servers.
         * </p>
         * 
         * @param radiusPort
         *        The port that your RADIUS server is using for communications. Your on-premises network must allow
         *        inbound traffic over this port from the AWS Directory Service servers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder radiusPort(Integer radiusPort);

        /**
         * <p>
         * The amount of time, in seconds, to wait for the RADIUS server to respond.
         * </p>
         * 
         * @param radiusTimeout
         *        The amount of time, in seconds, to wait for the RADIUS server to respond.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder radiusTimeout(Integer radiusTimeout);

        /**
         * <p>
         * The maximum number of times that communication with the RADIUS server is attempted.
         * </p>
         * 
         * @param radiusRetries
         *        The maximum number of times that communication with the RADIUS server is attempted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder radiusRetries(Integer radiusRetries);

        /**
         * <p>
         * Required for enabling RADIUS on the directory.
         * </p>
         * 
         * @param sharedSecret
         *        Required for enabling RADIUS on the directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedSecret(String sharedSecret);

        /**
         * <p>
         * The protocol specified for your RADIUS endpoints.
         * </p>
         * 
         * @param authenticationProtocol
         *        The protocol specified for your RADIUS endpoints.
         * @see RadiusAuthenticationProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RadiusAuthenticationProtocol
         */
        Builder authenticationProtocol(String authenticationProtocol);

        /**
         * <p>
         * The protocol specified for your RADIUS endpoints.
         * </p>
         * 
         * @param authenticationProtocol
         *        The protocol specified for your RADIUS endpoints.
         * @see RadiusAuthenticationProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RadiusAuthenticationProtocol
         */
        Builder authenticationProtocol(RadiusAuthenticationProtocol authenticationProtocol);

        /**
         * <p>
         * Not currently used.
         * </p>
         * 
         * @param displayLabel
         *        Not currently used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayLabel(String displayLabel);

        /**
         * <p>
         * Not currently used.
         * </p>
         * 
         * @param useSameUsername
         *        Not currently used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useSameUsername(Boolean useSameUsername);
    }

    static final class BuilderImpl implements Builder {
        private List<String> radiusServers = DefaultSdkAutoConstructList.getInstance();

        private Integer radiusPort;

        private Integer radiusTimeout;

        private Integer radiusRetries;

        private String sharedSecret;

        private String authenticationProtocol;

        private String displayLabel;

        private Boolean useSameUsername;

        private BuilderImpl() {
        }

        private BuilderImpl(RadiusSettings model) {
            radiusServers(model.radiusServers);
            radiusPort(model.radiusPort);
            radiusTimeout(model.radiusTimeout);
            radiusRetries(model.radiusRetries);
            sharedSecret(model.sharedSecret);
            authenticationProtocol(model.authenticationProtocol);
            displayLabel(model.displayLabel);
            useSameUsername(model.useSameUsername);
        }

        public final Collection<String> getRadiusServers() {
            if (radiusServers instanceof SdkAutoConstructList) {
                return null;
            }
            return radiusServers;
        }

        @Override
        public final Builder radiusServers(Collection<String> radiusServers) {
            this.radiusServers = ServersCopier.copy(radiusServers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder radiusServers(String... radiusServers) {
            radiusServers(Arrays.asList(radiusServers));
            return this;
        }

        public final void setRadiusServers(Collection<String> radiusServers) {
            this.radiusServers = ServersCopier.copy(radiusServers);
        }

        public final Integer getRadiusPort() {
            return radiusPort;
        }

        @Override
        public final Builder radiusPort(Integer radiusPort) {
            this.radiusPort = radiusPort;
            return this;
        }

        public final void setRadiusPort(Integer radiusPort) {
            this.radiusPort = radiusPort;
        }

        public final Integer getRadiusTimeout() {
            return radiusTimeout;
        }

        @Override
        public final Builder radiusTimeout(Integer radiusTimeout) {
            this.radiusTimeout = radiusTimeout;
            return this;
        }

        public final void setRadiusTimeout(Integer radiusTimeout) {
            this.radiusTimeout = radiusTimeout;
        }

        public final Integer getRadiusRetries() {
            return radiusRetries;
        }

        @Override
        public final Builder radiusRetries(Integer radiusRetries) {
            this.radiusRetries = radiusRetries;
            return this;
        }

        public final void setRadiusRetries(Integer radiusRetries) {
            this.radiusRetries = radiusRetries;
        }

        public final String getSharedSecret() {
            return sharedSecret;
        }

        @Override
        public final Builder sharedSecret(String sharedSecret) {
            this.sharedSecret = sharedSecret;
            return this;
        }

        public final void setSharedSecret(String sharedSecret) {
            this.sharedSecret = sharedSecret;
        }

        public final String getAuthenticationProtocol() {
            return authenticationProtocol;
        }

        @Override
        public final Builder authenticationProtocol(String authenticationProtocol) {
            this.authenticationProtocol = authenticationProtocol;
            return this;
        }

        @Override
        public final Builder authenticationProtocol(RadiusAuthenticationProtocol authenticationProtocol) {
            this.authenticationProtocol(authenticationProtocol == null ? null : authenticationProtocol.toString());
            return this;
        }

        public final void setAuthenticationProtocol(String authenticationProtocol) {
            this.authenticationProtocol = authenticationProtocol;
        }

        public final String getDisplayLabel() {
            return displayLabel;
        }

        @Override
        public final Builder displayLabel(String displayLabel) {
            this.displayLabel = displayLabel;
            return this;
        }

        public final void setDisplayLabel(String displayLabel) {
            this.displayLabel = displayLabel;
        }

        public final Boolean getUseSameUsername() {
            return useSameUsername;
        }

        @Override
        public final Builder useSameUsername(Boolean useSameUsername) {
            this.useSameUsername = useSameUsername;
            return this;
        }

        public final void setUseSameUsername(Boolean useSameUsername) {
            this.useSameUsername = useSameUsername;
        }

        @Override
        public RadiusSettings build() {
            return new RadiusSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
