/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directory.model.DirectoryRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteConditionalForwarderRequest
extends DirectoryRequest
implements ToCopyableBuilder<Builder, DeleteConditionalForwarderRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryId").getter(DeleteConditionalForwarderRequest.getter(DeleteConditionalForwarderRequest::directoryId)).setter(DeleteConditionalForwarderRequest.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()}).build();
    private static final SdkField<String> REMOTE_DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RemoteDomainName").getter(DeleteConditionalForwarderRequest.getter(DeleteConditionalForwarderRequest::remoteDomainName)).setter(DeleteConditionalForwarderRequest.setter(Builder::remoteDomainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoteDomainName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD, REMOTE_DOMAIN_NAME_FIELD));
    private final String directoryId;
    private final String remoteDomainName;

    private DeleteConditionalForwarderRequest(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.remoteDomainName = builder.remoteDomainName;
    }

    public String directoryId() {
        return this.directoryId;
    }

    public String remoteDomainName() {
        return this.remoteDomainName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteDomainName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteConditionalForwarderRequest)) {
            return false;
        }
        DeleteConditionalForwarderRequest other = (DeleteConditionalForwarderRequest)((Object)obj);
        return Objects.equals(this.directoryId(), other.directoryId()) && Objects.equals(this.remoteDomainName(), other.remoteDomainName());
    }

    public String toString() {
        return ToString.builder((String)"DeleteConditionalForwarderRequest").add("DirectoryId", (Object)this.directoryId()).add("RemoteDomainName", (Object)this.remoteDomainName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "RemoteDomainName": {
                return Optional.ofNullable(clazz.cast(this.remoteDomainName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteConditionalForwarderRequest, T> g) {
        return obj -> g.apply((DeleteConditionalForwarderRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectoryRequest.BuilderImpl
    implements Builder {
        private String directoryId;
        private String remoteDomainName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteConditionalForwarderRequest model) {
            super(model);
            this.directoryId(model.directoryId);
            this.remoteDomainName(model.remoteDomainName);
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        public final String getRemoteDomainName() {
            return this.remoteDomainName;
        }

        @Override
        public final Builder remoteDomainName(String remoteDomainName) {
            this.remoteDomainName = remoteDomainName;
            return this;
        }

        public final void setRemoteDomainName(String remoteDomainName) {
            this.remoteDomainName = remoteDomainName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteConditionalForwarderRequest build() {
            return new DeleteConditionalForwarderRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DirectoryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteConditionalForwarderRequest> {
        public Builder directoryId(String var1);

        public Builder remoteDomainName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

