/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directory.model.DirectoryResponse;
import software.amazon.awssdk.services.directory.model.Trust;
import software.amazon.awssdk.services.directory.model.TrustsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTrustsResponse
extends DirectoryResponse
implements ToCopyableBuilder<Builder, DescribeTrustsResponse> {
    private static final SdkField<List<Trust>> TRUSTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Trusts").getter(DescribeTrustsResponse.getter(DescribeTrustsResponse::trusts)).setter(DescribeTrustsResponse.setter(Builder::trusts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Trusts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Trust::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeTrustsResponse.getter(DescribeTrustsResponse::nextToken)).setter(DescribeTrustsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRUSTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<Trust> trusts;
    private final String nextToken;

    private DescribeTrustsResponse(BuilderImpl builder) {
        super(builder);
        this.trusts = builder.trusts;
        this.nextToken = builder.nextToken;
    }

    public boolean hasTrusts() {
        return this.trusts != null && !(this.trusts instanceof SdkAutoConstructList);
    }

    public List<Trust> trusts() {
        return this.trusts;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTrusts() ? this.trusts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrustsResponse)) {
            return false;
        }
        DescribeTrustsResponse other = (DescribeTrustsResponse)((Object)obj);
        return this.hasTrusts() == other.hasTrusts() && Objects.equals(this.trusts(), other.trusts()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeTrustsResponse").add("Trusts", this.hasTrusts() ? this.trusts() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Trusts": {
                return Optional.ofNullable(clazz.cast(this.trusts()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTrustsResponse, T> g) {
        return obj -> g.apply((DescribeTrustsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectoryResponse.BuilderImpl
    implements Builder {
        private List<Trust> trusts = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTrustsResponse model) {
            super(model);
            this.trusts(model.trusts);
            this.nextToken(model.nextToken);
        }

        public final Collection<Trust.Builder> getTrusts() {
            if (this.trusts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.trusts != null ? (Collection)this.trusts.stream().map(Trust::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder trusts(Collection<Trust> trusts) {
            this.trusts = TrustsCopier.copy(trusts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trusts(Trust ... trusts) {
            this.trusts(Arrays.asList(trusts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trusts(Consumer<Trust.Builder> ... trusts) {
            this.trusts(Stream.of(trusts).map(c -> (Trust)((Trust.Builder)Trust.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTrusts(Collection<Trust.BuilderImpl> trusts) {
            this.trusts = TrustsCopier.copyFromBuilder(trusts);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeTrustsResponse build() {
            return new DescribeTrustsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DirectoryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTrustsResponse> {
        public Builder trusts(Collection<Trust> var1);

        public Builder trusts(Trust ... var1);

        public Builder trusts(Consumer<Trust.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

