/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directory.model.ShareMethod;
import software.amazon.awssdk.services.directory.model.ShareStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SharedDirectory
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SharedDirectory> {
    private static final SdkField<String> OWNER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerAccountId").getter(SharedDirectory.getter(SharedDirectory::ownerAccountId)).setter(SharedDirectory.setter(Builder::ownerAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAccountId").build()}).build();
    private static final SdkField<String> OWNER_DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerDirectoryId").getter(SharedDirectory.getter(SharedDirectory::ownerDirectoryId)).setter(SharedDirectory.setter(Builder::ownerDirectoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerDirectoryId").build()}).build();
    private static final SdkField<String> SHARE_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ShareMethod").getter(SharedDirectory.getter(SharedDirectory::shareMethodAsString)).setter(SharedDirectory.setter(Builder::shareMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareMethod").build()}).build();
    private static final SdkField<String> SHARED_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SharedAccountId").getter(SharedDirectory.getter(SharedDirectory::sharedAccountId)).setter(SharedDirectory.setter(Builder::sharedAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedAccountId").build()}).build();
    private static final SdkField<String> SHARED_DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SharedDirectoryId").getter(SharedDirectory.getter(SharedDirectory::sharedDirectoryId)).setter(SharedDirectory.setter(Builder::sharedDirectoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedDirectoryId").build()}).build();
    private static final SdkField<String> SHARE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ShareStatus").getter(SharedDirectory.getter(SharedDirectory::shareStatusAsString)).setter(SharedDirectory.setter(Builder::shareStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareStatus").build()}).build();
    private static final SdkField<String> SHARE_NOTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ShareNotes").getter(SharedDirectory.getter(SharedDirectory::shareNotes)).setter(SharedDirectory.setter(Builder::shareNotes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareNotes").build()}).build();
    private static final SdkField<Instant> CREATED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedDateTime").getter(SharedDirectory.getter(SharedDirectory::createdDateTime)).setter(SharedDirectory.setter(Builder::createdDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDateTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedDateTime").getter(SharedDirectory.getter(SharedDirectory::lastUpdatedDateTime)).setter(SharedDirectory.setter(Builder::lastUpdatedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedDateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_ACCOUNT_ID_FIELD, OWNER_DIRECTORY_ID_FIELD, SHARE_METHOD_FIELD, SHARED_ACCOUNT_ID_FIELD, SHARED_DIRECTORY_ID_FIELD, SHARE_STATUS_FIELD, SHARE_NOTES_FIELD, CREATED_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String ownerAccountId;
    private final String ownerDirectoryId;
    private final String shareMethod;
    private final String sharedAccountId;
    private final String sharedDirectoryId;
    private final String shareStatus;
    private final String shareNotes;
    private final Instant createdDateTime;
    private final Instant lastUpdatedDateTime;

    private SharedDirectory(BuilderImpl builder) {
        this.ownerAccountId = builder.ownerAccountId;
        this.ownerDirectoryId = builder.ownerDirectoryId;
        this.shareMethod = builder.shareMethod;
        this.sharedAccountId = builder.sharedAccountId;
        this.sharedDirectoryId = builder.sharedDirectoryId;
        this.shareStatus = builder.shareStatus;
        this.shareNotes = builder.shareNotes;
        this.createdDateTime = builder.createdDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
    }

    public String ownerAccountId() {
        return this.ownerAccountId;
    }

    public String ownerDirectoryId() {
        return this.ownerDirectoryId;
    }

    public ShareMethod shareMethod() {
        return ShareMethod.fromValue(this.shareMethod);
    }

    public String shareMethodAsString() {
        return this.shareMethod;
    }

    public String sharedAccountId() {
        return this.sharedAccountId;
    }

    public String sharedDirectoryId() {
        return this.sharedDirectoryId;
    }

    public ShareStatus shareStatus() {
        return ShareStatus.fromValue(this.shareStatus);
    }

    public String shareStatusAsString() {
        return this.shareStatus;
    }

    public String shareNotes() {
        return this.shareNotes;
    }

    public Instant createdDateTime() {
        return this.createdDateTime;
    }

    public Instant lastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerDirectoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.shareMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sharedAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sharedDirectoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.shareStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.shareNotes());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDateTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SharedDirectory)) {
            return false;
        }
        SharedDirectory other = (SharedDirectory)obj;
        return Objects.equals(this.ownerAccountId(), other.ownerAccountId()) && Objects.equals(this.ownerDirectoryId(), other.ownerDirectoryId()) && Objects.equals(this.shareMethodAsString(), other.shareMethodAsString()) && Objects.equals(this.sharedAccountId(), other.sharedAccountId()) && Objects.equals(this.sharedDirectoryId(), other.sharedDirectoryId()) && Objects.equals(this.shareStatusAsString(), other.shareStatusAsString()) && Objects.equals(this.shareNotes(), other.shareNotes()) && Objects.equals(this.createdDateTime(), other.createdDateTime()) && Objects.equals(this.lastUpdatedDateTime(), other.lastUpdatedDateTime());
    }

    public String toString() {
        return ToString.builder((String)"SharedDirectory").add("OwnerAccountId", (Object)this.ownerAccountId()).add("OwnerDirectoryId", (Object)this.ownerDirectoryId()).add("ShareMethod", (Object)this.shareMethodAsString()).add("SharedAccountId", (Object)this.sharedAccountId()).add("SharedDirectoryId", (Object)this.sharedDirectoryId()).add("ShareStatus", (Object)this.shareStatusAsString()).add("ShareNotes", (Object)(this.shareNotes() == null ? null : "*** Sensitive Data Redacted ***")).add("CreatedDateTime", (Object)this.createdDateTime()).add("LastUpdatedDateTime", (Object)this.lastUpdatedDateTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OwnerAccountId": {
                return Optional.ofNullable(clazz.cast(this.ownerAccountId()));
            }
            case "OwnerDirectoryId": {
                return Optional.ofNullable(clazz.cast(this.ownerDirectoryId()));
            }
            case "ShareMethod": {
                return Optional.ofNullable(clazz.cast(this.shareMethodAsString()));
            }
            case "SharedAccountId": {
                return Optional.ofNullable(clazz.cast(this.sharedAccountId()));
            }
            case "SharedDirectoryId": {
                return Optional.ofNullable(clazz.cast(this.sharedDirectoryId()));
            }
            case "ShareStatus": {
                return Optional.ofNullable(clazz.cast(this.shareStatusAsString()));
            }
            case "ShareNotes": {
                return Optional.ofNullable(clazz.cast(this.shareNotes()));
            }
            case "CreatedDateTime": {
                return Optional.ofNullable(clazz.cast(this.createdDateTime()));
            }
            case "LastUpdatedDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDateTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SharedDirectory, T> g) {
        return obj -> g.apply((SharedDirectory)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ownerAccountId;
        private String ownerDirectoryId;
        private String shareMethod;
        private String sharedAccountId;
        private String sharedDirectoryId;
        private String shareStatus;
        private String shareNotes;
        private Instant createdDateTime;
        private Instant lastUpdatedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(SharedDirectory model) {
            this.ownerAccountId(model.ownerAccountId);
            this.ownerDirectoryId(model.ownerDirectoryId);
            this.shareMethod(model.shareMethod);
            this.sharedAccountId(model.sharedAccountId);
            this.sharedDirectoryId(model.sharedDirectoryId);
            this.shareStatus(model.shareStatus);
            this.shareNotes(model.shareNotes);
            this.createdDateTime(model.createdDateTime);
            this.lastUpdatedDateTime(model.lastUpdatedDateTime);
        }

        public final String getOwnerAccountId() {
            return this.ownerAccountId;
        }

        @Override
        public final Builder ownerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
            return this;
        }

        public final void setOwnerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
        }

        public final String getOwnerDirectoryId() {
            return this.ownerDirectoryId;
        }

        @Override
        public final Builder ownerDirectoryId(String ownerDirectoryId) {
            this.ownerDirectoryId = ownerDirectoryId;
            return this;
        }

        public final void setOwnerDirectoryId(String ownerDirectoryId) {
            this.ownerDirectoryId = ownerDirectoryId;
        }

        public final String getShareMethod() {
            return this.shareMethod;
        }

        @Override
        public final Builder shareMethod(String shareMethod) {
            this.shareMethod = shareMethod;
            return this;
        }

        @Override
        public final Builder shareMethod(ShareMethod shareMethod) {
            this.shareMethod(shareMethod == null ? null : shareMethod.toString());
            return this;
        }

        public final void setShareMethod(String shareMethod) {
            this.shareMethod = shareMethod;
        }

        public final String getSharedAccountId() {
            return this.sharedAccountId;
        }

        @Override
        public final Builder sharedAccountId(String sharedAccountId) {
            this.sharedAccountId = sharedAccountId;
            return this;
        }

        public final void setSharedAccountId(String sharedAccountId) {
            this.sharedAccountId = sharedAccountId;
        }

        public final String getSharedDirectoryId() {
            return this.sharedDirectoryId;
        }

        @Override
        public final Builder sharedDirectoryId(String sharedDirectoryId) {
            this.sharedDirectoryId = sharedDirectoryId;
            return this;
        }

        public final void setSharedDirectoryId(String sharedDirectoryId) {
            this.sharedDirectoryId = sharedDirectoryId;
        }

        public final String getShareStatus() {
            return this.shareStatus;
        }

        @Override
        public final Builder shareStatus(String shareStatus) {
            this.shareStatus = shareStatus;
            return this;
        }

        @Override
        public final Builder shareStatus(ShareStatus shareStatus) {
            this.shareStatus(shareStatus == null ? null : shareStatus.toString());
            return this;
        }

        public final void setShareStatus(String shareStatus) {
            this.shareStatus = shareStatus;
        }

        public final String getShareNotes() {
            return this.shareNotes;
        }

        @Override
        public final Builder shareNotes(String shareNotes) {
            this.shareNotes = shareNotes;
            return this;
        }

        public final void setShareNotes(String shareNotes) {
            this.shareNotes = shareNotes;
        }

        public final Instant getCreatedDateTime() {
            return this.createdDateTime;
        }

        @Override
        public final Builder createdDateTime(Instant createdDateTime) {
            this.createdDateTime = createdDateTime;
            return this;
        }

        public final void setCreatedDateTime(Instant createdDateTime) {
            this.createdDateTime = createdDateTime;
        }

        public final Instant getLastUpdatedDateTime() {
            return this.lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        public SharedDirectory build() {
            return new SharedDirectory(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SharedDirectory> {
        public Builder ownerAccountId(String var1);

        public Builder ownerDirectoryId(String var1);

        public Builder shareMethod(String var1);

        public Builder shareMethod(ShareMethod var1);

        public Builder sharedAccountId(String var1);

        public Builder sharedDirectoryId(String var1);

        public Builder shareStatus(String var1);

        public Builder shareStatus(ShareStatus var1);

        public Builder shareNotes(String var1);

        public Builder createdDateTime(Instant var1);

        public Builder lastUpdatedDateTime(Instant var1);
    }
}

