/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directory.model.DirectoryResponse;
import software.amazon.awssdk.services.directory.model.SharedDirectoriesCopier;
import software.amazon.awssdk.services.directory.model.SharedDirectory;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSharedDirectoriesResponse
extends DirectoryResponse
implements ToCopyableBuilder<Builder, DescribeSharedDirectoriesResponse> {
    private static final SdkField<List<SharedDirectory>> SHARED_DIRECTORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SharedDirectories").getter(DescribeSharedDirectoriesResponse.getter(DescribeSharedDirectoriesResponse::sharedDirectories)).setter(DescribeSharedDirectoriesResponse.setter(Builder::sharedDirectories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedDirectories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SharedDirectory::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeSharedDirectoriesResponse.getter(DescribeSharedDirectoriesResponse::nextToken)).setter(DescribeSharedDirectoriesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARED_DIRECTORIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<SharedDirectory> sharedDirectories;
    private final String nextToken;

    private DescribeSharedDirectoriesResponse(BuilderImpl builder) {
        super(builder);
        this.sharedDirectories = builder.sharedDirectories;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSharedDirectories() {
        return this.sharedDirectories != null && !(this.sharedDirectories instanceof SdkAutoConstructList);
    }

    public final List<SharedDirectory> sharedDirectories() {
        return this.sharedDirectories;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSharedDirectories() ? this.sharedDirectories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSharedDirectoriesResponse)) {
            return false;
        }
        DescribeSharedDirectoriesResponse other = (DescribeSharedDirectoriesResponse)((Object)obj);
        return this.hasSharedDirectories() == other.hasSharedDirectories() && Objects.equals(this.sharedDirectories(), other.sharedDirectories()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeSharedDirectoriesResponse").add("SharedDirectories", this.hasSharedDirectories() ? this.sharedDirectories() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SharedDirectories": {
                return Optional.ofNullable(clazz.cast(this.sharedDirectories()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSharedDirectoriesResponse, T> g) {
        return obj -> g.apply((DescribeSharedDirectoriesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectoryResponse.BuilderImpl
    implements Builder {
        private List<SharedDirectory> sharedDirectories = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSharedDirectoriesResponse model) {
            super(model);
            this.sharedDirectories(model.sharedDirectories);
            this.nextToken(model.nextToken);
        }

        public final Collection<SharedDirectory.Builder> getSharedDirectories() {
            if (this.sharedDirectories instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sharedDirectories != null ? (Collection)this.sharedDirectories.stream().map(SharedDirectory::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sharedDirectories(Collection<SharedDirectory> sharedDirectories) {
            this.sharedDirectories = SharedDirectoriesCopier.copy(sharedDirectories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sharedDirectories(SharedDirectory ... sharedDirectories) {
            this.sharedDirectories(Arrays.asList(sharedDirectories));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sharedDirectories(Consumer<SharedDirectory.Builder> ... sharedDirectories) {
            this.sharedDirectories(Stream.of(sharedDirectories).map(c -> (SharedDirectory)((SharedDirectory.Builder)SharedDirectory.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSharedDirectories(Collection<SharedDirectory.BuilderImpl> sharedDirectories) {
            this.sharedDirectories = SharedDirectoriesCopier.copyFromBuilder(sharedDirectories);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeSharedDirectoriesResponse build() {
            return new DescribeSharedDirectoriesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DirectoryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSharedDirectoriesResponse> {
        public Builder sharedDirectories(Collection<SharedDirectory> var1);

        public Builder sharedDirectories(SharedDirectory ... var1);

        public Builder sharedDirectories(Consumer<SharedDirectory.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

