/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DirectorySize {
    SMALL("Small"),
    LARGE("Large"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DirectorySize(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DirectorySize fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DirectorySize.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DirectorySize> knownValues() {
        return Stream.of(DirectorySize.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

