/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the inputs for the <a>ConnectDirectory</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectDirectoryRequest extends DirectoryRequest implements
        ToCopyableBuilder<ConnectDirectoryRequest.Builder, ConnectDirectoryRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ConnectDirectoryRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> SHORT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ShortName").getter(getter(ConnectDirectoryRequest::shortName)).setter(setter(Builder::shortName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShortName").build()).build();

    private static final SdkField<String> PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Password").getter(getter(ConnectDirectoryRequest::password)).setter(setter(Builder::password))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ConnectDirectoryRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> SIZE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Size")
            .getter(getter(ConnectDirectoryRequest::sizeAsString)).setter(setter(Builder::size))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size").build()).build();

    private static final SdkField<DirectoryConnectSettings> CONNECT_SETTINGS_FIELD = SdkField
            .<DirectoryConnectSettings> builder(MarshallingType.SDK_POJO).memberName("ConnectSettings")
            .getter(getter(ConnectDirectoryRequest::connectSettings)).setter(setter(Builder::connectSettings))
            .constructor(DirectoryConnectSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectSettings").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(ConnectDirectoryRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SHORT_NAME_FIELD,
            PASSWORD_FIELD, DESCRIPTION_FIELD, SIZE_FIELD, CONNECT_SETTINGS_FIELD, TAGS_FIELD));

    private final String name;

    private final String shortName;

    private final String password;

    private final String description;

    private final String size;

    private final DirectoryConnectSettings connectSettings;

    private final List<Tag> tags;

    private ConnectDirectoryRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.shortName = builder.shortName;
        this.password = builder.password;
        this.description = builder.description;
        this.size = builder.size;
        this.connectSettings = builder.connectSettings;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The fully qualified name of the on-premises directory, such as <code>corp.example.com</code>.
     * </p>
     * 
     * @return The fully qualified name of the on-premises directory, such as <code>corp.example.com</code>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The NetBIOS name of the on-premises directory, such as <code>CORP</code>.
     * </p>
     * 
     * @return The NetBIOS name of the on-premises directory, such as <code>CORP</code>.
     */
    public final String shortName() {
        return shortName;
    }

    /**
     * <p>
     * The password for the on-premises user account.
     * </p>
     * 
     * @return The password for the on-premises user account.
     */
    public final String password() {
        return password;
    }

    /**
     * <p>
     * A description for the directory.
     * </p>
     * 
     * @return A description for the directory.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The size of the directory.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #size} will return
     * {@link DirectorySize#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sizeAsString}.
     * </p>
     * 
     * @return The size of the directory.
     * @see DirectorySize
     */
    public final DirectorySize size() {
        return DirectorySize.fromValue(size);
    }

    /**
     * <p>
     * The size of the directory.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #size} will return
     * {@link DirectorySize#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sizeAsString}.
     * </p>
     * 
     * @return The size of the directory.
     * @see DirectorySize
     */
    public final String sizeAsString() {
        return size;
    }

    /**
     * <p>
     * A <a>DirectoryConnectSettings</a> object that contains additional information for the operation.
     * </p>
     * 
     * @return A <a>DirectoryConnectSettings</a> object that contains additional information for the operation.
     */
    public final DirectoryConnectSettings connectSettings() {
        return connectSettings;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to be assigned to AD Connector.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags to be assigned to AD Connector.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(shortName());
        hashCode = 31 * hashCode + Objects.hashCode(password());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(sizeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(connectSettings());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectDirectoryRequest)) {
            return false;
        }
        ConnectDirectoryRequest other = (ConnectDirectoryRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(shortName(), other.shortName())
                && Objects.equals(password(), other.password()) && Objects.equals(description(), other.description())
                && Objects.equals(sizeAsString(), other.sizeAsString())
                && Objects.equals(connectSettings(), other.connectSettings()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectDirectoryRequest").add("Name", name()).add("ShortName", shortName())
                .add("Password", password() == null ? null : "*** Sensitive Data Redacted ***").add("Description", description())
                .add("Size", sizeAsString()).add("ConnectSettings", connectSettings()).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ShortName":
            return Optional.ofNullable(clazz.cast(shortName()));
        case "Password":
            return Optional.ofNullable(clazz.cast(password()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Size":
            return Optional.ofNullable(clazz.cast(sizeAsString()));
        case "ConnectSettings":
            return Optional.ofNullable(clazz.cast(connectSettings()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectDirectoryRequest, T> g) {
        return obj -> g.apply((ConnectDirectoryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectoryRequest.Builder, SdkPojo, CopyableBuilder<Builder, ConnectDirectoryRequest> {
        /**
         * <p>
         * The fully qualified name of the on-premises directory, such as <code>corp.example.com</code>.
         * </p>
         * 
         * @param name
         *        The fully qualified name of the on-premises directory, such as <code>corp.example.com</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The NetBIOS name of the on-premises directory, such as <code>CORP</code>.
         * </p>
         * 
         * @param shortName
         *        The NetBIOS name of the on-premises directory, such as <code>CORP</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shortName(String shortName);

        /**
         * <p>
         * The password for the on-premises user account.
         * </p>
         * 
         * @param password
         *        The password for the on-premises user account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder password(String password);

        /**
         * <p>
         * A description for the directory.
         * </p>
         * 
         * @param description
         *        A description for the directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The size of the directory.
         * </p>
         * 
         * @param size
         *        The size of the directory.
         * @see DirectorySize
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DirectorySize
         */
        Builder size(String size);

        /**
         * <p>
         * The size of the directory.
         * </p>
         * 
         * @param size
         *        The size of the directory.
         * @see DirectorySize
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DirectorySize
         */
        Builder size(DirectorySize size);

        /**
         * <p>
         * A <a>DirectoryConnectSettings</a> object that contains additional information for the operation.
         * </p>
         * 
         * @param connectSettings
         *        A <a>DirectoryConnectSettings</a> object that contains additional information for the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectSettings(DirectoryConnectSettings connectSettings);

        /**
         * <p>
         * A <a>DirectoryConnectSettings</a> object that contains additional information for the operation.
         * </p>
         * This is a convenience that creates an instance of the {@link DirectoryConnectSettings.Builder} avoiding the
         * need to create one manually via {@link DirectoryConnectSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link DirectoryConnectSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #connectSettings(DirectoryConnectSettings)}.
         * 
         * @param connectSettings
         *        a consumer that will call methods on {@link DirectoryConnectSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectSettings(DirectoryConnectSettings)
         */
        default Builder connectSettings(Consumer<DirectoryConnectSettings.Builder> connectSettings) {
            return connectSettings(DirectoryConnectSettings.builder().applyMutation(connectSettings).build());
        }

        /**
         * <p>
         * The tags to be assigned to AD Connector.
         * </p>
         * 
         * @param tags
         *        The tags to be assigned to AD Connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags to be assigned to AD Connector.
         * </p>
         * 
         * @param tags
         *        The tags to be assigned to AD Connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags to be assigned to AD Connector.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectoryRequest.BuilderImpl implements Builder {
        private String name;

        private String shortName;

        private String password;

        private String description;

        private String size;

        private DirectoryConnectSettings connectSettings;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectDirectoryRequest model) {
            super(model);
            name(model.name);
            shortName(model.shortName);
            password(model.password);
            description(model.description);
            size(model.size);
            connectSettings(model.connectSettings);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getShortName() {
            return shortName;
        }

        @Override
        public final Builder shortName(String shortName) {
            this.shortName = shortName;
            return this;
        }

        public final void setShortName(String shortName) {
            this.shortName = shortName;
        }

        public final String getPassword() {
            return password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getSize() {
            return size;
        }

        @Override
        public final Builder size(String size) {
            this.size = size;
            return this;
        }

        @Override
        public final Builder size(DirectorySize size) {
            this.size(size == null ? null : size.toString());
            return this;
        }

        public final void setSize(String size) {
            this.size = size;
        }

        public final DirectoryConnectSettings.Builder getConnectSettings() {
            return connectSettings != null ? connectSettings.toBuilder() : null;
        }

        @Override
        public final Builder connectSettings(DirectoryConnectSettings connectSettings) {
            this.connectSettings = connectSettings;
            return this;
        }

        public final void setConnectSettings(DirectoryConnectSettings.BuilderImpl connectSettings) {
            this.connectSettings = connectSettings != null ? connectSettings.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            if (tags instanceof SdkAutoConstructList) {
                return null;
            }
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ConnectDirectoryRequest build() {
            return new ConnectDirectoryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
