/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the results for the <a>CreateComputer</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateComputerResponse extends DirectoryResponse implements
        ToCopyableBuilder<CreateComputerResponse.Builder, CreateComputerResponse> {
    private static final SdkField<Computer> COMPUTER_FIELD = SdkField.<Computer> builder(MarshallingType.SDK_POJO)
            .memberName("Computer").getter(getter(CreateComputerResponse::computer)).setter(setter(Builder::computer))
            .constructor(Computer::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Computer").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTER_FIELD));

    private final Computer computer;

    private CreateComputerResponse(BuilderImpl builder) {
        super(builder);
        this.computer = builder.computer;
    }

    /**
     * <p>
     * A <a>Computer</a> object that represents the computer account.
     * </p>
     * 
     * @return A <a>Computer</a> object that represents the computer account.
     */
    public final Computer computer() {
        return computer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(computer());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateComputerResponse)) {
            return false;
        }
        CreateComputerResponse other = (CreateComputerResponse) obj;
        return Objects.equals(computer(), other.computer());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateComputerResponse").add("Computer", computer()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Computer":
            return Optional.ofNullable(clazz.cast(computer()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateComputerResponse, T> g) {
        return obj -> g.apply((CreateComputerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectoryResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateComputerResponse> {
        /**
         * <p>
         * A <a>Computer</a> object that represents the computer account.
         * </p>
         * 
         * @param computer
         *        A <a>Computer</a> object that represents the computer account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computer(Computer computer);

        /**
         * <p>
         * A <a>Computer</a> object that represents the computer account.
         * </p>
         * This is a convenience that creates an instance of the {@link Computer.Builder} avoiding the need to create
         * one manually via {@link Computer#builder()}.
         *
         * When the {@link Consumer} completes, {@link Computer.Builder#build()} is called immediately and its result is
         * passed to {@link #computer(Computer)}.
         * 
         * @param computer
         *        a consumer that will call methods on {@link Computer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #computer(Computer)
         */
        default Builder computer(Consumer<Computer.Builder> computer) {
            return computer(Computer.builder().applyMutation(computer).build());
        }
    }

    static final class BuilderImpl extends DirectoryResponse.BuilderImpl implements Builder {
        private Computer computer;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateComputerResponse model) {
            super(model);
            computer(model.computer);
        }

        public final Computer.Builder getComputer() {
            return computer != null ? computer.toBuilder() : null;
        }

        @Override
        public final Builder computer(Computer computer) {
            this.computer = computer;
            return this;
        }

        public final void setComputer(Computer.BuilderImpl computer) {
            this.computer = computer != null ? computer.build() : null;
        }

        @Override
        public CreateComputerResponse build() {
            return new CreateComputerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
