/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directory.model.DirectoryVpcSettingsDescription;
import software.amazon.awssdk.services.directory.model.DnsIpAddrsCopier;
import software.amazon.awssdk.services.directory.model.RadiusSettings;
import software.amazon.awssdk.services.directory.model.RadiusStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OwnerDirectoryDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OwnerDirectoryDescription> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryId").getter(OwnerDirectoryDescription.getter(OwnerDirectoryDescription::directoryId)).setter(OwnerDirectoryDescription.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(OwnerDirectoryDescription.getter(OwnerDirectoryDescription::accountId)).setter(OwnerDirectoryDescription.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<List<String>> DNS_IP_ADDRS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DnsIpAddrs").getter(OwnerDirectoryDescription.getter(OwnerDirectoryDescription::dnsIpAddrs)).setter(OwnerDirectoryDescription.setter(Builder::dnsIpAddrs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsIpAddrs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DirectoryVpcSettingsDescription> VPC_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcSettings").getter(OwnerDirectoryDescription.getter(OwnerDirectoryDescription::vpcSettings)).setter(OwnerDirectoryDescription.setter(Builder::vpcSettings)).constructor(DirectoryVpcSettingsDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSettings").build()}).build();
    private static final SdkField<RadiusSettings> RADIUS_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RadiusSettings").getter(OwnerDirectoryDescription.getter(OwnerDirectoryDescription::radiusSettings)).setter(OwnerDirectoryDescription.setter(Builder::radiusSettings)).constructor(RadiusSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RadiusSettings").build()}).build();
    private static final SdkField<String> RADIUS_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RadiusStatus").getter(OwnerDirectoryDescription.getter(OwnerDirectoryDescription::radiusStatusAsString)).setter(OwnerDirectoryDescription.setter(Builder::radiusStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RadiusStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD, ACCOUNT_ID_FIELD, DNS_IP_ADDRS_FIELD, VPC_SETTINGS_FIELD, RADIUS_SETTINGS_FIELD, RADIUS_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String directoryId;
    private final String accountId;
    private final List<String> dnsIpAddrs;
    private final DirectoryVpcSettingsDescription vpcSettings;
    private final RadiusSettings radiusSettings;
    private final String radiusStatus;

    private OwnerDirectoryDescription(BuilderImpl builder) {
        this.directoryId = builder.directoryId;
        this.accountId = builder.accountId;
        this.dnsIpAddrs = builder.dnsIpAddrs;
        this.vpcSettings = builder.vpcSettings;
        this.radiusSettings = builder.radiusSettings;
        this.radiusStatus = builder.radiusStatus;
    }

    public final String directoryId() {
        return this.directoryId;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final boolean hasDnsIpAddrs() {
        return this.dnsIpAddrs != null && !(this.dnsIpAddrs instanceof SdkAutoConstructList);
    }

    public final List<String> dnsIpAddrs() {
        return this.dnsIpAddrs;
    }

    public final DirectoryVpcSettingsDescription vpcSettings() {
        return this.vpcSettings;
    }

    public final RadiusSettings radiusSettings() {
        return this.radiusSettings;
    }

    public final RadiusStatus radiusStatus() {
        return RadiusStatus.fromValue(this.radiusStatus);
    }

    public final String radiusStatusAsString() {
        return this.radiusStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDnsIpAddrs() ? this.dnsIpAddrs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.radiusSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.radiusStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OwnerDirectoryDescription)) {
            return false;
        }
        OwnerDirectoryDescription other = (OwnerDirectoryDescription)obj;
        return Objects.equals(this.directoryId(), other.directoryId()) && Objects.equals(this.accountId(), other.accountId()) && this.hasDnsIpAddrs() == other.hasDnsIpAddrs() && Objects.equals(this.dnsIpAddrs(), other.dnsIpAddrs()) && Objects.equals(this.vpcSettings(), other.vpcSettings()) && Objects.equals(this.radiusSettings(), other.radiusSettings()) && Objects.equals(this.radiusStatusAsString(), other.radiusStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"OwnerDirectoryDescription").add("DirectoryId", (Object)this.directoryId()).add("AccountId", (Object)this.accountId()).add("DnsIpAddrs", this.hasDnsIpAddrs() ? this.dnsIpAddrs() : null).add("VpcSettings", (Object)this.vpcSettings()).add("RadiusSettings", (Object)this.radiusSettings()).add("RadiusStatus", (Object)this.radiusStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "DnsIpAddrs": {
                return Optional.ofNullable(clazz.cast(this.dnsIpAddrs()));
            }
            case "VpcSettings": {
                return Optional.ofNullable(clazz.cast(this.vpcSettings()));
            }
            case "RadiusSettings": {
                return Optional.ofNullable(clazz.cast(this.radiusSettings()));
            }
            case "RadiusStatus": {
                return Optional.ofNullable(clazz.cast(this.radiusStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OwnerDirectoryDescription, T> g) {
        return obj -> g.apply((OwnerDirectoryDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String directoryId;
        private String accountId;
        private List<String> dnsIpAddrs = DefaultSdkAutoConstructList.getInstance();
        private DirectoryVpcSettingsDescription vpcSettings;
        private RadiusSettings radiusSettings;
        private String radiusStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(OwnerDirectoryDescription model) {
            this.directoryId(model.directoryId);
            this.accountId(model.accountId);
            this.dnsIpAddrs(model.dnsIpAddrs);
            this.vpcSettings(model.vpcSettings);
            this.radiusSettings(model.radiusSettings);
            this.radiusStatus(model.radiusStatus);
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final Collection<String> getDnsIpAddrs() {
            if (this.dnsIpAddrs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dnsIpAddrs;
        }

        @Override
        public final Builder dnsIpAddrs(Collection<String> dnsIpAddrs) {
            this.dnsIpAddrs = DnsIpAddrsCopier.copy(dnsIpAddrs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnsIpAddrs(String ... dnsIpAddrs) {
            this.dnsIpAddrs(Arrays.asList(dnsIpAddrs));
            return this;
        }

        public final void setDnsIpAddrs(Collection<String> dnsIpAddrs) {
            this.dnsIpAddrs = DnsIpAddrsCopier.copy(dnsIpAddrs);
        }

        public final DirectoryVpcSettingsDescription.Builder getVpcSettings() {
            return this.vpcSettings != null ? this.vpcSettings.toBuilder() : null;
        }

        @Override
        public final Builder vpcSettings(DirectoryVpcSettingsDescription vpcSettings) {
            this.vpcSettings = vpcSettings;
            return this;
        }

        public final void setVpcSettings(DirectoryVpcSettingsDescription.BuilderImpl vpcSettings) {
            this.vpcSettings = vpcSettings != null ? vpcSettings.build() : null;
        }

        public final RadiusSettings.Builder getRadiusSettings() {
            return this.radiusSettings != null ? this.radiusSettings.toBuilder() : null;
        }

        @Override
        public final Builder radiusSettings(RadiusSettings radiusSettings) {
            this.radiusSettings = radiusSettings;
            return this;
        }

        public final void setRadiusSettings(RadiusSettings.BuilderImpl radiusSettings) {
            this.radiusSettings = radiusSettings != null ? radiusSettings.build() : null;
        }

        public final String getRadiusStatus() {
            return this.radiusStatus;
        }

        @Override
        public final Builder radiusStatus(String radiusStatus) {
            this.radiusStatus = radiusStatus;
            return this;
        }

        @Override
        public final Builder radiusStatus(RadiusStatus radiusStatus) {
            this.radiusStatus(radiusStatus == null ? null : radiusStatus.toString());
            return this;
        }

        public final void setRadiusStatus(String radiusStatus) {
            this.radiusStatus = radiusStatus;
        }

        public OwnerDirectoryDescription build() {
            return new OwnerDirectoryDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OwnerDirectoryDescription> {
        public Builder directoryId(String var1);

        public Builder accountId(String var1);

        public Builder dnsIpAddrs(Collection<String> var1);

        public Builder dnsIpAddrs(String ... var1);

        public Builder vpcSettings(DirectoryVpcSettingsDescription var1);

        default public Builder vpcSettings(Consumer<DirectoryVpcSettingsDescription.Builder> vpcSettings) {
            return this.vpcSettings((DirectoryVpcSettingsDescription)((DirectoryVpcSettingsDescription.Builder)DirectoryVpcSettingsDescription.builder().applyMutation(vpcSettings)).build());
        }

        public Builder radiusSettings(RadiusSettings var1);

        default public Builder radiusSettings(Consumer<RadiusSettings.Builder> radiusSettings) {
            return this.radiusSettings((RadiusSettings)((RadiusSettings.Builder)RadiusSettings.builder().applyMutation(radiusSettings)).build());
        }

        public Builder radiusStatus(String var1);

        public Builder radiusStatus(RadiusStatus var1);
    }
}

