/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum RadiusAuthenticationProtocol {
    PAP("PAP"),
    CHAP("CHAP"),
    MS_CHAP_V1("MS-CHAPv1"),
    MS_CHAP_V2("MS-CHAPv2"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private RadiusAuthenticationProtocol(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RadiusAuthenticationProtocol fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(RadiusAuthenticationProtocol.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RadiusAuthenticationProtocol> knownValues() {
        return Stream.of(RadiusAuthenticationProtocol.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

