/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListIpRoutesResponse extends DirectoryResponse implements
        ToCopyableBuilder<ListIpRoutesResponse.Builder, ListIpRoutesResponse> {
    private static final SdkField<List<IpRouteInfo>> IP_ROUTES_INFO_FIELD = SdkField
            .<List<IpRouteInfo>> builder(MarshallingType.LIST)
            .memberName("IpRoutesInfo")
            .getter(getter(ListIpRoutesResponse::ipRoutesInfo))
            .setter(setter(Builder::ipRoutesInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpRoutesInfo").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IpRouteInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(IpRouteInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListIpRoutesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_ROUTES_INFO_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<IpRouteInfo> ipRoutesInfo;

    private final String nextToken;

    private ListIpRoutesResponse(BuilderImpl builder) {
        super(builder);
        this.ipRoutesInfo = builder.ipRoutesInfo;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the IpRoutesInfo property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasIpRoutesInfo() {
        return ipRoutesInfo != null && !(ipRoutesInfo instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <a>IpRoute</a>s.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIpRoutesInfo()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of <a>IpRoute</a>s.
     */
    public final List<IpRouteInfo> ipRoutesInfo() {
        return ipRoutesInfo;
    }

    /**
     * <p>
     * If not null, more results are available. Pass this value for the <i>NextToken</i> parameter in a subsequent call
     * to <a>ListIpRoutes</a> to retrieve the next set of items.
     * </p>
     * 
     * @return If not null, more results are available. Pass this value for the <i>NextToken</i> parameter in a
     *         subsequent call to <a>ListIpRoutes</a> to retrieve the next set of items.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasIpRoutesInfo() ? ipRoutesInfo() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIpRoutesResponse)) {
            return false;
        }
        ListIpRoutesResponse other = (ListIpRoutesResponse) obj;
        return hasIpRoutesInfo() == other.hasIpRoutesInfo() && Objects.equals(ipRoutesInfo(), other.ipRoutesInfo())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListIpRoutesResponse").add("IpRoutesInfo", hasIpRoutesInfo() ? ipRoutesInfo() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IpRoutesInfo":
            return Optional.ofNullable(clazz.cast(ipRoutesInfo()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListIpRoutesResponse, T> g) {
        return obj -> g.apply((ListIpRoutesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectoryResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListIpRoutesResponse> {
        /**
         * <p>
         * A list of <a>IpRoute</a>s.
         * </p>
         * 
         * @param ipRoutesInfo
         *        A list of <a>IpRoute</a>s.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipRoutesInfo(Collection<IpRouteInfo> ipRoutesInfo);

        /**
         * <p>
         * A list of <a>IpRoute</a>s.
         * </p>
         * 
         * @param ipRoutesInfo
         *        A list of <a>IpRoute</a>s.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipRoutesInfo(IpRouteInfo... ipRoutesInfo);

        /**
         * <p>
         * A list of <a>IpRoute</a>s.
         * </p>
         * This is a convenience that creates an instance of the {@link List<IpRouteInfo>.Builder} avoiding the need to
         * create one manually via {@link List<IpRouteInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IpRouteInfo>.Builder#build()} is called immediately and its
         * result is passed to {@link #ipRoutesInfo(List<IpRouteInfo>)}.
         * 
         * @param ipRoutesInfo
         *        a consumer that will call methods on {@link List<IpRouteInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipRoutesInfo(List<IpRouteInfo>)
         */
        Builder ipRoutesInfo(Consumer<IpRouteInfo.Builder>... ipRoutesInfo);

        /**
         * <p>
         * If not null, more results are available. Pass this value for the <i>NextToken</i> parameter in a subsequent
         * call to <a>ListIpRoutes</a> to retrieve the next set of items.
         * </p>
         * 
         * @param nextToken
         *        If not null, more results are available. Pass this value for the <i>NextToken</i> parameter in a
         *        subsequent call to <a>ListIpRoutes</a> to retrieve the next set of items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DirectoryResponse.BuilderImpl implements Builder {
        private List<IpRouteInfo> ipRoutesInfo = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIpRoutesResponse model) {
            super(model);
            ipRoutesInfo(model.ipRoutesInfo);
            nextToken(model.nextToken);
        }

        public final List<IpRouteInfo.Builder> getIpRoutesInfo() {
            List<IpRouteInfo.Builder> result = IpRoutesInfoCopier.copyToBuilder(this.ipRoutesInfo);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder ipRoutesInfo(Collection<IpRouteInfo> ipRoutesInfo) {
            this.ipRoutesInfo = IpRoutesInfoCopier.copy(ipRoutesInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipRoutesInfo(IpRouteInfo... ipRoutesInfo) {
            ipRoutesInfo(Arrays.asList(ipRoutesInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipRoutesInfo(Consumer<IpRouteInfo.Builder>... ipRoutesInfo) {
            ipRoutesInfo(Stream.of(ipRoutesInfo).map(c -> IpRouteInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setIpRoutesInfo(Collection<IpRouteInfo.BuilderImpl> ipRoutesInfo) {
            this.ipRoutesInfo = IpRoutesInfoCopier.copyFromBuilder(ipRoutesInfo);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListIpRoutesResponse build() {
            return new ListIpRoutesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
