/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of a DescribeConditionalForwarder request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeConditionalForwardersResponse extends DirectoryResponse implements
        ToCopyableBuilder<DescribeConditionalForwardersResponse.Builder, DescribeConditionalForwardersResponse> {
    private static final SdkField<List<ConditionalForwarder>> CONDITIONAL_FORWARDERS_FIELD = SdkField
            .<List<ConditionalForwarder>> builder(MarshallingType.LIST)
            .memberName("ConditionalForwarders")
            .getter(getter(DescribeConditionalForwardersResponse::conditionalForwarders))
            .setter(setter(Builder::conditionalForwarders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConditionalForwarders").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConditionalForwarder> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConditionalForwarder::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONDITIONAL_FORWARDERS_FIELD));

    private final List<ConditionalForwarder> conditionalForwarders;

    private DescribeConditionalForwardersResponse(BuilderImpl builder) {
        super(builder);
        this.conditionalForwarders = builder.conditionalForwarders;
    }

    /**
     * Returns true if the ConditionalForwarders property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasConditionalForwarders() {
        return conditionalForwarders != null && !(conditionalForwarders instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of conditional forwarders that have been created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasConditionalForwarders()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of conditional forwarders that have been created.
     */
    public final List<ConditionalForwarder> conditionalForwarders() {
        return conditionalForwarders;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasConditionalForwarders() ? conditionalForwarders() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConditionalForwardersResponse)) {
            return false;
        }
        DescribeConditionalForwardersResponse other = (DescribeConditionalForwardersResponse) obj;
        return hasConditionalForwarders() == other.hasConditionalForwarders()
                && Objects.equals(conditionalForwarders(), other.conditionalForwarders());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeConditionalForwardersResponse")
                .add("ConditionalForwarders", hasConditionalForwarders() ? conditionalForwarders() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConditionalForwarders":
            return Optional.ofNullable(clazz.cast(conditionalForwarders()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConditionalForwardersResponse, T> g) {
        return obj -> g.apply((DescribeConditionalForwardersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectoryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeConditionalForwardersResponse> {
        /**
         * <p>
         * The list of conditional forwarders that have been created.
         * </p>
         * 
         * @param conditionalForwarders
         *        The list of conditional forwarders that have been created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditionalForwarders(Collection<ConditionalForwarder> conditionalForwarders);

        /**
         * <p>
         * The list of conditional forwarders that have been created.
         * </p>
         * 
         * @param conditionalForwarders
         *        The list of conditional forwarders that have been created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditionalForwarders(ConditionalForwarder... conditionalForwarders);

        /**
         * <p>
         * The list of conditional forwarders that have been created.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ConditionalForwarder>.Builder} avoiding the
         * need to create one manually via {@link List<ConditionalForwarder>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ConditionalForwarder>.Builder#build()} is called immediately
         * and its result is passed to {@link #conditionalForwarders(List<ConditionalForwarder>)}.
         * 
         * @param conditionalForwarders
         *        a consumer that will call methods on {@link List<ConditionalForwarder>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conditionalForwarders(List<ConditionalForwarder>)
         */
        Builder conditionalForwarders(Consumer<ConditionalForwarder.Builder>... conditionalForwarders);
    }

    static final class BuilderImpl extends DirectoryResponse.BuilderImpl implements Builder {
        private List<ConditionalForwarder> conditionalForwarders = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConditionalForwardersResponse model) {
            super(model);
            conditionalForwarders(model.conditionalForwarders);
        }

        public final List<ConditionalForwarder.Builder> getConditionalForwarders() {
            List<ConditionalForwarder.Builder> result = ConditionalForwardersCopier.copyToBuilder(this.conditionalForwarders);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder conditionalForwarders(Collection<ConditionalForwarder> conditionalForwarders) {
            this.conditionalForwarders = ConditionalForwardersCopier.copy(conditionalForwarders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditionalForwarders(ConditionalForwarder... conditionalForwarders) {
            conditionalForwarders(Arrays.asList(conditionalForwarders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditionalForwarders(Consumer<ConditionalForwarder.Builder>... conditionalForwarders) {
            conditionalForwarders(Stream.of(conditionalForwarders)
                    .map(c -> ConditionalForwarder.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConditionalForwarders(Collection<ConditionalForwarder.BuilderImpl> conditionalForwarders) {
            this.conditionalForwarders = ConditionalForwardersCopier.copyFromBuilder(conditionalForwarders);
        }

        @Override
        public DescribeConditionalForwardersResponse build() {
            return new DescribeConditionalForwardersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
