/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directory.model.DirectoryRequest;
import software.amazon.awssdk.services.directory.model.DnsIpAddrsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateConditionalForwarderRequest
extends DirectoryRequest
implements ToCopyableBuilder<Builder, CreateConditionalForwarderRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryId").getter(CreateConditionalForwarderRequest.getter(CreateConditionalForwarderRequest::directoryId)).setter(CreateConditionalForwarderRequest.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()}).build();
    private static final SdkField<String> REMOTE_DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RemoteDomainName").getter(CreateConditionalForwarderRequest.getter(CreateConditionalForwarderRequest::remoteDomainName)).setter(CreateConditionalForwarderRequest.setter(Builder::remoteDomainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoteDomainName").build()}).build();
    private static final SdkField<List<String>> DNS_IP_ADDRS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DnsIpAddrs").getter(CreateConditionalForwarderRequest.getter(CreateConditionalForwarderRequest::dnsIpAddrs)).setter(CreateConditionalForwarderRequest.setter(Builder::dnsIpAddrs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsIpAddrs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD, REMOTE_DOMAIN_NAME_FIELD, DNS_IP_ADDRS_FIELD));
    private final String directoryId;
    private final String remoteDomainName;
    private final List<String> dnsIpAddrs;

    private CreateConditionalForwarderRequest(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.remoteDomainName = builder.remoteDomainName;
        this.dnsIpAddrs = builder.dnsIpAddrs;
    }

    public final String directoryId() {
        return this.directoryId;
    }

    public final String remoteDomainName() {
        return this.remoteDomainName;
    }

    public final boolean hasDnsIpAddrs() {
        return this.dnsIpAddrs != null && !(this.dnsIpAddrs instanceof SdkAutoConstructList);
    }

    public final List<String> dnsIpAddrs() {
        return this.dnsIpAddrs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteDomainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDnsIpAddrs() ? this.dnsIpAddrs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConditionalForwarderRequest)) {
            return false;
        }
        CreateConditionalForwarderRequest other = (CreateConditionalForwarderRequest)((Object)obj);
        return Objects.equals(this.directoryId(), other.directoryId()) && Objects.equals(this.remoteDomainName(), other.remoteDomainName()) && this.hasDnsIpAddrs() == other.hasDnsIpAddrs() && Objects.equals(this.dnsIpAddrs(), other.dnsIpAddrs());
    }

    public final String toString() {
        return ToString.builder((String)"CreateConditionalForwarderRequest").add("DirectoryId", (Object)this.directoryId()).add("RemoteDomainName", (Object)this.remoteDomainName()).add("DnsIpAddrs", this.hasDnsIpAddrs() ? this.dnsIpAddrs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "RemoteDomainName": {
                return Optional.ofNullable(clazz.cast(this.remoteDomainName()));
            }
            case "DnsIpAddrs": {
                return Optional.ofNullable(clazz.cast(this.dnsIpAddrs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateConditionalForwarderRequest, T> g) {
        return obj -> g.apply((CreateConditionalForwarderRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectoryRequest.BuilderImpl
    implements Builder {
        private String directoryId;
        private String remoteDomainName;
        private List<String> dnsIpAddrs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConditionalForwarderRequest model) {
            super(model);
            this.directoryId(model.directoryId);
            this.remoteDomainName(model.remoteDomainName);
            this.dnsIpAddrs(model.dnsIpAddrs);
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        @Transient
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getRemoteDomainName() {
            return this.remoteDomainName;
        }

        public final void setRemoteDomainName(String remoteDomainName) {
            this.remoteDomainName = remoteDomainName;
        }

        @Override
        @Transient
        public final Builder remoteDomainName(String remoteDomainName) {
            this.remoteDomainName = remoteDomainName;
            return this;
        }

        public final Collection<String> getDnsIpAddrs() {
            if (this.dnsIpAddrs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dnsIpAddrs;
        }

        public final void setDnsIpAddrs(Collection<String> dnsIpAddrs) {
            this.dnsIpAddrs = DnsIpAddrsCopier.copy(dnsIpAddrs);
        }

        @Override
        @Transient
        public final Builder dnsIpAddrs(Collection<String> dnsIpAddrs) {
            this.dnsIpAddrs = DnsIpAddrsCopier.copy(dnsIpAddrs);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dnsIpAddrs(String ... dnsIpAddrs) {
            this.dnsIpAddrs(Arrays.asList(dnsIpAddrs));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConditionalForwarderRequest build() {
            return new CreateConditionalForwarderRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DirectoryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateConditionalForwarderRequest> {
        public Builder directoryId(String var1);

        public Builder remoteDomainName(String var1);

        public Builder dnsIpAddrs(Collection<String> var1);

        public Builder dnsIpAddrs(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

