/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterCertificateRequest extends DirectoryRequest implements
        ToCopyableBuilder<RegisterCertificateRequest.Builder, RegisterCertificateRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(RegisterCertificateRequest::directoryId))
            .setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<String> CERTIFICATE_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CertificateData").getter(getter(RegisterCertificateRequest::certificateData))
            .setter(setter(Builder::certificateData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateData").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(RegisterCertificateRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<ClientCertAuthSettings> CLIENT_CERT_AUTH_SETTINGS_FIELD = SdkField
            .<ClientCertAuthSettings> builder(MarshallingType.SDK_POJO).memberName("ClientCertAuthSettings")
            .getter(getter(RegisterCertificateRequest::clientCertAuthSettings)).setter(setter(Builder::clientCertAuthSettings))
            .constructor(ClientCertAuthSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientCertAuthSettings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD,
            CERTIFICATE_DATA_FIELD, TYPE_FIELD, CLIENT_CERT_AUTH_SETTINGS_FIELD));

    private final String directoryId;

    private final String certificateData;

    private final String type;

    private final ClientCertAuthSettings clientCertAuthSettings;

    private RegisterCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.certificateData = builder.certificateData;
        this.type = builder.type;
        this.clientCertAuthSettings = builder.clientCertAuthSettings;
    }

    /**
     * <p>
     * The identifier of the directory.
     * </p>
     * 
     * @return The identifier of the directory.
     */
    public final String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * The certificate PEM string that needs to be registered.
     * </p>
     * 
     * @return The certificate PEM string that needs to be registered.
     */
    public final String certificateData() {
        return certificateData;
    }

    /**
     * <p>
     * The function that the registered certificate performs. Valid values include <code>ClientLDAPS</code> or
     * <code>ClientCertAuth</code>. The default value is <code>ClientLDAPS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CertificateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The function that the registered certificate performs. Valid values include <code>ClientLDAPS</code> or
     *         <code>ClientCertAuth</code>. The default value is <code>ClientLDAPS</code>.
     * @see CertificateType
     */
    public final CertificateType type() {
        return CertificateType.fromValue(type);
    }

    /**
     * <p>
     * The function that the registered certificate performs. Valid values include <code>ClientLDAPS</code> or
     * <code>ClientCertAuth</code>. The default value is <code>ClientLDAPS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CertificateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The function that the registered certificate performs. Valid values include <code>ClientLDAPS</code> or
     *         <code>ClientCertAuth</code>. The default value is <code>ClientLDAPS</code>.
     * @see CertificateType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * A <code>ClientCertAuthSettings</code> object that contains client certificate authentication settings.
     * </p>
     * 
     * @return A <code>ClientCertAuthSettings</code> object that contains client certificate authentication settings.
     */
    public final ClientCertAuthSettings clientCertAuthSettings() {
        return clientCertAuthSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(certificateData());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clientCertAuthSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterCertificateRequest)) {
            return false;
        }
        RegisterCertificateRequest other = (RegisterCertificateRequest) obj;
        return Objects.equals(directoryId(), other.directoryId()) && Objects.equals(certificateData(), other.certificateData())
                && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(clientCertAuthSettings(), other.clientCertAuthSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterCertificateRequest").add("DirectoryId", directoryId())
                .add("CertificateData", certificateData()).add("Type", typeAsString())
                .add("ClientCertAuthSettings", clientCertAuthSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "CertificateData":
            return Optional.ofNullable(clazz.cast(certificateData()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "ClientCertAuthSettings":
            return Optional.ofNullable(clazz.cast(clientCertAuthSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterCertificateRequest, T> g) {
        return obj -> g.apply((RegisterCertificateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectoryRequest.Builder, SdkPojo, CopyableBuilder<Builder, RegisterCertificateRequest> {
        /**
         * <p>
         * The identifier of the directory.
         * </p>
         * 
         * @param directoryId
         *        The identifier of the directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * The certificate PEM string that needs to be registered.
         * </p>
         * 
         * @param certificateData
         *        The certificate PEM string that needs to be registered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateData(String certificateData);

        /**
         * <p>
         * The function that the registered certificate performs. Valid values include <code>ClientLDAPS</code> or
         * <code>ClientCertAuth</code>. The default value is <code>ClientLDAPS</code>.
         * </p>
         * 
         * @param type
         *        The function that the registered certificate performs. Valid values include <code>ClientLDAPS</code>
         *        or <code>ClientCertAuth</code>. The default value is <code>ClientLDAPS</code>.
         * @see CertificateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateType
         */
        Builder type(String type);

        /**
         * <p>
         * The function that the registered certificate performs. Valid values include <code>ClientLDAPS</code> or
         * <code>ClientCertAuth</code>. The default value is <code>ClientLDAPS</code>.
         * </p>
         * 
         * @param type
         *        The function that the registered certificate performs. Valid values include <code>ClientLDAPS</code>
         *        or <code>ClientCertAuth</code>. The default value is <code>ClientLDAPS</code>.
         * @see CertificateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateType
         */
        Builder type(CertificateType type);

        /**
         * <p>
         * A <code>ClientCertAuthSettings</code> object that contains client certificate authentication settings.
         * </p>
         * 
         * @param clientCertAuthSettings
         *        A <code>ClientCertAuthSettings</code> object that contains client certificate authentication settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientCertAuthSettings(ClientCertAuthSettings clientCertAuthSettings);

        /**
         * <p>
         * A <code>ClientCertAuthSettings</code> object that contains client certificate authentication settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClientCertAuthSettings.Builder} avoiding
         * the need to create one manually via {@link ClientCertAuthSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link ClientCertAuthSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #clientCertAuthSettings(ClientCertAuthSettings)}.
         * 
         * @param clientCertAuthSettings
         *        a consumer that will call methods on {@link ClientCertAuthSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clientCertAuthSettings(ClientCertAuthSettings)
         */
        default Builder clientCertAuthSettings(Consumer<ClientCertAuthSettings.Builder> clientCertAuthSettings) {
            return clientCertAuthSettings(ClientCertAuthSettings.builder().applyMutation(clientCertAuthSettings).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectoryRequest.BuilderImpl implements Builder {
        private String directoryId;

        private String certificateData;

        private String type;

        private ClientCertAuthSettings clientCertAuthSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterCertificateRequest model) {
            super(model);
            directoryId(model.directoryId);
            certificateData(model.certificateData);
            type(model.type);
            clientCertAuthSettings(model.clientCertAuthSettings);
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getCertificateData() {
            return certificateData;
        }

        public final void setCertificateData(String certificateData) {
            this.certificateData = certificateData;
        }

        @Override
        public final Builder certificateData(String certificateData) {
            this.certificateData = certificateData;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CertificateType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final ClientCertAuthSettings.Builder getClientCertAuthSettings() {
            return clientCertAuthSettings != null ? clientCertAuthSettings.toBuilder() : null;
        }

        public final void setClientCertAuthSettings(ClientCertAuthSettings.BuilderImpl clientCertAuthSettings) {
            this.clientCertAuthSettings = clientCertAuthSettings != null ? clientCertAuthSettings.build() : null;
        }

        @Override
        public final Builder clientCertAuthSettings(ClientCertAuthSettings clientCertAuthSettings) {
            this.clientCertAuthSettings = clientCertAuthSettings;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterCertificateRequest build() {
            return new RegisterCertificateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
