/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.directory.DirectoryClient;
import software.amazon.awssdk.services.directory.model.AcceptSharedDirectoryRequest;
import software.amazon.awssdk.services.directory.model.AcceptSharedDirectoryResponse;
import software.amazon.awssdk.services.directory.model.AccessDeniedException;
import software.amazon.awssdk.services.directory.model.AddIpRoutesRequest;
import software.amazon.awssdk.services.directory.model.AddIpRoutesResponse;
import software.amazon.awssdk.services.directory.model.AddRegionRequest;
import software.amazon.awssdk.services.directory.model.AddRegionResponse;
import software.amazon.awssdk.services.directory.model.AddTagsToResourceRequest;
import software.amazon.awssdk.services.directory.model.AddTagsToResourceResponse;
import software.amazon.awssdk.services.directory.model.AuthenticationFailedException;
import software.amazon.awssdk.services.directory.model.CancelSchemaExtensionRequest;
import software.amazon.awssdk.services.directory.model.CancelSchemaExtensionResponse;
import software.amazon.awssdk.services.directory.model.CertificateAlreadyExistsException;
import software.amazon.awssdk.services.directory.model.CertificateDoesNotExistException;
import software.amazon.awssdk.services.directory.model.CertificateInUseException;
import software.amazon.awssdk.services.directory.model.CertificateLimitExceededException;
import software.amazon.awssdk.services.directory.model.ClientException;
import software.amazon.awssdk.services.directory.model.ConnectDirectoryRequest;
import software.amazon.awssdk.services.directory.model.ConnectDirectoryResponse;
import software.amazon.awssdk.services.directory.model.CreateAliasRequest;
import software.amazon.awssdk.services.directory.model.CreateAliasResponse;
import software.amazon.awssdk.services.directory.model.CreateComputerRequest;
import software.amazon.awssdk.services.directory.model.CreateComputerResponse;
import software.amazon.awssdk.services.directory.model.CreateConditionalForwarderRequest;
import software.amazon.awssdk.services.directory.model.CreateConditionalForwarderResponse;
import software.amazon.awssdk.services.directory.model.CreateDirectoryRequest;
import software.amazon.awssdk.services.directory.model.CreateDirectoryResponse;
import software.amazon.awssdk.services.directory.model.CreateLogSubscriptionRequest;
import software.amazon.awssdk.services.directory.model.CreateLogSubscriptionResponse;
import software.amazon.awssdk.services.directory.model.CreateMicrosoftAdRequest;
import software.amazon.awssdk.services.directory.model.CreateMicrosoftAdResponse;
import software.amazon.awssdk.services.directory.model.CreateSnapshotRequest;
import software.amazon.awssdk.services.directory.model.CreateSnapshotResponse;
import software.amazon.awssdk.services.directory.model.CreateTrustRequest;
import software.amazon.awssdk.services.directory.model.CreateTrustResponse;
import software.amazon.awssdk.services.directory.model.DeleteConditionalForwarderRequest;
import software.amazon.awssdk.services.directory.model.DeleteConditionalForwarderResponse;
import software.amazon.awssdk.services.directory.model.DeleteDirectoryRequest;
import software.amazon.awssdk.services.directory.model.DeleteDirectoryResponse;
import software.amazon.awssdk.services.directory.model.DeleteLogSubscriptionRequest;
import software.amazon.awssdk.services.directory.model.DeleteLogSubscriptionResponse;
import software.amazon.awssdk.services.directory.model.DeleteSnapshotRequest;
import software.amazon.awssdk.services.directory.model.DeleteSnapshotResponse;
import software.amazon.awssdk.services.directory.model.DeleteTrustRequest;
import software.amazon.awssdk.services.directory.model.DeleteTrustResponse;
import software.amazon.awssdk.services.directory.model.DeregisterCertificateRequest;
import software.amazon.awssdk.services.directory.model.DeregisterCertificateResponse;
import software.amazon.awssdk.services.directory.model.DeregisterEventTopicRequest;
import software.amazon.awssdk.services.directory.model.DeregisterEventTopicResponse;
import software.amazon.awssdk.services.directory.model.DescribeCertificateRequest;
import software.amazon.awssdk.services.directory.model.DescribeCertificateResponse;
import software.amazon.awssdk.services.directory.model.DescribeClientAuthenticationSettingsRequest;
import software.amazon.awssdk.services.directory.model.DescribeClientAuthenticationSettingsResponse;
import software.amazon.awssdk.services.directory.model.DescribeConditionalForwardersRequest;
import software.amazon.awssdk.services.directory.model.DescribeConditionalForwardersResponse;
import software.amazon.awssdk.services.directory.model.DescribeDirectoriesRequest;
import software.amazon.awssdk.services.directory.model.DescribeDirectoriesResponse;
import software.amazon.awssdk.services.directory.model.DescribeDomainControllersRequest;
import software.amazon.awssdk.services.directory.model.DescribeDomainControllersResponse;
import software.amazon.awssdk.services.directory.model.DescribeEventTopicsRequest;
import software.amazon.awssdk.services.directory.model.DescribeEventTopicsResponse;
import software.amazon.awssdk.services.directory.model.DescribeLdapsSettingsRequest;
import software.amazon.awssdk.services.directory.model.DescribeLdapsSettingsResponse;
import software.amazon.awssdk.services.directory.model.DescribeRegionsRequest;
import software.amazon.awssdk.services.directory.model.DescribeRegionsResponse;
import software.amazon.awssdk.services.directory.model.DescribeSharedDirectoriesRequest;
import software.amazon.awssdk.services.directory.model.DescribeSharedDirectoriesResponse;
import software.amazon.awssdk.services.directory.model.DescribeSnapshotsRequest;
import software.amazon.awssdk.services.directory.model.DescribeSnapshotsResponse;
import software.amazon.awssdk.services.directory.model.DescribeTrustsRequest;
import software.amazon.awssdk.services.directory.model.DescribeTrustsResponse;
import software.amazon.awssdk.services.directory.model.DirectoryAlreadyInRegionException;
import software.amazon.awssdk.services.directory.model.DirectoryAlreadySharedException;
import software.amazon.awssdk.services.directory.model.DirectoryDoesNotExistException;
import software.amazon.awssdk.services.directory.model.DirectoryException;
import software.amazon.awssdk.services.directory.model.DirectoryLimitExceededException;
import software.amazon.awssdk.services.directory.model.DirectoryNotSharedException;
import software.amazon.awssdk.services.directory.model.DirectoryRequest;
import software.amazon.awssdk.services.directory.model.DirectoryUnavailableException;
import software.amazon.awssdk.services.directory.model.DisableClientAuthenticationRequest;
import software.amazon.awssdk.services.directory.model.DisableClientAuthenticationResponse;
import software.amazon.awssdk.services.directory.model.DisableLdapsRequest;
import software.amazon.awssdk.services.directory.model.DisableLdapsResponse;
import software.amazon.awssdk.services.directory.model.DisableRadiusRequest;
import software.amazon.awssdk.services.directory.model.DisableRadiusResponse;
import software.amazon.awssdk.services.directory.model.DisableSsoRequest;
import software.amazon.awssdk.services.directory.model.DisableSsoResponse;
import software.amazon.awssdk.services.directory.model.DomainControllerLimitExceededException;
import software.amazon.awssdk.services.directory.model.EnableClientAuthenticationRequest;
import software.amazon.awssdk.services.directory.model.EnableClientAuthenticationResponse;
import software.amazon.awssdk.services.directory.model.EnableLdapsRequest;
import software.amazon.awssdk.services.directory.model.EnableLdapsResponse;
import software.amazon.awssdk.services.directory.model.EnableRadiusRequest;
import software.amazon.awssdk.services.directory.model.EnableRadiusResponse;
import software.amazon.awssdk.services.directory.model.EnableSsoRequest;
import software.amazon.awssdk.services.directory.model.EnableSsoResponse;
import software.amazon.awssdk.services.directory.model.EntityAlreadyExistsException;
import software.amazon.awssdk.services.directory.model.EntityDoesNotExistException;
import software.amazon.awssdk.services.directory.model.GetDirectoryLimitsRequest;
import software.amazon.awssdk.services.directory.model.GetDirectoryLimitsResponse;
import software.amazon.awssdk.services.directory.model.GetSnapshotLimitsRequest;
import software.amazon.awssdk.services.directory.model.GetSnapshotLimitsResponse;
import software.amazon.awssdk.services.directory.model.InsufficientPermissionsException;
import software.amazon.awssdk.services.directory.model.InvalidCertificateException;
import software.amazon.awssdk.services.directory.model.InvalidClientAuthStatusException;
import software.amazon.awssdk.services.directory.model.InvalidLdapsStatusException;
import software.amazon.awssdk.services.directory.model.InvalidNextTokenException;
import software.amazon.awssdk.services.directory.model.InvalidParameterException;
import software.amazon.awssdk.services.directory.model.InvalidPasswordException;
import software.amazon.awssdk.services.directory.model.InvalidTargetException;
import software.amazon.awssdk.services.directory.model.IpRouteLimitExceededException;
import software.amazon.awssdk.services.directory.model.ListCertificatesRequest;
import software.amazon.awssdk.services.directory.model.ListCertificatesResponse;
import software.amazon.awssdk.services.directory.model.ListIpRoutesRequest;
import software.amazon.awssdk.services.directory.model.ListIpRoutesResponse;
import software.amazon.awssdk.services.directory.model.ListLogSubscriptionsRequest;
import software.amazon.awssdk.services.directory.model.ListLogSubscriptionsResponse;
import software.amazon.awssdk.services.directory.model.ListSchemaExtensionsRequest;
import software.amazon.awssdk.services.directory.model.ListSchemaExtensionsResponse;
import software.amazon.awssdk.services.directory.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.directory.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.directory.model.NoAvailableCertificateException;
import software.amazon.awssdk.services.directory.model.OrganizationsException;
import software.amazon.awssdk.services.directory.model.RegionLimitExceededException;
import software.amazon.awssdk.services.directory.model.RegisterCertificateRequest;
import software.amazon.awssdk.services.directory.model.RegisterCertificateResponse;
import software.amazon.awssdk.services.directory.model.RegisterEventTopicRequest;
import software.amazon.awssdk.services.directory.model.RegisterEventTopicResponse;
import software.amazon.awssdk.services.directory.model.RejectSharedDirectoryRequest;
import software.amazon.awssdk.services.directory.model.RejectSharedDirectoryResponse;
import software.amazon.awssdk.services.directory.model.RemoveIpRoutesRequest;
import software.amazon.awssdk.services.directory.model.RemoveIpRoutesResponse;
import software.amazon.awssdk.services.directory.model.RemoveRegionRequest;
import software.amazon.awssdk.services.directory.model.RemoveRegionResponse;
import software.amazon.awssdk.services.directory.model.RemoveTagsFromResourceRequest;
import software.amazon.awssdk.services.directory.model.RemoveTagsFromResourceResponse;
import software.amazon.awssdk.services.directory.model.ResetUserPasswordRequest;
import software.amazon.awssdk.services.directory.model.ResetUserPasswordResponse;
import software.amazon.awssdk.services.directory.model.RestoreFromSnapshotRequest;
import software.amazon.awssdk.services.directory.model.RestoreFromSnapshotResponse;
import software.amazon.awssdk.services.directory.model.ServiceException;
import software.amazon.awssdk.services.directory.model.ShareDirectoryRequest;
import software.amazon.awssdk.services.directory.model.ShareDirectoryResponse;
import software.amazon.awssdk.services.directory.model.ShareLimitExceededException;
import software.amazon.awssdk.services.directory.model.SnapshotLimitExceededException;
import software.amazon.awssdk.services.directory.model.StartSchemaExtensionRequest;
import software.amazon.awssdk.services.directory.model.StartSchemaExtensionResponse;
import software.amazon.awssdk.services.directory.model.TagLimitExceededException;
import software.amazon.awssdk.services.directory.model.UnshareDirectoryRequest;
import software.amazon.awssdk.services.directory.model.UnshareDirectoryResponse;
import software.amazon.awssdk.services.directory.model.UnsupportedOperationException;
import software.amazon.awssdk.services.directory.model.UpdateConditionalForwarderRequest;
import software.amazon.awssdk.services.directory.model.UpdateConditionalForwarderResponse;
import software.amazon.awssdk.services.directory.model.UpdateNumberOfDomainControllersRequest;
import software.amazon.awssdk.services.directory.model.UpdateNumberOfDomainControllersResponse;
import software.amazon.awssdk.services.directory.model.UpdateRadiusRequest;
import software.amazon.awssdk.services.directory.model.UpdateRadiusResponse;
import software.amazon.awssdk.services.directory.model.UpdateTrustRequest;
import software.amazon.awssdk.services.directory.model.UpdateTrustResponse;
import software.amazon.awssdk.services.directory.model.UserDoesNotExistException;
import software.amazon.awssdk.services.directory.model.VerifyTrustRequest;
import software.amazon.awssdk.services.directory.model.VerifyTrustResponse;
import software.amazon.awssdk.services.directory.paginators.DescribeDomainControllersIterable;
import software.amazon.awssdk.services.directory.transform.AcceptSharedDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.AddIpRoutesRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.AddRegionRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.AddTagsToResourceRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CancelSchemaExtensionRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ConnectDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateAliasRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateComputerRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateConditionalForwarderRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateLogSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateMicrosoftAdRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateSnapshotRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateTrustRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DeleteConditionalForwarderRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DeleteDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DeleteLogSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DeleteSnapshotRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DeleteTrustRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DeregisterCertificateRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DeregisterEventTopicRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeCertificateRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeClientAuthenticationSettingsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeConditionalForwardersRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeDirectoriesRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeDomainControllersRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeEventTopicsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeLdapsSettingsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeRegionsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeSharedDirectoriesRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeTrustsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DisableClientAuthenticationRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DisableLdapsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DisableRadiusRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DisableSsoRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.EnableClientAuthenticationRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.EnableLdapsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.EnableRadiusRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.EnableSsoRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.GetDirectoryLimitsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.GetSnapshotLimitsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ListCertificatesRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ListIpRoutesRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ListLogSubscriptionsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ListSchemaExtensionsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.RegisterCertificateRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.RegisterEventTopicRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.RejectSharedDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.RemoveIpRoutesRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.RemoveRegionRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.RemoveTagsFromResourceRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ResetUserPasswordRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.RestoreFromSnapshotRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ShareDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.StartSchemaExtensionRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.UnshareDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.UpdateConditionalForwarderRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.UpdateNumberOfDomainControllersRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.UpdateRadiusRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.UpdateTrustRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.VerifyTrustRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultDirectoryClient
implements DirectoryClient {
    private static final Logger log = Logger.loggerFor(DefaultDirectoryClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultDirectoryClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "ds";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AcceptSharedDirectoryResponse acceptSharedDirectory(AcceptSharedDirectoryRequest acceptSharedDirectoryRequest) throws InvalidParameterException, EntityDoesNotExistException, DirectoryAlreadySharedException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AcceptSharedDirectoryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, acceptSharedDirectoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AcceptSharedDirectory");
            AcceptSharedDirectoryResponse acceptSharedDirectoryResponse = (AcceptSharedDirectoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AcceptSharedDirectory").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)acceptSharedDirectoryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AcceptSharedDirectoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return acceptSharedDirectoryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$acceptSharedDirectory$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddIpRoutesResponse addIpRoutes(AddIpRoutesRequest addIpRoutesRequest) throws EntityDoesNotExistException, EntityAlreadyExistsException, InvalidParameterException, DirectoryUnavailableException, IpRouteLimitExceededException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddIpRoutesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, addIpRoutesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddIpRoutes");
            AddIpRoutesResponse addIpRoutesResponse = (AddIpRoutesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddIpRoutes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addIpRoutesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AddIpRoutesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return addIpRoutesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$addIpRoutes$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddRegionResponse addRegion(AddRegionRequest addRegionRequest) throws DirectoryUnavailableException, InvalidParameterException, EntityDoesNotExistException, DirectoryAlreadyInRegionException, UnsupportedOperationException, DirectoryDoesNotExistException, RegionLimitExceededException, AccessDeniedException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddRegionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, addRegionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddRegion");
            AddRegionResponse addRegionResponse = (AddRegionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddRegion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addRegionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AddRegionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return addRegionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$addRegion$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddTagsToResourceResponse addTagsToResource(AddTagsToResourceRequest addTagsToResourceRequest) throws EntityDoesNotExistException, InvalidParameterException, TagLimitExceededException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddTagsToResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, addTagsToResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddTagsToResource");
            AddTagsToResourceResponse addTagsToResourceResponse = (AddTagsToResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddTagsToResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addTagsToResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AddTagsToResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return addTagsToResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$addTagsToResource$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelSchemaExtensionResponse cancelSchemaExtension(CancelSchemaExtensionRequest cancelSchemaExtensionRequest) throws EntityDoesNotExistException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelSchemaExtensionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, cancelSchemaExtensionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelSchemaExtension");
            CancelSchemaExtensionResponse cancelSchemaExtensionResponse = (CancelSchemaExtensionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelSchemaExtension").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)cancelSchemaExtensionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelSchemaExtensionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelSchemaExtensionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$cancelSchemaExtension$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectDirectoryResponse connectDirectory(ConnectDirectoryRequest connectDirectoryRequest) throws DirectoryLimitExceededException, InvalidParameterException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ConnectDirectoryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, connectDirectoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ConnectDirectory");
            ConnectDirectoryResponse connectDirectoryResponse = (ConnectDirectoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ConnectDirectory").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)connectDirectoryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ConnectDirectoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return connectDirectoryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$connectDirectory$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAliasResponse createAlias(CreateAliasRequest createAliasRequest) throws EntityAlreadyExistsException, EntityDoesNotExistException, InvalidParameterException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAliasResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, createAliasRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAlias");
            CreateAliasResponse createAliasResponse = (CreateAliasResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAlias").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createAliasRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateAliasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createAliasResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$createAlias$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateComputerResponse createComputer(CreateComputerRequest createComputerRequest) throws AuthenticationFailedException, DirectoryUnavailableException, EntityAlreadyExistsException, EntityDoesNotExistException, InvalidParameterException, UnsupportedOperationException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateComputerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, createComputerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateComputer");
            CreateComputerResponse createComputerResponse = (CreateComputerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateComputer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createComputerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateComputerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createComputerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$createComputer$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateConditionalForwarderResponse createConditionalForwarder(CreateConditionalForwarderRequest createConditionalForwarderRequest) throws EntityAlreadyExistsException, EntityDoesNotExistException, DirectoryUnavailableException, InvalidParameterException, UnsupportedOperationException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateConditionalForwarderResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, createConditionalForwarderRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateConditionalForwarder");
            CreateConditionalForwarderResponse createConditionalForwarderResponse = (CreateConditionalForwarderResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateConditionalForwarder").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createConditionalForwarderRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateConditionalForwarderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createConditionalForwarderResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$createConditionalForwarder$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDirectoryResponse createDirectory(CreateDirectoryRequest createDirectoryRequest) throws DirectoryLimitExceededException, InvalidParameterException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDirectoryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, createDirectoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDirectory");
            CreateDirectoryResponse createDirectoryResponse = (CreateDirectoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDirectory").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDirectoryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDirectoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDirectoryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$createDirectory$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateLogSubscriptionResponse createLogSubscription(CreateLogSubscriptionRequest createLogSubscriptionRequest) throws EntityAlreadyExistsException, EntityDoesNotExistException, UnsupportedOperationException, InsufficientPermissionsException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLogSubscriptionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, createLogSubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLogSubscription");
            CreateLogSubscriptionResponse createLogSubscriptionResponse = (CreateLogSubscriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLogSubscription").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createLogSubscriptionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateLogSubscriptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createLogSubscriptionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$createLogSubscription$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateMicrosoftAdResponse createMicrosoftAD(CreateMicrosoftAdRequest createMicrosoftAdRequest) throws DirectoryLimitExceededException, InvalidParameterException, ClientException, ServiceException, UnsupportedOperationException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateMicrosoftAdResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, createMicrosoftAdRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateMicrosoftAD");
            CreateMicrosoftAdResponse createMicrosoftAdResponse = (CreateMicrosoftAdResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateMicrosoftAD").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createMicrosoftAdRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateMicrosoftAdRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createMicrosoftAdResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$createMicrosoftAD$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSnapshotResponse createSnapshot(CreateSnapshotRequest createSnapshotRequest) throws EntityDoesNotExistException, InvalidParameterException, SnapshotLimitExceededException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSnapshotResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, createSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSnapshot");
            CreateSnapshotResponse createSnapshotResponse = (CreateSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSnapshot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$createSnapshot$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateTrustResponse createTrust(CreateTrustRequest createTrustRequest) throws EntityAlreadyExistsException, EntityDoesNotExistException, InvalidParameterException, ClientException, ServiceException, UnsupportedOperationException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTrustResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, createTrustRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTrust");
            CreateTrustResponse createTrustResponse = (CreateTrustResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTrust").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createTrustRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateTrustRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createTrustResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$createTrust$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteConditionalForwarderResponse deleteConditionalForwarder(DeleteConditionalForwarderRequest deleteConditionalForwarderRequest) throws EntityDoesNotExistException, DirectoryUnavailableException, InvalidParameterException, UnsupportedOperationException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteConditionalForwarderResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, deleteConditionalForwarderRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteConditionalForwarder");
            DeleteConditionalForwarderResponse deleteConditionalForwarderResponse = (DeleteConditionalForwarderResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteConditionalForwarder").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteConditionalForwarderRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteConditionalForwarderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteConditionalForwarderResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$deleteConditionalForwarder$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDirectoryResponse deleteDirectory(DeleteDirectoryRequest deleteDirectoryRequest) throws EntityDoesNotExistException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDirectoryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, deleteDirectoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDirectory");
            DeleteDirectoryResponse deleteDirectoryResponse = (DeleteDirectoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDirectory").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDirectoryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDirectoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDirectoryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$deleteDirectory$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteLogSubscriptionResponse deleteLogSubscription(DeleteLogSubscriptionRequest deleteLogSubscriptionRequest) throws EntityDoesNotExistException, UnsupportedOperationException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteLogSubscriptionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, deleteLogSubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteLogSubscription");
            DeleteLogSubscriptionResponse deleteLogSubscriptionResponse = (DeleteLogSubscriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLogSubscription").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteLogSubscriptionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteLogSubscriptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteLogSubscriptionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$deleteLogSubscription$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSnapshotResponse deleteSnapshot(DeleteSnapshotRequest deleteSnapshotRequest) throws EntityDoesNotExistException, InvalidParameterException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSnapshotResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, deleteSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSnapshot");
            DeleteSnapshotResponse deleteSnapshotResponse = (DeleteSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSnapshot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$deleteSnapshot$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTrustResponse deleteTrust(DeleteTrustRequest deleteTrustRequest) throws EntityDoesNotExistException, InvalidParameterException, ClientException, ServiceException, UnsupportedOperationException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTrustResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, deleteTrustRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTrust");
            DeleteTrustResponse deleteTrustResponse = (DeleteTrustResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTrust").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteTrustRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteTrustRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteTrustResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$deleteTrust$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeregisterCertificateResponse deregisterCertificate(DeregisterCertificateRequest deregisterCertificateRequest) throws DirectoryUnavailableException, DirectoryDoesNotExistException, CertificateDoesNotExistException, CertificateInUseException, UnsupportedOperationException, InvalidParameterException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeregisterCertificateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, deregisterCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeregisterCertificate");
            DeregisterCertificateResponse deregisterCertificateResponse = (DeregisterCertificateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterCertificate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deregisterCertificateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeregisterCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deregisterCertificateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$deregisterCertificate$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeregisterEventTopicResponse deregisterEventTopic(DeregisterEventTopicRequest deregisterEventTopicRequest) throws EntityDoesNotExistException, InvalidParameterException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeregisterEventTopicResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, deregisterEventTopicRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeregisterEventTopic");
            DeregisterEventTopicResponse deregisterEventTopicResponse = (DeregisterEventTopicResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterEventTopic").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deregisterEventTopicRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeregisterEventTopicRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deregisterEventTopicResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$deregisterEventTopic$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeCertificateResponse describeCertificate(DescribeCertificateRequest describeCertificateRequest) throws DirectoryDoesNotExistException, UnsupportedOperationException, CertificateDoesNotExistException, InvalidParameterException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCertificateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, describeCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCertificate");
            DescribeCertificateResponse describeCertificateResponse = (DescribeCertificateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCertificate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeCertificateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeCertificateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$describeCertificate$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeClientAuthenticationSettingsResponse describeClientAuthenticationSettings(DescribeClientAuthenticationSettingsRequest describeClientAuthenticationSettingsRequest) throws DirectoryDoesNotExistException, UnsupportedOperationException, AccessDeniedException, InvalidParameterException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeClientAuthenticationSettingsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, describeClientAuthenticationSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeClientAuthenticationSettings");
            DescribeClientAuthenticationSettingsResponse describeClientAuthenticationSettingsResponse = (DescribeClientAuthenticationSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeClientAuthenticationSettings").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeClientAuthenticationSettingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeClientAuthenticationSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeClientAuthenticationSettingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$describeClientAuthenticationSettings$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeConditionalForwardersResponse describeConditionalForwarders(DescribeConditionalForwardersRequest describeConditionalForwardersRequest) throws EntityDoesNotExistException, DirectoryUnavailableException, InvalidParameterException, UnsupportedOperationException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeConditionalForwardersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, describeConditionalForwardersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeConditionalForwarders");
            DescribeConditionalForwardersResponse describeConditionalForwardersResponse = (DescribeConditionalForwardersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConditionalForwarders").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeConditionalForwardersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeConditionalForwardersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeConditionalForwardersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$describeConditionalForwarders$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDirectoriesResponse describeDirectories(DescribeDirectoriesRequest describeDirectoriesRequest) throws EntityDoesNotExistException, InvalidParameterException, InvalidNextTokenException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDirectoriesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, describeDirectoriesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDirectories");
            DescribeDirectoriesResponse describeDirectoriesResponse = (DescribeDirectoriesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDirectories").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDirectoriesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDirectoriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDirectoriesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$describeDirectories$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDomainControllersResponse describeDomainControllers(DescribeDomainControllersRequest describeDomainControllersRequest) throws EntityDoesNotExistException, InvalidNextTokenException, InvalidParameterException, ClientException, ServiceException, UnsupportedOperationException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDomainControllersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, describeDomainControllersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDomainControllers");
            DescribeDomainControllersResponse describeDomainControllersResponse = (DescribeDomainControllersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDomainControllers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDomainControllersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDomainControllersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDomainControllersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$describeDomainControllers$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeDomainControllersIterable describeDomainControllersPaginator(DescribeDomainControllersRequest describeDomainControllersRequest) throws EntityDoesNotExistException, InvalidNextTokenException, InvalidParameterException, ClientException, ServiceException, UnsupportedOperationException, AwsServiceException, SdkClientException, DirectoryException {
        return new DescribeDomainControllersIterable(this, this.applyPaginatorUserAgent(describeDomainControllersRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEventTopicsResponse describeEventTopics(DescribeEventTopicsRequest describeEventTopicsRequest) throws EntityDoesNotExistException, InvalidParameterException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEventTopicsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, describeEventTopicsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEventTopics");
            DescribeEventTopicsResponse describeEventTopicsResponse = (DescribeEventTopicsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEventTopics").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEventTopicsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeEventTopicsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeEventTopicsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$describeEventTopics$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeLdapsSettingsResponse describeLDAPSSettings(DescribeLdapsSettingsRequest describeLdapsSettingsRequest) throws DirectoryDoesNotExistException, UnsupportedOperationException, InvalidNextTokenException, InvalidParameterException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeLdapsSettingsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, describeLdapsSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeLDAPSSettings");
            DescribeLdapsSettingsResponse describeLdapsSettingsResponse = (DescribeLdapsSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLDAPSSettings").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeLdapsSettingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeLdapsSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeLdapsSettingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$describeLDAPSSettings$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeRegionsResponse describeRegions(DescribeRegionsRequest describeRegionsRequest) throws InvalidParameterException, DirectoryDoesNotExistException, UnsupportedOperationException, InvalidNextTokenException, AccessDeniedException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRegionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, describeRegionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeRegions");
            DescribeRegionsResponse describeRegionsResponse = (DescribeRegionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRegions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeRegionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeRegionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeRegionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$describeRegions$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeSharedDirectoriesResponse describeSharedDirectories(DescribeSharedDirectoriesRequest describeSharedDirectoriesRequest) throws EntityDoesNotExistException, InvalidNextTokenException, InvalidParameterException, UnsupportedOperationException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSharedDirectoriesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, describeSharedDirectoriesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSharedDirectories");
            DescribeSharedDirectoriesResponse describeSharedDirectoriesResponse = (DescribeSharedDirectoriesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSharedDirectories").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeSharedDirectoriesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeSharedDirectoriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeSharedDirectoriesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$describeSharedDirectories$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeSnapshotsResponse describeSnapshots(DescribeSnapshotsRequest describeSnapshotsRequest) throws EntityDoesNotExistException, InvalidParameterException, InvalidNextTokenException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSnapshotsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, describeSnapshotsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSnapshots");
            DescribeSnapshotsResponse describeSnapshotsResponse = (DescribeSnapshotsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSnapshots").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeSnapshotsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeSnapshotsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeSnapshotsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$describeSnapshots$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTrustsResponse describeTrusts(DescribeTrustsRequest describeTrustsRequest) throws EntityDoesNotExistException, InvalidNextTokenException, InvalidParameterException, ClientException, ServiceException, UnsupportedOperationException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTrustsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, describeTrustsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTrusts");
            DescribeTrustsResponse describeTrustsResponse = (DescribeTrustsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTrusts").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeTrustsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeTrustsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeTrustsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$describeTrusts$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisableClientAuthenticationResponse disableClientAuthentication(DisableClientAuthenticationRequest disableClientAuthenticationRequest) throws DirectoryDoesNotExistException, UnsupportedOperationException, InvalidClientAuthStatusException, AccessDeniedException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableClientAuthenticationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, disableClientAuthenticationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableClientAuthentication");
            DisableClientAuthenticationResponse disableClientAuthenticationResponse = (DisableClientAuthenticationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableClientAuthentication").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disableClientAuthenticationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisableClientAuthenticationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disableClientAuthenticationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$disableClientAuthentication$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisableLdapsResponse disableLDAPS(DisableLdapsRequest disableLdapsRequest) throws DirectoryUnavailableException, DirectoryDoesNotExistException, InvalidLdapsStatusException, UnsupportedOperationException, InvalidParameterException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableLdapsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, disableLdapsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableLDAPS");
            DisableLdapsResponse disableLdapsResponse = (DisableLdapsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableLDAPS").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disableLdapsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisableLdapsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disableLdapsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$disableLDAPS$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisableRadiusResponse disableRadius(DisableRadiusRequest disableRadiusRequest) throws EntityDoesNotExistException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableRadiusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, disableRadiusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableRadius");
            DisableRadiusResponse disableRadiusResponse = (DisableRadiusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableRadius").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disableRadiusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisableRadiusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disableRadiusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$disableRadius$34((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisableSsoResponse disableSso(DisableSsoRequest disableSsoRequest) throws EntityDoesNotExistException, InsufficientPermissionsException, AuthenticationFailedException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableSsoResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, disableSsoRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableSso");
            DisableSsoResponse disableSsoResponse = (DisableSsoResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableSso").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disableSsoRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisableSsoRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disableSsoResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$disableSso$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableClientAuthenticationResponse enableClientAuthentication(EnableClientAuthenticationRequest enableClientAuthenticationRequest) throws DirectoryDoesNotExistException, UnsupportedOperationException, InvalidClientAuthStatusException, AccessDeniedException, NoAvailableCertificateException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableClientAuthenticationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, enableClientAuthenticationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableClientAuthentication");
            EnableClientAuthenticationResponse enableClientAuthenticationResponse = (EnableClientAuthenticationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableClientAuthentication").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)enableClientAuthenticationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new EnableClientAuthenticationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return enableClientAuthenticationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$enableClientAuthentication$36((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableLdapsResponse enableLDAPS(EnableLdapsRequest enableLdapsRequest) throws DirectoryUnavailableException, DirectoryDoesNotExistException, NoAvailableCertificateException, InvalidLdapsStatusException, UnsupportedOperationException, InvalidParameterException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableLdapsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, enableLdapsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableLDAPS");
            EnableLdapsResponse enableLdapsResponse = (EnableLdapsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableLDAPS").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)enableLdapsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new EnableLdapsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return enableLdapsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$enableLDAPS$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableRadiusResponse enableRadius(EnableRadiusRequest enableRadiusRequest) throws InvalidParameterException, EntityAlreadyExistsException, EntityDoesNotExistException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableRadiusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, enableRadiusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableRadius");
            EnableRadiusResponse enableRadiusResponse = (EnableRadiusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableRadius").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)enableRadiusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new EnableRadiusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return enableRadiusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$enableRadius$38((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableSsoResponse enableSso(EnableSsoRequest enableSsoRequest) throws EntityDoesNotExistException, InsufficientPermissionsException, AuthenticationFailedException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableSsoResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, enableSsoRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableSso");
            EnableSsoResponse enableSsoResponse = (EnableSsoResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableSso").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)enableSsoRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new EnableSsoRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return enableSsoResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$enableSso$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDirectoryLimitsResponse getDirectoryLimits(GetDirectoryLimitsRequest getDirectoryLimitsRequest) throws EntityDoesNotExistException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDirectoryLimitsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, getDirectoryLimitsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDirectoryLimits");
            GetDirectoryLimitsResponse getDirectoryLimitsResponse = (GetDirectoryLimitsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDirectoryLimits").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDirectoryLimitsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDirectoryLimitsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDirectoryLimitsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$getDirectoryLimits$40((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSnapshotLimitsResponse getSnapshotLimits(GetSnapshotLimitsRequest getSnapshotLimitsRequest) throws EntityDoesNotExistException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSnapshotLimitsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, getSnapshotLimitsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSnapshotLimits");
            GetSnapshotLimitsResponse getSnapshotLimitsResponse = (GetSnapshotLimitsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSnapshotLimits").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSnapshotLimitsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSnapshotLimitsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSnapshotLimitsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$getSnapshotLimits$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListCertificatesResponse listCertificates(ListCertificatesRequest listCertificatesRequest) throws DirectoryDoesNotExistException, UnsupportedOperationException, InvalidParameterException, InvalidNextTokenException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCertificatesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, listCertificatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCertificates");
            ListCertificatesResponse listCertificatesResponse = (ListCertificatesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCertificates").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listCertificatesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListCertificatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listCertificatesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$listCertificates$42((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIpRoutesResponse listIpRoutes(ListIpRoutesRequest listIpRoutesRequest) throws EntityDoesNotExistException, InvalidNextTokenException, InvalidParameterException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListIpRoutesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, listIpRoutesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListIpRoutes");
            ListIpRoutesResponse listIpRoutesResponse = (ListIpRoutesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListIpRoutes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listIpRoutesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListIpRoutesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listIpRoutesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$listIpRoutes$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListLogSubscriptionsResponse listLogSubscriptions(ListLogSubscriptionsRequest listLogSubscriptionsRequest) throws EntityDoesNotExistException, InvalidNextTokenException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLogSubscriptionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, listLogSubscriptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListLogSubscriptions");
            ListLogSubscriptionsResponse listLogSubscriptionsResponse = (ListLogSubscriptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLogSubscriptions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listLogSubscriptionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListLogSubscriptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listLogSubscriptionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$listLogSubscriptions$44((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSchemaExtensionsResponse listSchemaExtensions(ListSchemaExtensionsRequest listSchemaExtensionsRequest) throws InvalidNextTokenException, EntityDoesNotExistException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSchemaExtensionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, listSchemaExtensionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSchemaExtensions");
            ListSchemaExtensionsResponse listSchemaExtensionsResponse = (ListSchemaExtensionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSchemaExtensions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listSchemaExtensionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSchemaExtensionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSchemaExtensionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$listSchemaExtensions$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws EntityDoesNotExistException, InvalidNextTokenException, InvalidParameterException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$listTagsForResource$46((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterCertificateResponse registerCertificate(RegisterCertificateRequest registerCertificateRequest) throws DirectoryUnavailableException, DirectoryDoesNotExistException, InvalidCertificateException, CertificateLimitExceededException, CertificateAlreadyExistsException, UnsupportedOperationException, InvalidParameterException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterCertificateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, registerCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterCertificate");
            RegisterCertificateResponse registerCertificateResponse = (RegisterCertificateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterCertificate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)registerCertificateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RegisterCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return registerCertificateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$registerCertificate$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterEventTopicResponse registerEventTopic(RegisterEventTopicRequest registerEventTopicRequest) throws EntityDoesNotExistException, InvalidParameterException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterEventTopicResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, registerEventTopicRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterEventTopic");
            RegisterEventTopicResponse registerEventTopicResponse = (RegisterEventTopicResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterEventTopic").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)registerEventTopicRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RegisterEventTopicRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return registerEventTopicResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$registerEventTopic$48((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RejectSharedDirectoryResponse rejectSharedDirectory(RejectSharedDirectoryRequest rejectSharedDirectoryRequest) throws InvalidParameterException, EntityDoesNotExistException, DirectoryAlreadySharedException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RejectSharedDirectoryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, rejectSharedDirectoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RejectSharedDirectory");
            RejectSharedDirectoryResponse rejectSharedDirectoryResponse = (RejectSharedDirectoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RejectSharedDirectory").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)rejectSharedDirectoryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RejectSharedDirectoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return rejectSharedDirectoryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$rejectSharedDirectory$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveIpRoutesResponse removeIpRoutes(RemoveIpRoutesRequest removeIpRoutesRequest) throws EntityDoesNotExistException, InvalidParameterException, DirectoryUnavailableException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveIpRoutesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, removeIpRoutesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveIpRoutes");
            RemoveIpRoutesResponse removeIpRoutesResponse = (RemoveIpRoutesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveIpRoutes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removeIpRoutesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RemoveIpRoutesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return removeIpRoutesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$removeIpRoutes$50((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveRegionResponse removeRegion(RemoveRegionRequest removeRegionRequest) throws DirectoryUnavailableException, DirectoryDoesNotExistException, UnsupportedOperationException, AccessDeniedException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveRegionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, removeRegionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveRegion");
            RemoveRegionResponse removeRegionResponse = (RemoveRegionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveRegion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removeRegionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RemoveRegionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return removeRegionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$removeRegion$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveTagsFromResourceResponse removeTagsFromResource(RemoveTagsFromResourceRequest removeTagsFromResourceRequest) throws EntityDoesNotExistException, InvalidParameterException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveTagsFromResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, removeTagsFromResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveTagsFromResource");
            RemoveTagsFromResourceResponse removeTagsFromResourceResponse = (RemoveTagsFromResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveTagsFromResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removeTagsFromResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RemoveTagsFromResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return removeTagsFromResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$removeTagsFromResource$52((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResetUserPasswordResponse resetUserPassword(ResetUserPasswordRequest resetUserPasswordRequest) throws DirectoryUnavailableException, UserDoesNotExistException, InvalidPasswordException, UnsupportedOperationException, EntityDoesNotExistException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ResetUserPasswordResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, resetUserPasswordRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ResetUserPassword");
            ResetUserPasswordResponse resetUserPasswordResponse = (ResetUserPasswordResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResetUserPassword").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)resetUserPasswordRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ResetUserPasswordRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return resetUserPasswordResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$resetUserPassword$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RestoreFromSnapshotResponse restoreFromSnapshot(RestoreFromSnapshotRequest restoreFromSnapshotRequest) throws EntityDoesNotExistException, InvalidParameterException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RestoreFromSnapshotResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, restoreFromSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RestoreFromSnapshot");
            RestoreFromSnapshotResponse restoreFromSnapshotResponse = (RestoreFromSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestoreFromSnapshot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)restoreFromSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RestoreFromSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return restoreFromSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$restoreFromSnapshot$54((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ShareDirectoryResponse shareDirectory(ShareDirectoryRequest shareDirectoryRequest) throws DirectoryAlreadySharedException, EntityDoesNotExistException, InvalidTargetException, InvalidParameterException, ClientException, ShareLimitExceededException, OrganizationsException, AccessDeniedException, UnsupportedOperationException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ShareDirectoryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, shareDirectoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ShareDirectory");
            ShareDirectoryResponse shareDirectoryResponse = (ShareDirectoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ShareDirectory").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)shareDirectoryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ShareDirectoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return shareDirectoryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$shareDirectory$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartSchemaExtensionResponse startSchemaExtension(StartSchemaExtensionRequest startSchemaExtensionRequest) throws DirectoryUnavailableException, EntityDoesNotExistException, InvalidParameterException, SnapshotLimitExceededException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartSchemaExtensionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, startSchemaExtensionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartSchemaExtension");
            StartSchemaExtensionResponse startSchemaExtensionResponse = (StartSchemaExtensionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartSchemaExtension").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startSchemaExtensionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartSchemaExtensionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startSchemaExtensionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$startSchemaExtension$56((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UnshareDirectoryResponse unshareDirectory(UnshareDirectoryRequest unshareDirectoryRequest) throws EntityDoesNotExistException, InvalidTargetException, DirectoryNotSharedException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UnshareDirectoryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, unshareDirectoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UnshareDirectory");
            UnshareDirectoryResponse unshareDirectoryResponse = (UnshareDirectoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UnshareDirectory").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)unshareDirectoryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UnshareDirectoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return unshareDirectoryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$unshareDirectory$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateConditionalForwarderResponse updateConditionalForwarder(UpdateConditionalForwarderRequest updateConditionalForwarderRequest) throws EntityDoesNotExistException, DirectoryUnavailableException, InvalidParameterException, UnsupportedOperationException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateConditionalForwarderResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, updateConditionalForwarderRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateConditionalForwarder");
            UpdateConditionalForwarderResponse updateConditionalForwarderResponse = (UpdateConditionalForwarderResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateConditionalForwarder").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateConditionalForwarderRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateConditionalForwarderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateConditionalForwarderResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$updateConditionalForwarder$58((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateNumberOfDomainControllersResponse updateNumberOfDomainControllers(UpdateNumberOfDomainControllersRequest updateNumberOfDomainControllersRequest) throws EntityDoesNotExistException, DirectoryUnavailableException, DomainControllerLimitExceededException, InvalidParameterException, UnsupportedOperationException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateNumberOfDomainControllersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, updateNumberOfDomainControllersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateNumberOfDomainControllers");
            UpdateNumberOfDomainControllersResponse updateNumberOfDomainControllersResponse = (UpdateNumberOfDomainControllersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateNumberOfDomainControllers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateNumberOfDomainControllersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateNumberOfDomainControllersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateNumberOfDomainControllersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$updateNumberOfDomainControllers$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateRadiusResponse updateRadius(UpdateRadiusRequest updateRadiusRequest) throws InvalidParameterException, EntityDoesNotExistException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateRadiusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, updateRadiusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateRadius");
            UpdateRadiusResponse updateRadiusResponse = (UpdateRadiusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateRadius").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateRadiusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateRadiusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateRadiusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$updateRadius$60((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateTrustResponse updateTrust(UpdateTrustRequest updateTrustRequest) throws EntityDoesNotExistException, InvalidParameterException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTrustResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, updateTrustRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateTrust");
            UpdateTrustResponse updateTrustResponse = (UpdateTrustResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTrust").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateTrustRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateTrustRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateTrustResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$updateTrust$61((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VerifyTrustResponse verifyTrust(VerifyTrustRequest verifyTrustRequest) throws EntityDoesNotExistException, InvalidParameterException, ClientException, ServiceException, UnsupportedOperationException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, VerifyTrustResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(this.clientConfiguration, verifyTrustRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"VerifyTrust");
            VerifyTrustResponse verifyTrustResponse = (VerifyTrustResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("VerifyTrust").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)verifyTrustRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new VerifyTrustRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return verifyTrustResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$verifyTrust$62((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(DirectoryException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").exceptionBuilderSupplier(DirectoryUnavailableException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidCertificateException").exceptionBuilderSupplier(InvalidCertificateException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").exceptionBuilderSupplier(DirectoryNotSharedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").exceptionBuilderSupplier(RegionLimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").exceptionBuilderSupplier(EntityDoesNotExistException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").exceptionBuilderSupplier(InvalidNextTokenException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").exceptionBuilderSupplier(UserDoesNotExistException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidPasswordException").exceptionBuilderSupplier(InvalidPasswordException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").exceptionBuilderSupplier(UnsupportedOperationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClientException").exceptionBuilderSupplier(ClientException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").exceptionBuilderSupplier(AuthenticationFailedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").exceptionBuilderSupplier(InsufficientPermissionsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").exceptionBuilderSupplier(CertificateLimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OrganizationsException").exceptionBuilderSupplier(OrganizationsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidParameterException").exceptionBuilderSupplier(InvalidParameterException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceException").exceptionBuilderSupplier(ServiceException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").exceptionBuilderSupplier(NoAvailableCertificateException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTargetException").exceptionBuilderSupplier(InvalidTargetException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TagLimitExceededException").exceptionBuilderSupplier(TagLimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").exceptionBuilderSupplier(ShareLimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CertificateInUseException").exceptionBuilderSupplier(CertificateInUseException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends DirectoryRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.17.46").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((DirectoryRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private static /* synthetic */ void lambda$verifyTrust$62(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateTrust$61(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateRadius$60(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateNumberOfDomainControllers$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateConditionalForwarder$58(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$unshareDirectory$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startSchemaExtension$56(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$shareDirectory$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$restoreFromSnapshot$54(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$resetUserPassword$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removeTagsFromResource$52(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removeRegion$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removeIpRoutes$50(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$rejectSharedDirectory$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$registerEventTopic$48(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$registerCertificate$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$46(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSchemaExtensions$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listLogSubscriptions$44(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listIpRoutes$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCertificates$42(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSnapshotLimits$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDirectoryLimits$40(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$enableSso$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$enableRadius$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$enableLDAPS$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$enableClientAuthentication$36(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disableSso$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disableRadius$34(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disableLDAPS$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disableClientAuthentication$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTrusts$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSnapshots$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSharedDirectories$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeRegions$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeLDAPSSettings$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEventTopics$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDomainControllers$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDirectories$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeConditionalForwarders$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeClientAuthenticationSettings$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeCertificate$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deregisterEventTopic$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deregisterCertificate$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteTrust$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSnapshot$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteLogSubscription$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDirectory$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteConditionalForwarder$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createTrust$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSnapshot$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createMicrosoftAD$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createLogSubscription$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDirectory$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createConditionalForwarder$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createComputer$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAlias$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$connectDirectory$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelSchemaExtension$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addTagsToResource$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addRegion$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addIpRoutes$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$acceptSharedDirectory$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

