/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of a CreateTrust request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTrustResponse extends DirectoryResponse implements
        ToCopyableBuilder<CreateTrustResponse.Builder, CreateTrustResponse> {
    private static final SdkField<String> TRUST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrustId").getter(getter(CreateTrustResponse::trustId)).setter(setter(Builder::trustId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRUST_ID_FIELD));

    private final String trustId;

    private CreateTrustResponse(BuilderImpl builder) {
        super(builder);
        this.trustId = builder.trustId;
    }

    /**
     * <p>
     * A unique identifier for the trust relationship that was created.
     * </p>
     * 
     * @return A unique identifier for the trust relationship that was created.
     */
    public final String trustId() {
        return trustId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trustId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrustResponse)) {
            return false;
        }
        CreateTrustResponse other = (CreateTrustResponse) obj;
        return Objects.equals(trustId(), other.trustId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTrustResponse").add("TrustId", trustId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrustId":
            return Optional.ofNullable(clazz.cast(trustId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTrustResponse, T> g) {
        return obj -> g.apply((CreateTrustResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectoryResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateTrustResponse> {
        /**
         * <p>
         * A unique identifier for the trust relationship that was created.
         * </p>
         * 
         * @param trustId
         *        A unique identifier for the trust relationship that was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustId(String trustId);
    }

    static final class BuilderImpl extends DirectoryResponse.BuilderImpl implements Builder {
        private String trustId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrustResponse model) {
            super(model);
            trustId(model.trustId);
        }

        public final String getTrustId() {
            return trustId;
        }

        public final void setTrustId(String trustId) {
            this.trustId = trustId;
        }

        @Override
        @Transient
        public final Builder trustId(String trustId) {
            this.trustId = trustId;
            return this;
        }

        @Override
        public CreateTrustResponse build() {
            return new CreateTrustResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
