/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the inputs for the <a>EnableRadius</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnableRadiusRequest extends DirectoryRequest implements
        ToCopyableBuilder<EnableRadiusRequest.Builder, EnableRadiusRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(EnableRadiusRequest::directoryId)).setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<RadiusSettings> RADIUS_SETTINGS_FIELD = SdkField
            .<RadiusSettings> builder(MarshallingType.SDK_POJO).memberName("RadiusSettings")
            .getter(getter(EnableRadiusRequest::radiusSettings)).setter(setter(Builder::radiusSettings))
            .constructor(RadiusSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RadiusSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD,
            RADIUS_SETTINGS_FIELD));

    private final String directoryId;

    private final RadiusSettings radiusSettings;

    private EnableRadiusRequest(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.radiusSettings = builder.radiusSettings;
    }

    /**
     * <p>
     * The identifier of the directory for which to enable MFA.
     * </p>
     * 
     * @return The identifier of the directory for which to enable MFA.
     */
    public final String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * A <a>RadiusSettings</a> object that contains information about the RADIUS server.
     * </p>
     * 
     * @return A <a>RadiusSettings</a> object that contains information about the RADIUS server.
     */
    public final RadiusSettings radiusSettings() {
        return radiusSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(radiusSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableRadiusRequest)) {
            return false;
        }
        EnableRadiusRequest other = (EnableRadiusRequest) obj;
        return Objects.equals(directoryId(), other.directoryId()) && Objects.equals(radiusSettings(), other.radiusSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnableRadiusRequest").add("DirectoryId", directoryId()).add("RadiusSettings", radiusSettings())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "RadiusSettings":
            return Optional.ofNullable(clazz.cast(radiusSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnableRadiusRequest, T> g) {
        return obj -> g.apply((EnableRadiusRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectoryRequest.Builder, SdkPojo, CopyableBuilder<Builder, EnableRadiusRequest> {
        /**
         * <p>
         * The identifier of the directory for which to enable MFA.
         * </p>
         * 
         * @param directoryId
         *        The identifier of the directory for which to enable MFA.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * A <a>RadiusSettings</a> object that contains information about the RADIUS server.
         * </p>
         * 
         * @param radiusSettings
         *        A <a>RadiusSettings</a> object that contains information about the RADIUS server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder radiusSettings(RadiusSettings radiusSettings);

        /**
         * <p>
         * A <a>RadiusSettings</a> object that contains information about the RADIUS server.
         * </p>
         * This is a convenience that creates an instance of the {@link RadiusSettings.Builder} avoiding the need to
         * create one manually via {@link RadiusSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link RadiusSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #radiusSettings(RadiusSettings)}.
         * 
         * @param radiusSettings
         *        a consumer that will call methods on {@link RadiusSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #radiusSettings(RadiusSettings)
         */
        default Builder radiusSettings(Consumer<RadiusSettings.Builder> radiusSettings) {
            return radiusSettings(RadiusSettings.builder().applyMutation(radiusSettings).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectoryRequest.BuilderImpl implements Builder {
        private String directoryId;

        private RadiusSettings radiusSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableRadiusRequest model) {
            super(model);
            directoryId(model.directoryId);
            radiusSettings(model.radiusSettings);
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        @Transient
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final RadiusSettings.Builder getRadiusSettings() {
            return radiusSettings != null ? radiusSettings.toBuilder() : null;
        }

        public final void setRadiusSettings(RadiusSettings.BuilderImpl radiusSettings) {
            this.radiusSettings = radiusSettings != null ? radiusSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder radiusSettings(RadiusSettings radiusSettings) {
            this.radiusSettings = radiusSettings;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EnableRadiusRequest build() {
            return new EnableRadiusRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
