/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UnshareDirectoryResponse extends DirectoryResponse implements
        ToCopyableBuilder<UnshareDirectoryResponse.Builder, UnshareDirectoryResponse> {
    private static final SdkField<String> SHARED_DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SharedDirectoryId").getter(getter(UnshareDirectoryResponse::sharedDirectoryId))
            .setter(setter(Builder::sharedDirectoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedDirectoryId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARED_DIRECTORY_ID_FIELD));

    private final String sharedDirectoryId;

    private UnshareDirectoryResponse(BuilderImpl builder) {
        super(builder);
        this.sharedDirectoryId = builder.sharedDirectoryId;
    }

    /**
     * <p>
     * Identifier of the directory stored in the directory consumer account that is to be unshared from the specified
     * directory (<code>DirectoryId</code>).
     * </p>
     * 
     * @return Identifier of the directory stored in the directory consumer account that is to be unshared from the
     *         specified directory (<code>DirectoryId</code>).
     */
    public final String sharedDirectoryId() {
        return sharedDirectoryId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sharedDirectoryId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnshareDirectoryResponse)) {
            return false;
        }
        UnshareDirectoryResponse other = (UnshareDirectoryResponse) obj;
        return Objects.equals(sharedDirectoryId(), other.sharedDirectoryId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UnshareDirectoryResponse").add("SharedDirectoryId", sharedDirectoryId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SharedDirectoryId":
            return Optional.ofNullable(clazz.cast(sharedDirectoryId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UnshareDirectoryResponse, T> g) {
        return obj -> g.apply((UnshareDirectoryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectoryResponse.Builder, SdkPojo, CopyableBuilder<Builder, UnshareDirectoryResponse> {
        /**
         * <p>
         * Identifier of the directory stored in the directory consumer account that is to be unshared from the
         * specified directory (<code>DirectoryId</code>).
         * </p>
         * 
         * @param sharedDirectoryId
         *        Identifier of the directory stored in the directory consumer account that is to be unshared from the
         *        specified directory (<code>DirectoryId</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedDirectoryId(String sharedDirectoryId);
    }

    static final class BuilderImpl extends DirectoryResponse.BuilderImpl implements Builder {
        private String sharedDirectoryId;

        private BuilderImpl() {
        }

        private BuilderImpl(UnshareDirectoryResponse model) {
            super(model);
            sharedDirectoryId(model.sharedDirectoryId);
        }

        public final String getSharedDirectoryId() {
            return sharedDirectoryId;
        }

        public final void setSharedDirectoryId(String sharedDirectoryId) {
            this.sharedDirectoryId = sharedDirectoryId;
        }

        @Override
        @Transient
        public final Builder sharedDirectoryId(String sharedDirectoryId) {
            this.sharedDirectoryId = sharedDirectoryId;
            return this;
        }

        @Override
        public UnshareDirectoryResponse build() {
            return new UnshareDirectoryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
