/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a computer account in a directory.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Computer implements SdkPojo, Serializable, ToCopyableBuilder<Computer.Builder, Computer> {
    private static final SdkField<String> COMPUTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComputerId").getter(getter(Computer::computerId)).setter(setter(Builder::computerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputerId").build()).build();

    private static final SdkField<String> COMPUTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComputerName").getter(getter(Computer::computerName)).setter(setter(Builder::computerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputerName").build()).build();

    private static final SdkField<List<Attribute>> COMPUTER_ATTRIBUTES_FIELD = SdkField
            .<List<Attribute>> builder(MarshallingType.LIST)
            .memberName("ComputerAttributes")
            .getter(getter(Computer::computerAttributes))
            .setter(setter(Builder::computerAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputerAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Attribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(Attribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTER_ID_FIELD,
            COMPUTER_NAME_FIELD, COMPUTER_ATTRIBUTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String computerId;

    private final String computerName;

    private final List<Attribute> computerAttributes;

    private Computer(BuilderImpl builder) {
        this.computerId = builder.computerId;
        this.computerName = builder.computerName;
        this.computerAttributes = builder.computerAttributes;
    }

    /**
     * <p>
     * The identifier of the computer.
     * </p>
     * 
     * @return The identifier of the computer.
     */
    public final String computerId() {
        return computerId;
    }

    /**
     * <p>
     * The computer name.
     * </p>
     * 
     * @return The computer name.
     */
    public final String computerName() {
        return computerName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ComputerAttributes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasComputerAttributes() {
        return computerAttributes != null && !(computerAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <a>Attribute</a> objects containing the LDAP attributes that belong to the computer account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasComputerAttributes} method.
     * </p>
     * 
     * @return An array of <a>Attribute</a> objects containing the LDAP attributes that belong to the computer account.
     */
    public final List<Attribute> computerAttributes() {
        return computerAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(computerId());
        hashCode = 31 * hashCode + Objects.hashCode(computerName());
        hashCode = 31 * hashCode + Objects.hashCode(hasComputerAttributes() ? computerAttributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Computer)) {
            return false;
        }
        Computer other = (Computer) obj;
        return Objects.equals(computerId(), other.computerId()) && Objects.equals(computerName(), other.computerName())
                && hasComputerAttributes() == other.hasComputerAttributes()
                && Objects.equals(computerAttributes(), other.computerAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Computer").add("ComputerId", computerId()).add("ComputerName", computerName())
                .add("ComputerAttributes", hasComputerAttributes() ? computerAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComputerId":
            return Optional.ofNullable(clazz.cast(computerId()));
        case "ComputerName":
            return Optional.ofNullable(clazz.cast(computerName()));
        case "ComputerAttributes":
            return Optional.ofNullable(clazz.cast(computerAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Computer, T> g) {
        return obj -> g.apply((Computer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Computer> {
        /**
         * <p>
         * The identifier of the computer.
         * </p>
         * 
         * @param computerId
         *        The identifier of the computer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computerId(String computerId);

        /**
         * <p>
         * The computer name.
         * </p>
         * 
         * @param computerName
         *        The computer name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computerName(String computerName);

        /**
         * <p>
         * An array of <a>Attribute</a> objects containing the LDAP attributes that belong to the computer account.
         * </p>
         * 
         * @param computerAttributes
         *        An array of <a>Attribute</a> objects containing the LDAP attributes that belong to the computer
         *        account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computerAttributes(Collection<Attribute> computerAttributes);

        /**
         * <p>
         * An array of <a>Attribute</a> objects containing the LDAP attributes that belong to the computer account.
         * </p>
         * 
         * @param computerAttributes
         *        An array of <a>Attribute</a> objects containing the LDAP attributes that belong to the computer
         *        account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computerAttributes(Attribute... computerAttributes);

        /**
         * <p>
         * An array of <a>Attribute</a> objects containing the LDAP attributes that belong to the computer account.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Attribute>.Builder} avoiding the need to
         * create one manually via {@link List<Attribute>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Attribute>.Builder#build()} is called immediately and its
         * result is passed to {@link #computerAttributes(List<Attribute>)}.
         * 
         * @param computerAttributes
         *        a consumer that will call methods on {@link List<Attribute>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #computerAttributes(List<Attribute>)
         */
        Builder computerAttributes(Consumer<Attribute.Builder>... computerAttributes);
    }

    static final class BuilderImpl implements Builder {
        private String computerId;

        private String computerName;

        private List<Attribute> computerAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Computer model) {
            computerId(model.computerId);
            computerName(model.computerName);
            computerAttributes(model.computerAttributes);
        }

        public final String getComputerId() {
            return computerId;
        }

        public final void setComputerId(String computerId) {
            this.computerId = computerId;
        }

        @Override
        @Transient
        public final Builder computerId(String computerId) {
            this.computerId = computerId;
            return this;
        }

        public final String getComputerName() {
            return computerName;
        }

        public final void setComputerName(String computerName) {
            this.computerName = computerName;
        }

        @Override
        @Transient
        public final Builder computerName(String computerName) {
            this.computerName = computerName;
            return this;
        }

        public final List<Attribute.Builder> getComputerAttributes() {
            List<Attribute.Builder> result = AttributesCopier.copyToBuilder(this.computerAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComputerAttributes(Collection<Attribute.BuilderImpl> computerAttributes) {
            this.computerAttributes = AttributesCopier.copyFromBuilder(computerAttributes);
        }

        @Override
        @Transient
        public final Builder computerAttributes(Collection<Attribute> computerAttributes) {
            this.computerAttributes = AttributesCopier.copy(computerAttributes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder computerAttributes(Attribute... computerAttributes) {
            computerAttributes(Arrays.asList(computerAttributes));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder computerAttributes(Consumer<Attribute.Builder>... computerAttributes) {
            computerAttributes(Stream.of(computerAttributes).map(c -> Attribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Computer build() {
            return new Computer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
