/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of a DescribeEventTopic request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEventTopicsResponse extends DirectoryResponse implements
        ToCopyableBuilder<DescribeEventTopicsResponse.Builder, DescribeEventTopicsResponse> {
    private static final SdkField<List<EventTopic>> EVENT_TOPICS_FIELD = SdkField
            .<List<EventTopic>> builder(MarshallingType.LIST)
            .memberName("EventTopics")
            .getter(getter(DescribeEventTopicsResponse::eventTopics))
            .setter(setter(Builder::eventTopics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTopics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EventTopic> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventTopic::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_TOPICS_FIELD));

    private final List<EventTopic> eventTopics;

    private DescribeEventTopicsResponse(BuilderImpl builder) {
        super(builder);
        this.eventTopics = builder.eventTopics;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventTopics property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEventTopics() {
        return eventTopics != null && !(eventTopics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Amazon SNS topic names that receive status messages from the specified Directory ID.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventTopics} method.
     * </p>
     * 
     * @return A list of Amazon SNS topic names that receive status messages from the specified Directory ID.
     */
    public final List<EventTopic> eventTopics() {
        return eventTopics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEventTopics() ? eventTopics() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventTopicsResponse)) {
            return false;
        }
        DescribeEventTopicsResponse other = (DescribeEventTopicsResponse) obj;
        return hasEventTopics() == other.hasEventTopics() && Objects.equals(eventTopics(), other.eventTopics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeEventTopicsResponse").add("EventTopics", hasEventTopics() ? eventTopics() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventTopics":
            return Optional.ofNullable(clazz.cast(eventTopics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEventTopicsResponse, T> g) {
        return obj -> g.apply((DescribeEventTopicsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectoryResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeEventTopicsResponse> {
        /**
         * <p>
         * A list of Amazon SNS topic names that receive status messages from the specified Directory ID.
         * </p>
         * 
         * @param eventTopics
         *        A list of Amazon SNS topic names that receive status messages from the specified Directory ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTopics(Collection<EventTopic> eventTopics);

        /**
         * <p>
         * A list of Amazon SNS topic names that receive status messages from the specified Directory ID.
         * </p>
         * 
         * @param eventTopics
         *        A list of Amazon SNS topic names that receive status messages from the specified Directory ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTopics(EventTopic... eventTopics);

        /**
         * <p>
         * A list of Amazon SNS topic names that receive status messages from the specified Directory ID.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.directory.model.EventTopic.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.directory.model.EventTopic#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.directory.model.EventTopic.Builder#build()} is called immediately and
         * its result is passed to {@link #eventTopics(List<EventTopic>)}.
         * 
         * @param eventTopics
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.directory.model.EventTopic.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventTopics(java.util.Collection<EventTopic>)
         */
        Builder eventTopics(Consumer<EventTopic.Builder>... eventTopics);
    }

    static final class BuilderImpl extends DirectoryResponse.BuilderImpl implements Builder {
        private List<EventTopic> eventTopics = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventTopicsResponse model) {
            super(model);
            eventTopics(model.eventTopics);
        }

        public final List<EventTopic.Builder> getEventTopics() {
            List<EventTopic.Builder> result = EventTopicsCopier.copyToBuilder(this.eventTopics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventTopics(Collection<EventTopic.BuilderImpl> eventTopics) {
            this.eventTopics = EventTopicsCopier.copyFromBuilder(eventTopics);
        }

        @Override
        public final Builder eventTopics(Collection<EventTopic> eventTopics) {
            this.eventTopics = EventTopicsCopier.copy(eventTopics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTopics(EventTopic... eventTopics) {
            eventTopics(Arrays.asList(eventTopics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTopics(Consumer<EventTopic.Builder>... eventTopics) {
            eventTopics(Stream.of(eventTopics).map(c -> EventTopic.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeEventTopicsResponse build() {
            return new DescribeEventTopicsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
