/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directory.model.SchemaExtensionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SchemaExtensionInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SchemaExtensionInfo> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryId").getter(SchemaExtensionInfo.getter(SchemaExtensionInfo::directoryId)).setter(SchemaExtensionInfo.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()}).build();
    private static final SdkField<String> SCHEMA_EXTENSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SchemaExtensionId").getter(SchemaExtensionInfo.getter(SchemaExtensionInfo::schemaExtensionId)).setter(SchemaExtensionInfo.setter(Builder::schemaExtensionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaExtensionId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(SchemaExtensionInfo.getter(SchemaExtensionInfo::description)).setter(SchemaExtensionInfo.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> SCHEMA_EXTENSION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SchemaExtensionStatus").getter(SchemaExtensionInfo.getter(SchemaExtensionInfo::schemaExtensionStatusAsString)).setter(SchemaExtensionInfo.setter(Builder::schemaExtensionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaExtensionStatus").build()}).build();
    private static final SdkField<String> SCHEMA_EXTENSION_STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SchemaExtensionStatusReason").getter(SchemaExtensionInfo.getter(SchemaExtensionInfo::schemaExtensionStatusReason)).setter(SchemaExtensionInfo.setter(Builder::schemaExtensionStatusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaExtensionStatusReason").build()}).build();
    private static final SdkField<Instant> START_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartDateTime").getter(SchemaExtensionInfo.getter(SchemaExtensionInfo::startDateTime)).setter(SchemaExtensionInfo.setter(Builder::startDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDateTime").build()}).build();
    private static final SdkField<Instant> END_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndDateTime").getter(SchemaExtensionInfo.getter(SchemaExtensionInfo::endDateTime)).setter(SchemaExtensionInfo.setter(Builder::endDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD, SCHEMA_EXTENSION_ID_FIELD, DESCRIPTION_FIELD, SCHEMA_EXTENSION_STATUS_FIELD, SCHEMA_EXTENSION_STATUS_REASON_FIELD, START_DATE_TIME_FIELD, END_DATE_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String directoryId;
    private final String schemaExtensionId;
    private final String description;
    private final String schemaExtensionStatus;
    private final String schemaExtensionStatusReason;
    private final Instant startDateTime;
    private final Instant endDateTime;

    private SchemaExtensionInfo(BuilderImpl builder) {
        this.directoryId = builder.directoryId;
        this.schemaExtensionId = builder.schemaExtensionId;
        this.description = builder.description;
        this.schemaExtensionStatus = builder.schemaExtensionStatus;
        this.schemaExtensionStatusReason = builder.schemaExtensionStatusReason;
        this.startDateTime = builder.startDateTime;
        this.endDateTime = builder.endDateTime;
    }

    public final String directoryId() {
        return this.directoryId;
    }

    public final String schemaExtensionId() {
        return this.schemaExtensionId;
    }

    public final String description() {
        return this.description;
    }

    public final SchemaExtensionStatus schemaExtensionStatus() {
        return SchemaExtensionStatus.fromValue(this.schemaExtensionStatus);
    }

    public final String schemaExtensionStatusAsString() {
        return this.schemaExtensionStatus;
    }

    public final String schemaExtensionStatusReason() {
        return this.schemaExtensionStatusReason;
    }

    public final Instant startDateTime() {
        return this.startDateTime;
    }

    public final Instant endDateTime() {
        return this.endDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaExtensionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaExtensionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaExtensionStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.startDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaExtensionInfo)) {
            return false;
        }
        SchemaExtensionInfo other = (SchemaExtensionInfo)obj;
        return Objects.equals(this.directoryId(), other.directoryId()) && Objects.equals(this.schemaExtensionId(), other.schemaExtensionId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.schemaExtensionStatusAsString(), other.schemaExtensionStatusAsString()) && Objects.equals(this.schemaExtensionStatusReason(), other.schemaExtensionStatusReason()) && Objects.equals(this.startDateTime(), other.startDateTime()) && Objects.equals(this.endDateTime(), other.endDateTime());
    }

    public final String toString() {
        return ToString.builder((String)"SchemaExtensionInfo").add("DirectoryId", (Object)this.directoryId()).add("SchemaExtensionId", (Object)this.schemaExtensionId()).add("Description", (Object)this.description()).add("SchemaExtensionStatus", (Object)this.schemaExtensionStatusAsString()).add("SchemaExtensionStatusReason", (Object)this.schemaExtensionStatusReason()).add("StartDateTime", (Object)this.startDateTime()).add("EndDateTime", (Object)this.endDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "SchemaExtensionId": {
                return Optional.ofNullable(clazz.cast(this.schemaExtensionId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "SchemaExtensionStatus": {
                return Optional.ofNullable(clazz.cast(this.schemaExtensionStatusAsString()));
            }
            case "SchemaExtensionStatusReason": {
                return Optional.ofNullable(clazz.cast(this.schemaExtensionStatusReason()));
            }
            case "StartDateTime": {
                return Optional.ofNullable(clazz.cast(this.startDateTime()));
            }
            case "EndDateTime": {
                return Optional.ofNullable(clazz.cast(this.endDateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SchemaExtensionInfo, T> g) {
        return obj -> g.apply((SchemaExtensionInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String directoryId;
        private String schemaExtensionId;
        private String description;
        private String schemaExtensionStatus;
        private String schemaExtensionStatusReason;
        private Instant startDateTime;
        private Instant endDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(SchemaExtensionInfo model) {
            this.directoryId(model.directoryId);
            this.schemaExtensionId(model.schemaExtensionId);
            this.description(model.description);
            this.schemaExtensionStatus(model.schemaExtensionStatus);
            this.schemaExtensionStatusReason(model.schemaExtensionStatusReason);
            this.startDateTime(model.startDateTime);
            this.endDateTime(model.endDateTime);
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getSchemaExtensionId() {
            return this.schemaExtensionId;
        }

        public final void setSchemaExtensionId(String schemaExtensionId) {
            this.schemaExtensionId = schemaExtensionId;
        }

        @Override
        public final Builder schemaExtensionId(String schemaExtensionId) {
            this.schemaExtensionId = schemaExtensionId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getSchemaExtensionStatus() {
            return this.schemaExtensionStatus;
        }

        public final void setSchemaExtensionStatus(String schemaExtensionStatus) {
            this.schemaExtensionStatus = schemaExtensionStatus;
        }

        @Override
        public final Builder schemaExtensionStatus(String schemaExtensionStatus) {
            this.schemaExtensionStatus = schemaExtensionStatus;
            return this;
        }

        @Override
        public final Builder schemaExtensionStatus(SchemaExtensionStatus schemaExtensionStatus) {
            this.schemaExtensionStatus(schemaExtensionStatus == null ? null : schemaExtensionStatus.toString());
            return this;
        }

        public final String getSchemaExtensionStatusReason() {
            return this.schemaExtensionStatusReason;
        }

        public final void setSchemaExtensionStatusReason(String schemaExtensionStatusReason) {
            this.schemaExtensionStatusReason = schemaExtensionStatusReason;
        }

        @Override
        public final Builder schemaExtensionStatusReason(String schemaExtensionStatusReason) {
            this.schemaExtensionStatusReason = schemaExtensionStatusReason;
            return this;
        }

        public final Instant getStartDateTime() {
            return this.startDateTime;
        }

        public final void setStartDateTime(Instant startDateTime) {
            this.startDateTime = startDateTime;
        }

        @Override
        public final Builder startDateTime(Instant startDateTime) {
            this.startDateTime = startDateTime;
            return this;
        }

        public final Instant getEndDateTime() {
            return this.endDateTime;
        }

        public final void setEndDateTime(Instant endDateTime) {
            this.endDateTime = endDateTime;
        }

        @Override
        public final Builder endDateTime(Instant endDateTime) {
            this.endDateTime = endDateTime;
            return this;
        }

        public SchemaExtensionInfo build() {
            return new SchemaExtensionInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SchemaExtensionInfo> {
        public Builder directoryId(String var1);

        public Builder schemaExtensionId(String var1);

        public Builder description(String var1);

        public Builder schemaExtensionStatus(String var1);

        public Builder schemaExtensionStatus(SchemaExtensionStatus var1);

        public Builder schemaExtensionStatusReason(String var1);

        public Builder startDateTime(Instant var1);

        public Builder endDateTime(Instant var1);
    }
}

