/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.directory.DirectoryClient;
import software.amazon.awssdk.services.directory.internal.UserAgentUtils;
import software.amazon.awssdk.services.directory.model.DescribeDirectoriesRequest;
import software.amazon.awssdk.services.directory.model.DescribeDirectoriesResponse;
import software.amazon.awssdk.services.directory.model.DirectoryDescription;

public class DescribeDirectoriesIterable
implements SdkIterable<DescribeDirectoriesResponse> {
    private final DirectoryClient client;
    private final DescribeDirectoriesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDirectoriesIterable(DirectoryClient client, DescribeDirectoriesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeDirectoriesResponseFetcher();
    }

    public Iterator<DescribeDirectoriesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DirectoryDescription> directoryDescriptions() {
        Function<DescribeDirectoriesResponse, Iterator> getIterator = response -> {
            if (response != null && response.directoryDescriptions() != null) {
                return response.directoryDescriptions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeDirectoriesResponseFetcher
    implements SyncPageFetcher<DescribeDirectoriesResponse> {
        private DescribeDirectoriesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDirectoriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeDirectoriesResponse nextPage(DescribeDirectoriesResponse previousPage) {
            if (previousPage == null) {
                return DescribeDirectoriesIterable.this.client.describeDirectories(DescribeDirectoriesIterable.this.firstRequest);
            }
            return DescribeDirectoriesIterable.this.client.describeDirectories((DescribeDirectoriesRequest)((Object)DescribeDirectoriesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

