/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.directory.DirectoryClient;
import software.amazon.awssdk.services.directory.internal.UserAgentUtils;
import software.amazon.awssdk.services.directory.model.ListLogSubscriptionsRequest;
import software.amazon.awssdk.services.directory.model.ListLogSubscriptionsResponse;
import software.amazon.awssdk.services.directory.model.LogSubscription;

public class ListLogSubscriptionsIterable
implements SdkIterable<ListLogSubscriptionsResponse> {
    private final DirectoryClient client;
    private final ListLogSubscriptionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLogSubscriptionsIterable(DirectoryClient client, ListLogSubscriptionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListLogSubscriptionsResponseFetcher();
    }

    public Iterator<ListLogSubscriptionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<LogSubscription> logSubscriptions() {
        Function<ListLogSubscriptionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.logSubscriptions() != null) {
                return response.logSubscriptions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListLogSubscriptionsResponseFetcher
    implements SyncPageFetcher<ListLogSubscriptionsResponse> {
        private ListLogSubscriptionsResponseFetcher() {
        }

        public boolean hasNextPage(ListLogSubscriptionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListLogSubscriptionsResponse nextPage(ListLogSubscriptionsResponse previousPage) {
            if (previousPage == null) {
                return ListLogSubscriptionsIterable.this.client.listLogSubscriptions(ListLogSubscriptionsIterable.this.firstRequest);
            }
            return ListLogSubscriptionsIterable.this.client.listLogSubscriptions((ListLogSubscriptionsRequest)((Object)ListLogSubscriptionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

