/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.directory.DirectoryClient;
import software.amazon.awssdk.services.directory.model.DescribeTrustsRequest;
import software.amazon.awssdk.services.directory.model.DescribeTrustsResponse;
import software.amazon.awssdk.services.directory.model.Trust;

public class DescribeTrustsIterable
implements SdkIterable<DescribeTrustsResponse> {
    private final DirectoryClient client;
    private final DescribeTrustsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeTrustsIterable(DirectoryClient client, DescribeTrustsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeTrustsResponseFetcher();
    }

    public Iterator<DescribeTrustsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Trust> trusts() {
        Function<DescribeTrustsResponse, Iterator> getIterator = response -> {
            if (response != null && response.trusts() != null) {
                return response.trusts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeTrustsResponseFetcher
    implements SyncPageFetcher<DescribeTrustsResponse> {
        private DescribeTrustsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTrustsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeTrustsResponse nextPage(DescribeTrustsResponse previousPage) {
            if (previousPage == null) {
                return DescribeTrustsIterable.this.client.describeTrusts(DescribeTrustsIterable.this.firstRequest);
            }
            return DescribeTrustsIterable.this.client.describeTrusts((DescribeTrustsRequest)((Object)DescribeTrustsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

