/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directory.model.DomainControllerStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DomainController
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DomainController> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryId").getter(DomainController.getter(DomainController::directoryId)).setter(DomainController.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()}).build();
    private static final SdkField<String> DOMAIN_CONTROLLER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainControllerId").getter(DomainController.getter(DomainController::domainControllerId)).setter(DomainController.setter(Builder::domainControllerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainControllerId").build()}).build();
    private static final SdkField<String> DNS_IP_ADDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DnsIpAddr").getter(DomainController.getter(DomainController::dnsIpAddr)).setter(DomainController.setter(Builder::dnsIpAddr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsIpAddr").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(DomainController.getter(DomainController::vpcId)).setter(DomainController.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(DomainController.getter(DomainController::subnetId)).setter(DomainController.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(DomainController.getter(DomainController::availabilityZone)).setter(DomainController.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DomainController.getter(DomainController::statusAsString)).setter(DomainController.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusReason").getter(DomainController.getter(DomainController::statusReason)).setter(DomainController.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()}).build();
    private static final SdkField<Instant> LAUNCH_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LaunchTime").getter(DomainController.getter(DomainController::launchTime)).setter(DomainController.setter(Builder::launchTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTime").build()}).build();
    private static final SdkField<Instant> STATUS_LAST_UPDATED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StatusLastUpdatedDateTime").getter(DomainController.getter(DomainController::statusLastUpdatedDateTime)).setter(DomainController.setter(Builder::statusLastUpdatedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusLastUpdatedDateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD, DOMAIN_CONTROLLER_ID_FIELD, DNS_IP_ADDR_FIELD, VPC_ID_FIELD, SUBNET_ID_FIELD, AVAILABILITY_ZONE_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, LAUNCH_TIME_FIELD, STATUS_LAST_UPDATED_DATE_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String directoryId;
    private final String domainControllerId;
    private final String dnsIpAddr;
    private final String vpcId;
    private final String subnetId;
    private final String availabilityZone;
    private final String status;
    private final String statusReason;
    private final Instant launchTime;
    private final Instant statusLastUpdatedDateTime;

    private DomainController(BuilderImpl builder) {
        this.directoryId = builder.directoryId;
        this.domainControllerId = builder.domainControllerId;
        this.dnsIpAddr = builder.dnsIpAddr;
        this.vpcId = builder.vpcId;
        this.subnetId = builder.subnetId;
        this.availabilityZone = builder.availabilityZone;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.launchTime = builder.launchTime;
        this.statusLastUpdatedDateTime = builder.statusLastUpdatedDateTime;
    }

    public final String directoryId() {
        return this.directoryId;
    }

    public final String domainControllerId() {
        return this.domainControllerId;
    }

    public final String dnsIpAddr() {
        return this.dnsIpAddr;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final String subnetId() {
        return this.subnetId;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final DomainControllerStatus status() {
        return DomainControllerStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final Instant launchTime() {
        return this.launchTime;
    }

    public final Instant statusLastUpdatedDateTime() {
        return this.statusLastUpdatedDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainControllerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsIpAddr());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusLastUpdatedDateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainController)) {
            return false;
        }
        DomainController other = (DomainController)obj;
        return Objects.equals(this.directoryId(), other.directoryId()) && Objects.equals(this.domainControllerId(), other.domainControllerId()) && Objects.equals(this.dnsIpAddr(), other.dnsIpAddr()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.launchTime(), other.launchTime()) && Objects.equals(this.statusLastUpdatedDateTime(), other.statusLastUpdatedDateTime());
    }

    public final String toString() {
        return ToString.builder((String)"DomainController").add("DirectoryId", (Object)this.directoryId()).add("DomainControllerId", (Object)this.domainControllerId()).add("DnsIpAddr", (Object)this.dnsIpAddr()).add("VpcId", (Object)this.vpcId()).add("SubnetId", (Object)this.subnetId()).add("AvailabilityZone", (Object)this.availabilityZone()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("LaunchTime", (Object)this.launchTime()).add("StatusLastUpdatedDateTime", (Object)this.statusLastUpdatedDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "DomainControllerId": {
                return Optional.ofNullable(clazz.cast(this.domainControllerId()));
            }
            case "DnsIpAddr": {
                return Optional.ofNullable(clazz.cast(this.dnsIpAddr()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "LaunchTime": {
                return Optional.ofNullable(clazz.cast(this.launchTime()));
            }
            case "StatusLastUpdatedDateTime": {
                return Optional.ofNullable(clazz.cast(this.statusLastUpdatedDateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainController, T> g) {
        return obj -> g.apply((DomainController)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String directoryId;
        private String domainControllerId;
        private String dnsIpAddr;
        private String vpcId;
        private String subnetId;
        private String availabilityZone;
        private String status;
        private String statusReason;
        private Instant launchTime;
        private Instant statusLastUpdatedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainController model) {
            this.directoryId(model.directoryId);
            this.domainControllerId(model.domainControllerId);
            this.dnsIpAddr(model.dnsIpAddr);
            this.vpcId(model.vpcId);
            this.subnetId(model.subnetId);
            this.availabilityZone(model.availabilityZone);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.launchTime(model.launchTime);
            this.statusLastUpdatedDateTime(model.statusLastUpdatedDateTime);
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getDomainControllerId() {
            return this.domainControllerId;
        }

        public final void setDomainControllerId(String domainControllerId) {
            this.domainControllerId = domainControllerId;
        }

        @Override
        public final Builder domainControllerId(String domainControllerId) {
            this.domainControllerId = domainControllerId;
            return this;
        }

        public final String getDnsIpAddr() {
            return this.dnsIpAddr;
        }

        public final void setDnsIpAddr(String dnsIpAddr) {
            this.dnsIpAddr = dnsIpAddr;
        }

        @Override
        public final Builder dnsIpAddr(String dnsIpAddr) {
            this.dnsIpAddr = dnsIpAddr;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DomainControllerStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Instant getLaunchTime() {
            return this.launchTime;
        }

        public final void setLaunchTime(Instant launchTime) {
            this.launchTime = launchTime;
        }

        @Override
        public final Builder launchTime(Instant launchTime) {
            this.launchTime = launchTime;
            return this;
        }

        public final Instant getStatusLastUpdatedDateTime() {
            return this.statusLastUpdatedDateTime;
        }

        public final void setStatusLastUpdatedDateTime(Instant statusLastUpdatedDateTime) {
            this.statusLastUpdatedDateTime = statusLastUpdatedDateTime;
        }

        @Override
        public final Builder statusLastUpdatedDateTime(Instant statusLastUpdatedDateTime) {
            this.statusLastUpdatedDateTime = statusLastUpdatedDateTime;
            return this;
        }

        public DomainController build() {
            return new DomainController(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DomainController> {
        public Builder directoryId(String var1);

        public Builder domainControllerId(String var1);

        public Builder dnsIpAddr(String var1);

        public Builder vpcId(String var1);

        public Builder subnetId(String var1);

        public Builder availabilityZone(String var1);

        public Builder status(String var1);

        public Builder status(DomainControllerStatus var1);

        public Builder statusReason(String var1);

        public Builder launchTime(Instant var1);

        public Builder statusLastUpdatedDateTime(Instant var1);
    }
}

