/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RegionType {
    PRIMARY("Primary"),
    ADDITIONAL("Additional"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RegionType> VALUE_MAP;
    private final String value;

    private RegionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RegionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RegionType> knownValues() {
        EnumSet<RegionType> knownValues = EnumSet.allOf(RegionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RegionType.class, RegionType::toString);
    }
}

