/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.directory.internal.DirectoryServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.directory.model.AcceptSharedDirectoryRequest;
import software.amazon.awssdk.services.directory.model.AcceptSharedDirectoryResponse;
import software.amazon.awssdk.services.directory.model.AccessDeniedException;
import software.amazon.awssdk.services.directory.model.AddIpRoutesRequest;
import software.amazon.awssdk.services.directory.model.AddIpRoutesResponse;
import software.amazon.awssdk.services.directory.model.AddRegionRequest;
import software.amazon.awssdk.services.directory.model.AddRegionResponse;
import software.amazon.awssdk.services.directory.model.AddTagsToResourceRequest;
import software.amazon.awssdk.services.directory.model.AddTagsToResourceResponse;
import software.amazon.awssdk.services.directory.model.AuthenticationFailedException;
import software.amazon.awssdk.services.directory.model.CancelSchemaExtensionRequest;
import software.amazon.awssdk.services.directory.model.CancelSchemaExtensionResponse;
import software.amazon.awssdk.services.directory.model.CertificateAlreadyExistsException;
import software.amazon.awssdk.services.directory.model.CertificateDoesNotExistException;
import software.amazon.awssdk.services.directory.model.CertificateInUseException;
import software.amazon.awssdk.services.directory.model.CertificateLimitExceededException;
import software.amazon.awssdk.services.directory.model.ClientException;
import software.amazon.awssdk.services.directory.model.ConnectDirectoryRequest;
import software.amazon.awssdk.services.directory.model.ConnectDirectoryResponse;
import software.amazon.awssdk.services.directory.model.CreateAliasRequest;
import software.amazon.awssdk.services.directory.model.CreateAliasResponse;
import software.amazon.awssdk.services.directory.model.CreateComputerRequest;
import software.amazon.awssdk.services.directory.model.CreateComputerResponse;
import software.amazon.awssdk.services.directory.model.CreateConditionalForwarderRequest;
import software.amazon.awssdk.services.directory.model.CreateConditionalForwarderResponse;
import software.amazon.awssdk.services.directory.model.CreateDirectoryRequest;
import software.amazon.awssdk.services.directory.model.CreateDirectoryResponse;
import software.amazon.awssdk.services.directory.model.CreateLogSubscriptionRequest;
import software.amazon.awssdk.services.directory.model.CreateLogSubscriptionResponse;
import software.amazon.awssdk.services.directory.model.CreateMicrosoftAdRequest;
import software.amazon.awssdk.services.directory.model.CreateMicrosoftAdResponse;
import software.amazon.awssdk.services.directory.model.CreateSnapshotRequest;
import software.amazon.awssdk.services.directory.model.CreateSnapshotResponse;
import software.amazon.awssdk.services.directory.model.CreateTrustRequest;
import software.amazon.awssdk.services.directory.model.CreateTrustResponse;
import software.amazon.awssdk.services.directory.model.DeleteConditionalForwarderRequest;
import software.amazon.awssdk.services.directory.model.DeleteConditionalForwarderResponse;
import software.amazon.awssdk.services.directory.model.DeleteDirectoryRequest;
import software.amazon.awssdk.services.directory.model.DeleteDirectoryResponse;
import software.amazon.awssdk.services.directory.model.DeleteLogSubscriptionRequest;
import software.amazon.awssdk.services.directory.model.DeleteLogSubscriptionResponse;
import software.amazon.awssdk.services.directory.model.DeleteSnapshotRequest;
import software.amazon.awssdk.services.directory.model.DeleteSnapshotResponse;
import software.amazon.awssdk.services.directory.model.DeleteTrustRequest;
import software.amazon.awssdk.services.directory.model.DeleteTrustResponse;
import software.amazon.awssdk.services.directory.model.DeregisterCertificateRequest;
import software.amazon.awssdk.services.directory.model.DeregisterCertificateResponse;
import software.amazon.awssdk.services.directory.model.DeregisterEventTopicRequest;
import software.amazon.awssdk.services.directory.model.DeregisterEventTopicResponse;
import software.amazon.awssdk.services.directory.model.DescribeCertificateRequest;
import software.amazon.awssdk.services.directory.model.DescribeCertificateResponse;
import software.amazon.awssdk.services.directory.model.DescribeClientAuthenticationSettingsRequest;
import software.amazon.awssdk.services.directory.model.DescribeClientAuthenticationSettingsResponse;
import software.amazon.awssdk.services.directory.model.DescribeConditionalForwardersRequest;
import software.amazon.awssdk.services.directory.model.DescribeConditionalForwardersResponse;
import software.amazon.awssdk.services.directory.model.DescribeDirectoriesRequest;
import software.amazon.awssdk.services.directory.model.DescribeDirectoriesResponse;
import software.amazon.awssdk.services.directory.model.DescribeDomainControllersRequest;
import software.amazon.awssdk.services.directory.model.DescribeDomainControllersResponse;
import software.amazon.awssdk.services.directory.model.DescribeEventTopicsRequest;
import software.amazon.awssdk.services.directory.model.DescribeEventTopicsResponse;
import software.amazon.awssdk.services.directory.model.DescribeLdapsSettingsRequest;
import software.amazon.awssdk.services.directory.model.DescribeLdapsSettingsResponse;
import software.amazon.awssdk.services.directory.model.DescribeRegionsRequest;
import software.amazon.awssdk.services.directory.model.DescribeRegionsResponse;
import software.amazon.awssdk.services.directory.model.DescribeSettingsRequest;
import software.amazon.awssdk.services.directory.model.DescribeSettingsResponse;
import software.amazon.awssdk.services.directory.model.DescribeSharedDirectoriesRequest;
import software.amazon.awssdk.services.directory.model.DescribeSharedDirectoriesResponse;
import software.amazon.awssdk.services.directory.model.DescribeSnapshotsRequest;
import software.amazon.awssdk.services.directory.model.DescribeSnapshotsResponse;
import software.amazon.awssdk.services.directory.model.DescribeTrustsRequest;
import software.amazon.awssdk.services.directory.model.DescribeTrustsResponse;
import software.amazon.awssdk.services.directory.model.DescribeUpdateDirectoryRequest;
import software.amazon.awssdk.services.directory.model.DescribeUpdateDirectoryResponse;
import software.amazon.awssdk.services.directory.model.DirectoryAlreadyInRegionException;
import software.amazon.awssdk.services.directory.model.DirectoryAlreadySharedException;
import software.amazon.awssdk.services.directory.model.DirectoryDoesNotExistException;
import software.amazon.awssdk.services.directory.model.DirectoryException;
import software.amazon.awssdk.services.directory.model.DirectoryInDesiredStateException;
import software.amazon.awssdk.services.directory.model.DirectoryLimitExceededException;
import software.amazon.awssdk.services.directory.model.DirectoryNotSharedException;
import software.amazon.awssdk.services.directory.model.DirectoryUnavailableException;
import software.amazon.awssdk.services.directory.model.DisableClientAuthenticationRequest;
import software.amazon.awssdk.services.directory.model.DisableClientAuthenticationResponse;
import software.amazon.awssdk.services.directory.model.DisableLdapsRequest;
import software.amazon.awssdk.services.directory.model.DisableLdapsResponse;
import software.amazon.awssdk.services.directory.model.DisableRadiusRequest;
import software.amazon.awssdk.services.directory.model.DisableRadiusResponse;
import software.amazon.awssdk.services.directory.model.DisableSsoRequest;
import software.amazon.awssdk.services.directory.model.DisableSsoResponse;
import software.amazon.awssdk.services.directory.model.DomainControllerLimitExceededException;
import software.amazon.awssdk.services.directory.model.EnableClientAuthenticationRequest;
import software.amazon.awssdk.services.directory.model.EnableClientAuthenticationResponse;
import software.amazon.awssdk.services.directory.model.EnableLdapsRequest;
import software.amazon.awssdk.services.directory.model.EnableLdapsResponse;
import software.amazon.awssdk.services.directory.model.EnableRadiusRequest;
import software.amazon.awssdk.services.directory.model.EnableRadiusResponse;
import software.amazon.awssdk.services.directory.model.EnableSsoRequest;
import software.amazon.awssdk.services.directory.model.EnableSsoResponse;
import software.amazon.awssdk.services.directory.model.EntityAlreadyExistsException;
import software.amazon.awssdk.services.directory.model.EntityDoesNotExistException;
import software.amazon.awssdk.services.directory.model.GetDirectoryLimitsRequest;
import software.amazon.awssdk.services.directory.model.GetDirectoryLimitsResponse;
import software.amazon.awssdk.services.directory.model.GetSnapshotLimitsRequest;
import software.amazon.awssdk.services.directory.model.GetSnapshotLimitsResponse;
import software.amazon.awssdk.services.directory.model.IncompatibleSettingsException;
import software.amazon.awssdk.services.directory.model.InsufficientPermissionsException;
import software.amazon.awssdk.services.directory.model.InvalidCertificateException;
import software.amazon.awssdk.services.directory.model.InvalidClientAuthStatusException;
import software.amazon.awssdk.services.directory.model.InvalidLdapsStatusException;
import software.amazon.awssdk.services.directory.model.InvalidNextTokenException;
import software.amazon.awssdk.services.directory.model.InvalidParameterException;
import software.amazon.awssdk.services.directory.model.InvalidPasswordException;
import software.amazon.awssdk.services.directory.model.InvalidTargetException;
import software.amazon.awssdk.services.directory.model.IpRouteLimitExceededException;
import software.amazon.awssdk.services.directory.model.ListCertificatesRequest;
import software.amazon.awssdk.services.directory.model.ListCertificatesResponse;
import software.amazon.awssdk.services.directory.model.ListIpRoutesRequest;
import software.amazon.awssdk.services.directory.model.ListIpRoutesResponse;
import software.amazon.awssdk.services.directory.model.ListLogSubscriptionsRequest;
import software.amazon.awssdk.services.directory.model.ListLogSubscriptionsResponse;
import software.amazon.awssdk.services.directory.model.ListSchemaExtensionsRequest;
import software.amazon.awssdk.services.directory.model.ListSchemaExtensionsResponse;
import software.amazon.awssdk.services.directory.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.directory.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.directory.model.NoAvailableCertificateException;
import software.amazon.awssdk.services.directory.model.OrganizationsException;
import software.amazon.awssdk.services.directory.model.RegionLimitExceededException;
import software.amazon.awssdk.services.directory.model.RegisterCertificateRequest;
import software.amazon.awssdk.services.directory.model.RegisterCertificateResponse;
import software.amazon.awssdk.services.directory.model.RegisterEventTopicRequest;
import software.amazon.awssdk.services.directory.model.RegisterEventTopicResponse;
import software.amazon.awssdk.services.directory.model.RejectSharedDirectoryRequest;
import software.amazon.awssdk.services.directory.model.RejectSharedDirectoryResponse;
import software.amazon.awssdk.services.directory.model.RemoveIpRoutesRequest;
import software.amazon.awssdk.services.directory.model.RemoveIpRoutesResponse;
import software.amazon.awssdk.services.directory.model.RemoveRegionRequest;
import software.amazon.awssdk.services.directory.model.RemoveRegionResponse;
import software.amazon.awssdk.services.directory.model.RemoveTagsFromResourceRequest;
import software.amazon.awssdk.services.directory.model.RemoveTagsFromResourceResponse;
import software.amazon.awssdk.services.directory.model.ResetUserPasswordRequest;
import software.amazon.awssdk.services.directory.model.ResetUserPasswordResponse;
import software.amazon.awssdk.services.directory.model.RestoreFromSnapshotRequest;
import software.amazon.awssdk.services.directory.model.RestoreFromSnapshotResponse;
import software.amazon.awssdk.services.directory.model.ServiceException;
import software.amazon.awssdk.services.directory.model.ShareDirectoryRequest;
import software.amazon.awssdk.services.directory.model.ShareDirectoryResponse;
import software.amazon.awssdk.services.directory.model.ShareLimitExceededException;
import software.amazon.awssdk.services.directory.model.SnapshotLimitExceededException;
import software.amazon.awssdk.services.directory.model.StartSchemaExtensionRequest;
import software.amazon.awssdk.services.directory.model.StartSchemaExtensionResponse;
import software.amazon.awssdk.services.directory.model.TagLimitExceededException;
import software.amazon.awssdk.services.directory.model.UnshareDirectoryRequest;
import software.amazon.awssdk.services.directory.model.UnshareDirectoryResponse;
import software.amazon.awssdk.services.directory.model.UnsupportedOperationException;
import software.amazon.awssdk.services.directory.model.UnsupportedSettingsException;
import software.amazon.awssdk.services.directory.model.UpdateConditionalForwarderRequest;
import software.amazon.awssdk.services.directory.model.UpdateConditionalForwarderResponse;
import software.amazon.awssdk.services.directory.model.UpdateDirectorySetupRequest;
import software.amazon.awssdk.services.directory.model.UpdateDirectorySetupResponse;
import software.amazon.awssdk.services.directory.model.UpdateNumberOfDomainControllersRequest;
import software.amazon.awssdk.services.directory.model.UpdateNumberOfDomainControllersResponse;
import software.amazon.awssdk.services.directory.model.UpdateRadiusRequest;
import software.amazon.awssdk.services.directory.model.UpdateRadiusResponse;
import software.amazon.awssdk.services.directory.model.UpdateSettingsRequest;
import software.amazon.awssdk.services.directory.model.UpdateSettingsResponse;
import software.amazon.awssdk.services.directory.model.UpdateTrustRequest;
import software.amazon.awssdk.services.directory.model.UpdateTrustResponse;
import software.amazon.awssdk.services.directory.model.UserDoesNotExistException;
import software.amazon.awssdk.services.directory.model.VerifyTrustRequest;
import software.amazon.awssdk.services.directory.model.VerifyTrustResponse;
import software.amazon.awssdk.services.directory.transform.AcceptSharedDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.AddIpRoutesRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.AddRegionRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.AddTagsToResourceRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CancelSchemaExtensionRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ConnectDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateAliasRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateComputerRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateConditionalForwarderRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateLogSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateMicrosoftAdRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateSnapshotRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateTrustRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DeleteConditionalForwarderRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DeleteDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DeleteLogSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DeleteSnapshotRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DeleteTrustRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DeregisterCertificateRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DeregisterEventTopicRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeCertificateRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeClientAuthenticationSettingsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeConditionalForwardersRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeDirectoriesRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeDomainControllersRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeEventTopicsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeLdapsSettingsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeRegionsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeSettingsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeSharedDirectoriesRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeTrustsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeUpdateDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DisableClientAuthenticationRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DisableLdapsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DisableRadiusRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DisableSsoRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.EnableClientAuthenticationRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.EnableLdapsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.EnableRadiusRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.EnableSsoRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.GetDirectoryLimitsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.GetSnapshotLimitsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ListCertificatesRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ListIpRoutesRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ListLogSubscriptionsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ListSchemaExtensionsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.RegisterCertificateRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.RegisterEventTopicRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.RejectSharedDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.RemoveIpRoutesRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.RemoveRegionRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.RemoveTagsFromResourceRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ResetUserPasswordRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.RestoreFromSnapshotRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ShareDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.StartSchemaExtensionRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.UnshareDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.UpdateConditionalForwarderRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.UpdateDirectorySetupRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.UpdateNumberOfDomainControllersRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.UpdateRadiusRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.UpdateSettingsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.UpdateTrustRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.VerifyTrustRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link DirectoryAsyncClient}.
 *
 * @see DirectoryAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultDirectoryAsyncClient implements DirectoryAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultDirectoryAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.AWS_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultDirectoryAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Accepts a directory sharing request that was sent from the directory owner account.
     * </p>
     *
     * @param acceptSharedDirectoryRequest
     * @return A Java Future containing the result of the AcceptSharedDirectory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>DirectoryAlreadySharedException The specified directory has already been shared with this Amazon Web
     *         Services account.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.AcceptSharedDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/AcceptSharedDirectory" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AcceptSharedDirectoryResponse> acceptSharedDirectory(
            AcceptSharedDirectoryRequest acceptSharedDirectoryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(acceptSharedDirectoryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, acceptSharedDirectoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AcceptSharedDirectory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AcceptSharedDirectoryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AcceptSharedDirectoryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AcceptSharedDirectoryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AcceptSharedDirectoryRequest, AcceptSharedDirectoryResponse>()
                            .withOperationName("AcceptSharedDirectory").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AcceptSharedDirectoryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(acceptSharedDirectoryRequest));
            CompletableFuture<AcceptSharedDirectoryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * If the DNS server for your self-managed domain uses a publicly addressable IP address, you must add a CIDR
     * address block to correctly route traffic to and from your Microsoft AD on Amazon Web Services. <i>AddIpRoutes</i>
     * adds this address block. You can also use <i>AddIpRoutes</i> to facilitate routing traffic that uses public IP
     * ranges from your Microsoft AD on Amazon Web Services to a peer VPC.
     * </p>
     * <p>
     * Before you call <i>AddIpRoutes</i>, ensure that all of the required permissions have been explicitly granted
     * through a policy. For details about what permissions are required to run the <i>AddIpRoutes</i> operation, see <a
     * href="http://docs.aws.amazon.com/directoryservice/latest/admin-guide/UsingWithDS_IAM_ResourcePermissions.html">
     * Directory Service API Permissions: Actions, Resources, and Conditions Reference</a>.
     * </p>
     *
     * @param addIpRoutesRequest
     * @return A Java Future containing the result of the AddIpRoutes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>EntityAlreadyExistsException The specified entity already exists.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>IpRouteLimitExceededException The maximum allowed number of IP addresses was exceeded. The default
     *         limit is 100 IP address blocks.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.AddIpRoutes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/AddIpRoutes" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AddIpRoutesResponse> addIpRoutes(AddIpRoutesRequest addIpRoutesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addIpRoutesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addIpRoutesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddIpRoutes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AddIpRoutesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    AddIpRoutesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AddIpRoutesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AddIpRoutesRequest, AddIpRoutesResponse>()
                            .withOperationName("AddIpRoutes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AddIpRoutesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(addIpRoutesRequest));
            CompletableFuture<AddIpRoutesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds two domain controllers in the specified Region for the specified directory.
     * </p>
     *
     * @param addRegionRequest
     * @return A Java Future containing the result of the AddRegion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>DirectoryAlreadyInRegionException The Region you specified is the same Region where the Managed
     *         Microsoft AD directory was created. Specify a different Region and try again.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>RegionLimitExceededException You have reached the limit for maximum number of simultaneous Region
     *         replications per directory.</li>
     *         <li>AccessDeniedException Client authentication is not available in this region at this time.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.AddRegion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/AddRegion" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AddRegionResponse> addRegion(AddRegionRequest addRegionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addRegionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addRegionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddRegion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AddRegionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    AddRegionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AddRegionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AddRegionRequest, AddRegionResponse>().withOperationName("AddRegion")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AddRegionRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(addRegionRequest));
            CompletableFuture<AddRegionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds or overwrites one or more tags for the specified directory. Each directory can have a maximum of 50 tags.
     * Each tag consists of a key and optional value. Tag keys must be unique to each resource.
     * </p>
     *
     * @param addTagsToResourceRequest
     * @return A Java Future containing the result of the AddTagsToResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>TagLimitExceededException The maximum allowed number of tags was exceeded.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.AddTagsToResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/AddTagsToResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AddTagsToResourceResponse> addTagsToResource(AddTagsToResourceRequest addTagsToResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addTagsToResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addTagsToResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddTagsToResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AddTagsToResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AddTagsToResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AddTagsToResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AddTagsToResourceRequest, AddTagsToResourceResponse>()
                            .withOperationName("AddTagsToResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AddTagsToResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(addTagsToResourceRequest));
            CompletableFuture<AddTagsToResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels an in-progress schema extension to a Microsoft AD directory. Once a schema extension has started
     * replicating to all domain controllers, the task can no longer be canceled. A schema extension can be canceled
     * during any of the following states; <code>Initializing</code>, <code>CreatingSnapshot</code>, and
     * <code>UpdatingSchema</code>.
     * </p>
     *
     * @param cancelSchemaExtensionRequest
     * @return A Java Future containing the result of the CancelSchemaExtension operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.CancelSchemaExtension
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CancelSchemaExtension" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CancelSchemaExtensionResponse> cancelSchemaExtension(
            CancelSchemaExtensionRequest cancelSchemaExtensionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelSchemaExtensionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelSchemaExtensionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelSchemaExtension");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CancelSchemaExtensionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CancelSchemaExtensionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CancelSchemaExtensionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelSchemaExtensionRequest, CancelSchemaExtensionResponse>()
                            .withOperationName("CancelSchemaExtension").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CancelSchemaExtensionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(cancelSchemaExtensionRequest));
            CompletableFuture<CancelSchemaExtensionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an AD Connector to connect to a self-managed directory.
     * </p>
     * <p>
     * Before you call <code>ConnectDirectory</code>, ensure that all of the required permissions have been explicitly
     * granted through a policy. For details about what permissions are required to run the
     * <code>ConnectDirectory</code> operation, see <a
     * href="http://docs.aws.amazon.com/directoryservice/latest/admin-guide/UsingWithDS_IAM_ResourcePermissions.html"
     * >Directory Service API Permissions: Actions, Resources, and Conditions Reference</a>.
     * </p>
     *
     * @param connectDirectoryRequest
     *        Contains the inputs for the <a>ConnectDirectory</a> operation.
     * @return A Java Future containing the result of the ConnectDirectory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectoryLimitExceededException The maximum number of directories in the region has been reached. You
     *         can use the <a>GetDirectoryLimits</a> operation to determine your directory limits in the region.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.ConnectDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ConnectDirectory" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ConnectDirectoryResponse> connectDirectory(ConnectDirectoryRequest connectDirectoryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(connectDirectoryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, connectDirectoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ConnectDirectory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ConnectDirectoryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ConnectDirectoryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ConnectDirectoryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ConnectDirectoryRequest, ConnectDirectoryResponse>()
                            .withOperationName("ConnectDirectory").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ConnectDirectoryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(connectDirectoryRequest));
            CompletableFuture<ConnectDirectoryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an alias for a directory and assigns the alias to the directory. The alias is used to construct the
     * access URL for the directory, such as <code>http://&lt;alias&gt;.awsapps.com</code>.
     * </p>
     * <important>
     * <p>
     * After an alias has been created, it cannot be deleted or reused, so this operation should only be used when
     * absolutely necessary.
     * </p>
     * </important>
     *
     * @param createAliasRequest
     *        Contains the inputs for the <a>CreateAlias</a> operation.
     * @return A Java Future containing the result of the CreateAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityAlreadyExistsException The specified entity already exists.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.CreateAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateAlias" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAliasResponse> createAlias(CreateAliasRequest createAliasRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAliasRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAlias");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAliasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateAliasResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateAliasResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAliasRequest, CreateAliasResponse>()
                            .withOperationName("CreateAlias").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateAliasRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createAliasRequest));
            CompletableFuture<CreateAliasResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Active Directory computer object in the specified directory.
     * </p>
     *
     * @param createComputerRequest
     *        Contains the inputs for the <a>CreateComputer</a> operation.
     * @return A Java Future containing the result of the CreateComputer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AuthenticationFailedException An authentication error occurred.</li>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>EntityAlreadyExistsException The specified entity already exists.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.CreateComputer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateComputer" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateComputerResponse> createComputer(CreateComputerRequest createComputerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createComputerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createComputerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateComputer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateComputerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateComputerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateComputerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateComputerRequest, CreateComputerResponse>()
                            .withOperationName("CreateComputer").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateComputerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createComputerRequest));
            CompletableFuture<CreateComputerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a conditional forwarder associated with your Amazon Web Services directory. Conditional forwarders are
     * required in order to set up a trust relationship with another domain. The conditional forwarder points to the
     * trusted domain.
     * </p>
     *
     * @param createConditionalForwarderRequest
     *        Initiates the creation of a conditional forwarder for your Directory Service for Microsoft Active
     *        Directory. Conditional forwarders are required in order to set up a trust relationship with another
     *        domain.
     * @return A Java Future containing the result of the CreateConditionalForwarder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityAlreadyExistsException The specified entity already exists.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.CreateConditionalForwarder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateConditionalForwarder" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateConditionalForwarderResponse> createConditionalForwarder(
            CreateConditionalForwarderRequest createConditionalForwarderRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createConditionalForwarderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createConditionalForwarderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateConditionalForwarder");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateConditionalForwarderResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateConditionalForwarderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateConditionalForwarderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateConditionalForwarderRequest, CreateConditionalForwarderResponse>()
                            .withOperationName("CreateConditionalForwarder").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateConditionalForwarderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createConditionalForwarderRequest));
            CompletableFuture<CreateConditionalForwarderResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a Simple AD directory. For more information, see <a
     * href="https://docs.aws.amazon.com/directoryservice/latest/admin-guide/directory_simple_ad.html">Simple Active
     * Directory</a> in the <i>Directory Service Admin Guide</i>.
     * </p>
     * <p>
     * Before you call <code>CreateDirectory</code>, ensure that all of the required permissions have been explicitly
     * granted through a policy. For details about what permissions are required to run the <code>CreateDirectory</code>
     * operation, see <a
     * href="http://docs.aws.amazon.com/directoryservice/latest/admin-guide/UsingWithDS_IAM_ResourcePermissions.html"
     * >Directory Service API Permissions: Actions, Resources, and Conditions Reference</a>.
     * </p>
     *
     * @param createDirectoryRequest
     *        Contains the inputs for the <a>CreateDirectory</a> operation.
     * @return A Java Future containing the result of the CreateDirectory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectoryLimitExceededException The maximum number of directories in the region has been reached. You
     *         can use the <a>GetDirectoryLimits</a> operation to determine your directory limits in the region.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.CreateDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateDirectory" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDirectoryResponse> createDirectory(CreateDirectoryRequest createDirectoryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDirectoryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDirectoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDirectory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDirectoryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDirectoryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDirectoryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDirectoryRequest, CreateDirectoryResponse>()
                            .withOperationName("CreateDirectory").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateDirectoryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createDirectoryRequest));
            CompletableFuture<CreateDirectoryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a subscription to forward real-time Directory Service domain controller security logs to the specified
     * Amazon CloudWatch log group in your Amazon Web Services account.
     * </p>
     *
     * @param createLogSubscriptionRequest
     * @return A Java Future containing the result of the CreateLogSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityAlreadyExistsException The specified entity already exists.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>InsufficientPermissionsException The account does not have sufficient permission to perform the
     *         operation.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.CreateLogSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateLogSubscription" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateLogSubscriptionResponse> createLogSubscription(
            CreateLogSubscriptionRequest createLogSubscriptionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createLogSubscriptionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createLogSubscriptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateLogSubscription");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateLogSubscriptionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateLogSubscriptionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateLogSubscriptionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateLogSubscriptionRequest, CreateLogSubscriptionResponse>()
                            .withOperationName("CreateLogSubscription").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateLogSubscriptionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createLogSubscriptionRequest));
            CompletableFuture<CreateLogSubscriptionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a Microsoft AD directory in the Amazon Web Services Cloud. For more information, see <a
     * href="https://docs.aws.amazon.com/directoryservice/latest/admin-guide/directory_microsoft_ad.html">Managed
     * Microsoft AD</a> in the <i>Directory Service Admin Guide</i>.
     * </p>
     * <p>
     * Before you call <i>CreateMicrosoftAD</i>, ensure that all of the required permissions have been explicitly
     * granted through a policy. For details about what permissions are required to run the <i>CreateMicrosoftAD</i>
     * operation, see <a
     * href="http://docs.aws.amazon.com/directoryservice/latest/admin-guide/UsingWithDS_IAM_ResourcePermissions.html"
     * >Directory Service API Permissions: Actions, Resources, and Conditions Reference</a>.
     * </p>
     *
     * @param createMicrosoftAdRequest
     *        Creates an Managed Microsoft AD directory.
     * @return A Java Future containing the result of the CreateMicrosoftAD operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectoryLimitExceededException The maximum number of directories in the region has been reached. You
     *         can use the <a>GetDirectoryLimits</a> operation to determine your directory limits in the region.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.CreateMicrosoftAD
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateMicrosoftAD" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateMicrosoftAdResponse> createMicrosoftAD(CreateMicrosoftAdRequest createMicrosoftAdRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createMicrosoftAdRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMicrosoftAdRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMicrosoftAD");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateMicrosoftAdResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateMicrosoftAdResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateMicrosoftAdResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateMicrosoftAdRequest, CreateMicrosoftAdResponse>()
                            .withOperationName("CreateMicrosoftAD").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateMicrosoftAdRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createMicrosoftAdRequest));
            CompletableFuture<CreateMicrosoftAdResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a snapshot of a Simple AD or Microsoft AD directory in the Amazon Web Services cloud.
     * </p>
     * <note>
     * <p>
     * You cannot take snapshots of AD Connector directories.
     * </p>
     * </note>
     *
     * @param createSnapshotRequest
     *        Contains the inputs for the <a>CreateSnapshot</a> operation.
     * @return A Java Future containing the result of the CreateSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>SnapshotLimitExceededException The maximum number of manual snapshots for the directory has been
     *         reached. You can use the <a>GetSnapshotLimits</a> operation to determine the snapshot limits for a
     *         directory.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.CreateSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSnapshotResponse> createSnapshot(CreateSnapshotRequest createSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSnapshotRequest, CreateSnapshotResponse>()
                            .withOperationName("CreateSnapshot").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createSnapshotRequest));
            CompletableFuture<CreateSnapshotResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Directory Service for Microsoft Active Directory allows you to configure trust relationships. For example, you
     * can establish a trust between your Managed Microsoft AD directory, and your existing self-managed Microsoft
     * Active Directory. This would allow you to provide users and groups access to resources in either domain, with a
     * single set of credentials.
     * </p>
     * <p>
     * This action initiates the creation of the Amazon Web Services side of a trust relationship between an Managed
     * Microsoft AD directory and an external domain. You can create either a forest trust or an external trust.
     * </p>
     *
     * @param createTrustRequest
     *        Directory Service for Microsoft Active Directory allows you to configure trust relationships. For example,
     *        you can establish a trust between your Managed Microsoft AD directory, and your existing self-managed
     *        Microsoft Active Directory. This would allow you to provide users and groups access to resources in either
     *        domain, with a single set of credentials.</p>
     *        <p>
     *        This action initiates the creation of the Amazon Web Services side of a trust relationship between an
     *        Managed Microsoft AD directory and an external domain.
     * @return A Java Future containing the result of the CreateTrust operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityAlreadyExistsException The specified entity already exists.</li> <li>
     *         EntityDoesNotExistException The specified entity could not be found.</li> <li>InvalidParameterException
     *         One or more parameters are not valid.</li> <li>ClientException A client exception has occurred.</li> <li>
     *         ServiceException An exception has occurred in Directory Service.</li> <li>UnsupportedOperationException
     *         The operation is not supported.</li> <li>SdkException Base class for all exceptions that can be thrown by
     *         the SDK (both service and client). Can be used for catch all scenarios.</li> <li>SdkClientException If
     *         any client side error occurs such as an IO related failure, failure to get credentials, etc.</li> <li>
     *         DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.CreateTrust
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateTrust" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTrustResponse> createTrust(CreateTrustRequest createTrustRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTrustRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTrustRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTrust");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateTrustResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateTrustResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateTrustResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTrustRequest, CreateTrustResponse>()
                            .withOperationName("CreateTrust").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateTrustRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createTrustRequest));
            CompletableFuture<CreateTrustResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a conditional forwarder that has been set up for your Amazon Web Services directory.
     * </p>
     *
     * @param deleteConditionalForwarderRequest
     *        Deletes a conditional forwarder.
     * @return A Java Future containing the result of the DeleteConditionalForwarder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DeleteConditionalForwarder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeleteConditionalForwarder" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteConditionalForwarderResponse> deleteConditionalForwarder(
            DeleteConditionalForwarderRequest deleteConditionalForwarderRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteConditionalForwarderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteConditionalForwarderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteConditionalForwarder");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteConditionalForwarderResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteConditionalForwarderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteConditionalForwarderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteConditionalForwarderRequest, DeleteConditionalForwarderResponse>()
                            .withOperationName("DeleteConditionalForwarder").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteConditionalForwarderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteConditionalForwarderRequest));
            CompletableFuture<DeleteConditionalForwarderResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an Directory Service directory.
     * </p>
     * <p>
     * Before you call <code>DeleteDirectory</code>, ensure that all of the required permissions have been explicitly
     * granted through a policy. For details about what permissions are required to run the <code>DeleteDirectory</code>
     * operation, see <a
     * href="http://docs.aws.amazon.com/directoryservice/latest/admin-guide/UsingWithDS_IAM_ResourcePermissions.html"
     * >Directory Service API Permissions: Actions, Resources, and Conditions Reference</a>.
     * </p>
     *
     * @param deleteDirectoryRequest
     *        Contains the inputs for the <a>DeleteDirectory</a> operation.
     * @return A Java Future containing the result of the DeleteDirectory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DeleteDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeleteDirectory" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDirectoryResponse> deleteDirectory(DeleteDirectoryRequest deleteDirectoryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDirectoryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDirectoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDirectory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDirectoryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDirectoryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDirectoryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDirectoryRequest, DeleteDirectoryResponse>()
                            .withOperationName("DeleteDirectory").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteDirectoryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteDirectoryRequest));
            CompletableFuture<DeleteDirectoryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified log subscription.
     * </p>
     *
     * @param deleteLogSubscriptionRequest
     * @return A Java Future containing the result of the DeleteLogSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DeleteLogSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeleteLogSubscription" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteLogSubscriptionResponse> deleteLogSubscription(
            DeleteLogSubscriptionRequest deleteLogSubscriptionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteLogSubscriptionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteLogSubscriptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteLogSubscription");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteLogSubscriptionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteLogSubscriptionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteLogSubscriptionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteLogSubscriptionRequest, DeleteLogSubscriptionResponse>()
                            .withOperationName("DeleteLogSubscription").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteLogSubscriptionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteLogSubscriptionRequest));
            CompletableFuture<DeleteLogSubscriptionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a directory snapshot.
     * </p>
     *
     * @param deleteSnapshotRequest
     *        Contains the inputs for the <a>DeleteSnapshot</a> operation.
     * @return A Java Future containing the result of the DeleteSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DeleteSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeleteSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSnapshotResponse> deleteSnapshot(DeleteSnapshotRequest deleteSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteSnapshotRequest, DeleteSnapshotResponse>()
                            .withOperationName("DeleteSnapshot").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteSnapshotRequest));
            CompletableFuture<DeleteSnapshotResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an existing trust relationship between your Managed Microsoft AD directory and an external domain.
     * </p>
     *
     * @param deleteTrustRequest
     *        Deletes the local side of an existing trust relationship between the Managed Microsoft AD directory and
     *        the external domain.
     * @return A Java Future containing the result of the DeleteTrust operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DeleteTrust
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeleteTrust" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTrustResponse> deleteTrust(DeleteTrustRequest deleteTrustRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTrustRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTrustRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTrust");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteTrustResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteTrustResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteTrustResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTrustRequest, DeleteTrustResponse>()
                            .withOperationName("DeleteTrust").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteTrustRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteTrustRequest));
            CompletableFuture<DeleteTrustResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes from the system the certificate that was registered for secure LDAP or client certificate authentication.
     * </p>
     *
     * @param deregisterCertificateRequest
     * @return A Java Future containing the result of the DeregisterCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>CertificateDoesNotExistException The certificate is not present in the system for describe or
     *         deregister activities.</li>
     *         <li>CertificateInUseException The certificate is being used for the LDAP security connection and cannot
     *         be removed without disabling LDAP security.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DeregisterCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeregisterCertificate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeregisterCertificateResponse> deregisterCertificate(
            DeregisterCertificateRequest deregisterCertificateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deregisterCertificateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deregisterCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeregisterCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeregisterCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeregisterCertificateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeregisterCertificateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeregisterCertificateRequest, DeregisterCertificateResponse>()
                            .withOperationName("DeregisterCertificate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeregisterCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deregisterCertificateRequest));
            CompletableFuture<DeregisterCertificateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the specified directory as a publisher to the specified Amazon SNS topic.
     * </p>
     *
     * @param deregisterEventTopicRequest
     *        Removes the specified directory as a publisher to the specified Amazon SNS topic.
     * @return A Java Future containing the result of the DeregisterEventTopic operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DeregisterEventTopic
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeregisterEventTopic" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeregisterEventTopicResponse> deregisterEventTopic(
            DeregisterEventTopicRequest deregisterEventTopicRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deregisterEventTopicRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deregisterEventTopicRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeregisterEventTopic");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeregisterEventTopicResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeregisterEventTopicResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeregisterEventTopicResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeregisterEventTopicRequest, DeregisterEventTopicResponse>()
                            .withOperationName("DeregisterEventTopic").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeregisterEventTopicRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deregisterEventTopicRequest));
            CompletableFuture<DeregisterEventTopicResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Displays information about the certificate registered for secure LDAP or client certificate authentication.
     * </p>
     *
     * @param describeCertificateRequest
     * @return A Java Future containing the result of the DescribeCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>CertificateDoesNotExistException The certificate is not present in the system for describe or
     *         deregister activities.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeCertificate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeCertificateResponse> describeCertificate(
            DescribeCertificateRequest describeCertificateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeCertificateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeCertificateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeCertificateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeCertificateRequest, DescribeCertificateResponse>()
                            .withOperationName("DescribeCertificate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeCertificateRequest));
            CompletableFuture<DescribeCertificateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the type of client authentication for the specified directory, if the type is
     * specified. If no type is specified, information about all client authentication types that are supported for the
     * specified directory is retrieved. Currently, only <code>SmartCard</code> is supported.
     * </p>
     *
     * @param describeClientAuthenticationSettingsRequest
     * @return A Java Future containing the result of the DescribeClientAuthenticationSettings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>AccessDeniedException Client authentication is not available in this region at this time.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeClientAuthenticationSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeClientAuthenticationSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeClientAuthenticationSettingsResponse> describeClientAuthenticationSettings(
            DescribeClientAuthenticationSettingsRequest describeClientAuthenticationSettingsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeClientAuthenticationSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeClientAuthenticationSettingsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeClientAuthenticationSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeClientAuthenticationSettingsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeClientAuthenticationSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeClientAuthenticationSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeClientAuthenticationSettingsRequest, DescribeClientAuthenticationSettingsResponse>()
                            .withOperationName("DescribeClientAuthenticationSettings").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeClientAuthenticationSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeClientAuthenticationSettingsRequest));
            CompletableFuture<DescribeClientAuthenticationSettingsResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Obtains information about the conditional forwarders for this account.
     * </p>
     * <p>
     * If no input parameters are provided for RemoteDomainNames, this request describes all conditional forwarders for
     * the specified directory ID.
     * </p>
     *
     * @param describeConditionalForwardersRequest
     *        Describes a conditional forwarder.
     * @return A Java Future containing the result of the DescribeConditionalForwarders operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeConditionalForwarders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeConditionalForwarders"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeConditionalForwardersResponse> describeConditionalForwarders(
            DescribeConditionalForwardersRequest describeConditionalForwardersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeConditionalForwardersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeConditionalForwardersRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeConditionalForwarders");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeConditionalForwardersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeConditionalForwardersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeConditionalForwardersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeConditionalForwardersRequest, DescribeConditionalForwardersResponse>()
                            .withOperationName("DescribeConditionalForwarders").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeConditionalForwardersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeConditionalForwardersRequest));
            CompletableFuture<DescribeConditionalForwardersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Obtains information about the directories that belong to this account.
     * </p>
     * <p>
     * You can retrieve information about specific directories by passing the directory identifiers in the
     * <code>DirectoryIds</code> parameter. Otherwise, all directories that belong to the current account are returned.
     * </p>
     * <p>
     * This operation supports pagination with the use of the <code>NextToken</code> request and response parameters. If
     * more results are available, the <code>DescribeDirectoriesResult.NextToken</code> member contains a token that you
     * pass in the next call to <a>DescribeDirectories</a> to retrieve the next set of items.
     * </p>
     * <p>
     * You can also specify a maximum number of return results with the <code>Limit</code> parameter.
     * </p>
     *
     * @param describeDirectoriesRequest
     *        Contains the inputs for the <a>DescribeDirectories</a> operation.
     * @return A Java Future containing the result of the DescribeDirectories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeDirectories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeDirectories" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDirectoriesResponse> describeDirectories(
            DescribeDirectoriesRequest describeDirectoriesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDirectoriesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDirectoriesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDirectories");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDirectoriesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeDirectoriesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeDirectoriesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDirectoriesRequest, DescribeDirectoriesResponse>()
                            .withOperationName("DescribeDirectories").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeDirectoriesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeDirectoriesRequest));
            CompletableFuture<DescribeDirectoriesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides information about any domain controllers in your directory.
     * </p>
     *
     * @param describeDomainControllersRequest
     * @return A Java Future containing the result of the DescribeDomainControllers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeDomainControllers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeDomainControllers" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDomainControllersResponse> describeDomainControllers(
            DescribeDomainControllersRequest describeDomainControllersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDomainControllersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDomainControllersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDomainControllers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDomainControllersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeDomainControllersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeDomainControllersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDomainControllersRequest, DescribeDomainControllersResponse>()
                            .withOperationName("DescribeDomainControllers").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeDomainControllersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeDomainControllersRequest));
            CompletableFuture<DescribeDomainControllersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Obtains information about which Amazon SNS topics receive status messages from the specified directory.
     * </p>
     * <p>
     * If no input parameters are provided, such as DirectoryId or TopicName, this request describes all of the
     * associations in the account.
     * </p>
     *
     * @param describeEventTopicsRequest
     *        Describes event topics.
     * @return A Java Future containing the result of the DescribeEventTopics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeEventTopics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeEventTopics" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeEventTopicsResponse> describeEventTopics(
            DescribeEventTopicsRequest describeEventTopicsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeEventTopicsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEventTopicsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEventTopics");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeEventTopicsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeEventTopicsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeEventTopicsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeEventTopicsRequest, DescribeEventTopicsResponse>()
                            .withOperationName("DescribeEventTopics").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeEventTopicsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeEventTopicsRequest));
            CompletableFuture<DescribeEventTopicsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the status of LDAP security for the specified directory.
     * </p>
     *
     * @param describeLdapsSettingsRequest
     * @return A Java Future containing the result of the DescribeLDAPSSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeLDAPSSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeLDAPSSettings" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeLdapsSettingsResponse> describeLDAPSSettings(
            DescribeLdapsSettingsRequest describeLdapsSettingsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeLdapsSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeLdapsSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeLDAPSSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeLdapsSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeLdapsSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeLdapsSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeLdapsSettingsRequest, DescribeLdapsSettingsResponse>()
                            .withOperationName("DescribeLDAPSSettings").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeLdapsSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeLdapsSettingsRequest));
            CompletableFuture<DescribeLdapsSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides information about the Regions that are configured for multi-Region replication.
     * </p>
     *
     * @param describeRegionsRequest
     * @return A Java Future containing the result of the DescribeRegions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>AccessDeniedException Client authentication is not available in this region at this time.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeRegions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeRegions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeRegionsResponse> describeRegions(DescribeRegionsRequest describeRegionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeRegionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeRegionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeRegions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeRegionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeRegionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeRegionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeRegionsRequest, DescribeRegionsResponse>()
                            .withOperationName("DescribeRegions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeRegionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeRegionsRequest));
            CompletableFuture<DescribeRegionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the configurable settings for the specified directory.
     * </p>
     *
     * @param describeSettingsRequest
     * @return A Java Future containing the result of the DescribeSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeSettings" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeSettingsResponse> describeSettings(DescribeSettingsRequest describeSettingsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeSettingsRequest, DescribeSettingsResponse>()
                            .withOperationName("DescribeSettings").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeSettingsRequest));
            CompletableFuture<DescribeSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the shared directories in your account.
     * </p>
     *
     * @param describeSharedDirectoriesRequest
     * @return A Java Future containing the result of the DescribeSharedDirectories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeSharedDirectories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeSharedDirectories" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeSharedDirectoriesResponse> describeSharedDirectories(
            DescribeSharedDirectoriesRequest describeSharedDirectoriesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeSharedDirectoriesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSharedDirectoriesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSharedDirectories");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeSharedDirectoriesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeSharedDirectoriesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeSharedDirectoriesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeSharedDirectoriesRequest, DescribeSharedDirectoriesResponse>()
                            .withOperationName("DescribeSharedDirectories").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeSharedDirectoriesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeSharedDirectoriesRequest));
            CompletableFuture<DescribeSharedDirectoriesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Obtains information about the directory snapshots that belong to this account.
     * </p>
     * <p>
     * This operation supports pagination with the use of the <i>NextToken</i> request and response parameters. If more
     * results are available, the <i>DescribeSnapshots.NextToken</i> member contains a token that you pass in the next
     * call to <a>DescribeSnapshots</a> to retrieve the next set of items.
     * </p>
     * <p>
     * You can also specify a maximum number of return results with the <i>Limit</i> parameter.
     * </p>
     *
     * @param describeSnapshotsRequest
     *        Contains the inputs for the <a>DescribeSnapshots</a> operation.
     * @return A Java Future containing the result of the DescribeSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeSnapshotsResponse> describeSnapshots(DescribeSnapshotsRequest describeSnapshotsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeSnapshotsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSnapshotsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSnapshots");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeSnapshotsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeSnapshotsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeSnapshotsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeSnapshotsRequest, DescribeSnapshotsResponse>()
                            .withOperationName("DescribeSnapshots").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeSnapshotsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeSnapshotsRequest));
            CompletableFuture<DescribeSnapshotsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Obtains information about the trust relationships for this account.
     * </p>
     * <p>
     * If no input parameters are provided, such as DirectoryId or TrustIds, this request describes all the trust
     * relationships belonging to the account.
     * </p>
     *
     * @param describeTrustsRequest
     *        Describes the trust relationships for a particular Managed Microsoft AD directory. If no input parameters
     *        are provided, such as directory ID or trust ID, this request describes all the trust relationships.
     * @return A Java Future containing the result of the DescribeTrusts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeTrusts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeTrusts" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeTrustsResponse> describeTrusts(DescribeTrustsRequest describeTrustsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeTrustsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTrustsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTrusts");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeTrustsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeTrustsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeTrustsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeTrustsRequest, DescribeTrustsResponse>()
                            .withOperationName("DescribeTrusts").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeTrustsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeTrustsRequest));
            CompletableFuture<DescribeTrustsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the updates of a directory for a particular update type.
     * </p>
     *
     * @param describeUpdateDirectoryRequest
     * @return A Java Future containing the result of the DescribeUpdateDirectory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>AccessDeniedException Client authentication is not available in this region at this time.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeUpdateDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeUpdateDirectory" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeUpdateDirectoryResponse> describeUpdateDirectory(
            DescribeUpdateDirectoryRequest describeUpdateDirectoryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeUpdateDirectoryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeUpdateDirectoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeUpdateDirectory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeUpdateDirectoryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeUpdateDirectoryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeUpdateDirectoryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeUpdateDirectoryRequest, DescribeUpdateDirectoryResponse>()
                            .withOperationName("DescribeUpdateDirectory").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeUpdateDirectoryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeUpdateDirectoryRequest));
            CompletableFuture<DescribeUpdateDirectoryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disables alternative client authentication methods for the specified directory.
     * </p>
     *
     * @param disableClientAuthenticationRequest
     * @return A Java Future containing the result of the DisableClientAuthentication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>InvalidClientAuthStatusException Client authentication is already enabled.</li>
     *         <li>AccessDeniedException Client authentication is not available in this region at this time.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DisableClientAuthentication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DisableClientAuthentication"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisableClientAuthenticationResponse> disableClientAuthentication(
            DisableClientAuthenticationRequest disableClientAuthenticationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disableClientAuthenticationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disableClientAuthenticationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisableClientAuthentication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisableClientAuthenticationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisableClientAuthenticationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisableClientAuthenticationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisableClientAuthenticationRequest, DisableClientAuthenticationResponse>()
                            .withOperationName("DisableClientAuthentication").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DisableClientAuthenticationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(disableClientAuthenticationRequest));
            CompletableFuture<DisableClientAuthenticationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deactivates LDAP secure calls for the specified directory.
     * </p>
     *
     * @param disableLdapsRequest
     * @return A Java Future containing the result of the DisableLDAPS operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>InvalidLdapsStatusException The LDAP activities could not be performed because they are limited by
     *         the LDAPS status.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DisableLDAPS
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DisableLDAPS" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DisableLdapsResponse> disableLDAPS(DisableLdapsRequest disableLdapsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disableLdapsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disableLdapsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisableLDAPS");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisableLdapsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DisableLdapsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisableLdapsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisableLdapsRequest, DisableLdapsResponse>()
                            .withOperationName("DisableLDAPS").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DisableLdapsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(disableLdapsRequest));
            CompletableFuture<DisableLdapsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disables multi-factor authentication (MFA) with the Remote Authentication Dial In User Service (RADIUS) server
     * for an AD Connector or Microsoft AD directory.
     * </p>
     *
     * @param disableRadiusRequest
     *        Contains the inputs for the <a>DisableRadius</a> operation.
     * @return A Java Future containing the result of the DisableRadius operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DisableRadius
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DisableRadius" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DisableRadiusResponse> disableRadius(DisableRadiusRequest disableRadiusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disableRadiusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disableRadiusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisableRadius");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisableRadiusResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DisableRadiusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisableRadiusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisableRadiusRequest, DisableRadiusResponse>()
                            .withOperationName("DisableRadius").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DisableRadiusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(disableRadiusRequest));
            CompletableFuture<DisableRadiusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disables single-sign on for a directory.
     * </p>
     *
     * @param disableSsoRequest
     *        Contains the inputs for the <a>DisableSso</a> operation.
     * @return A Java Future containing the result of the DisableSso operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InsufficientPermissionsException The account does not have sufficient permission to perform the
     *         operation.</li>
     *         <li>AuthenticationFailedException An authentication error occurred.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DisableSso
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DisableSso" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DisableSsoResponse> disableSso(DisableSsoRequest disableSsoRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disableSsoRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disableSsoRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisableSso");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisableSsoResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DisableSsoResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisableSsoResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisableSsoRequest, DisableSsoResponse>().withOperationName("DisableSso")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DisableSsoRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(disableSsoRequest));
            CompletableFuture<DisableSsoResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables alternative client authentication methods for the specified directory.
     * </p>
     *
     * @param enableClientAuthenticationRequest
     * @return A Java Future containing the result of the EnableClientAuthentication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>InvalidClientAuthStatusException Client authentication is already enabled.</li>
     *         <li>AccessDeniedException Client authentication is not available in this region at this time.</li>
     *         <li>NoAvailableCertificateException Client authentication setup could not be completed because at least
     *         one valid certificate must be registered in the system.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.EnableClientAuthentication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/EnableClientAuthentication" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<EnableClientAuthenticationResponse> enableClientAuthentication(
            EnableClientAuthenticationRequest enableClientAuthenticationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(enableClientAuthenticationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, enableClientAuthenticationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "EnableClientAuthentication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<EnableClientAuthenticationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, EnableClientAuthenticationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<EnableClientAuthenticationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<EnableClientAuthenticationRequest, EnableClientAuthenticationResponse>()
                            .withOperationName("EnableClientAuthentication").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new EnableClientAuthenticationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(enableClientAuthenticationRequest));
            CompletableFuture<EnableClientAuthenticationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Activates the switch for the specific directory to always use LDAP secure calls.
     * </p>
     *
     * @param enableLdapsRequest
     * @return A Java Future containing the result of the EnableLDAPS operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>NoAvailableCertificateException Client authentication setup could not be completed because at least
     *         one valid certificate must be registered in the system.</li>
     *         <li>InvalidLdapsStatusException The LDAP activities could not be performed because they are limited by
     *         the LDAPS status.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.EnableLDAPS
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/EnableLDAPS" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<EnableLdapsResponse> enableLDAPS(EnableLdapsRequest enableLdapsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(enableLdapsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, enableLdapsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "EnableLDAPS");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<EnableLdapsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    EnableLdapsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<EnableLdapsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<EnableLdapsRequest, EnableLdapsResponse>()
                            .withOperationName("EnableLDAPS").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new EnableLdapsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(enableLdapsRequest));
            CompletableFuture<EnableLdapsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables multi-factor authentication (MFA) with the Remote Authentication Dial In User Service (RADIUS) server for
     * an AD Connector or Microsoft AD directory.
     * </p>
     *
     * @param enableRadiusRequest
     *        Contains the inputs for the <a>EnableRadius</a> operation.
     * @return A Java Future containing the result of the EnableRadius operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>EntityAlreadyExistsException The specified entity already exists.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.EnableRadius
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/EnableRadius" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<EnableRadiusResponse> enableRadius(EnableRadiusRequest enableRadiusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(enableRadiusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, enableRadiusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "EnableRadius");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<EnableRadiusResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    EnableRadiusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<EnableRadiusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<EnableRadiusRequest, EnableRadiusResponse>()
                            .withOperationName("EnableRadius").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new EnableRadiusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(enableRadiusRequest));
            CompletableFuture<EnableRadiusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables single sign-on for a directory. Single sign-on allows users in your directory to access certain Amazon
     * Web Services services from a computer joined to the directory without having to enter their credentials
     * separately.
     * </p>
     *
     * @param enableSsoRequest
     *        Contains the inputs for the <a>EnableSso</a> operation.
     * @return A Java Future containing the result of the EnableSso operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InsufficientPermissionsException The account does not have sufficient permission to perform the
     *         operation.</li>
     *         <li>AuthenticationFailedException An authentication error occurred.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.EnableSso
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/EnableSso" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<EnableSsoResponse> enableSso(EnableSsoRequest enableSsoRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(enableSsoRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, enableSsoRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "EnableSso");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<EnableSsoResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    EnableSsoResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<EnableSsoResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<EnableSsoRequest, EnableSsoResponse>().withOperationName("EnableSso")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new EnableSsoRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(enableSsoRequest));
            CompletableFuture<EnableSsoResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Obtains directory limit information for the current Region.
     * </p>
     *
     * @param getDirectoryLimitsRequest
     *        Contains the inputs for the <a>GetDirectoryLimits</a> operation.
     * @return A Java Future containing the result of the GetDirectoryLimits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.GetDirectoryLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/GetDirectoryLimits" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetDirectoryLimitsResponse> getDirectoryLimits(GetDirectoryLimitsRequest getDirectoryLimitsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDirectoryLimitsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDirectoryLimitsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDirectoryLimits");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDirectoryLimitsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDirectoryLimitsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDirectoryLimitsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDirectoryLimitsRequest, GetDirectoryLimitsResponse>()
                            .withOperationName("GetDirectoryLimits").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetDirectoryLimitsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getDirectoryLimitsRequest));
            CompletableFuture<GetDirectoryLimitsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Obtains the manual snapshot limits for a directory.
     * </p>
     *
     * @param getSnapshotLimitsRequest
     *        Contains the inputs for the <a>GetSnapshotLimits</a> operation.
     * @return A Java Future containing the result of the GetSnapshotLimits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.GetSnapshotLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/GetSnapshotLimits" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetSnapshotLimitsResponse> getSnapshotLimits(GetSnapshotLimitsRequest getSnapshotLimitsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSnapshotLimitsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSnapshotLimitsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSnapshotLimits");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSnapshotLimitsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetSnapshotLimitsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSnapshotLimitsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSnapshotLimitsRequest, GetSnapshotLimitsResponse>()
                            .withOperationName("GetSnapshotLimits").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetSnapshotLimitsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getSnapshotLimitsRequest));
            CompletableFuture<GetSnapshotLimitsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * For the specified directory, lists all the certificates registered for a secure LDAP or client certificate
     * authentication.
     * </p>
     *
     * @param listCertificatesRequest
     * @return A Java Future containing the result of the ListCertificates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.ListCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ListCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListCertificatesResponse> listCertificates(ListCertificatesRequest listCertificatesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCertificatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCertificatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCertificates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCertificatesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListCertificatesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListCertificatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCertificatesRequest, ListCertificatesResponse>()
                            .withOperationName("ListCertificates").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListCertificatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listCertificatesRequest));
            CompletableFuture<ListCertificatesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the address blocks that you have added to a directory.
     * </p>
     *
     * @param listIpRoutesRequest
     * @return A Java Future containing the result of the ListIpRoutes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.ListIpRoutes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ListIpRoutes" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListIpRoutesResponse> listIpRoutes(ListIpRoutesRequest listIpRoutesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listIpRoutesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listIpRoutesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListIpRoutes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListIpRoutesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListIpRoutesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListIpRoutesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListIpRoutesRequest, ListIpRoutesResponse>()
                            .withOperationName("ListIpRoutes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListIpRoutesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listIpRoutesRequest));
            CompletableFuture<ListIpRoutesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the active log subscriptions for the Amazon Web Services account.
     * </p>
     *
     * @param listLogSubscriptionsRequest
     * @return A Java Future containing the result of the ListLogSubscriptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.ListLogSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ListLogSubscriptions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListLogSubscriptionsResponse> listLogSubscriptions(
            ListLogSubscriptionsRequest listLogSubscriptionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listLogSubscriptionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listLogSubscriptionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListLogSubscriptions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListLogSubscriptionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListLogSubscriptionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListLogSubscriptionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListLogSubscriptionsRequest, ListLogSubscriptionsResponse>()
                            .withOperationName("ListLogSubscriptions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListLogSubscriptionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listLogSubscriptionsRequest));
            CompletableFuture<ListLogSubscriptionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all schema extensions applied to a Microsoft AD Directory.
     * </p>
     *
     * @param listSchemaExtensionsRequest
     * @return A Java Future containing the result of the ListSchemaExtensions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.ListSchemaExtensions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ListSchemaExtensions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListSchemaExtensionsResponse> listSchemaExtensions(
            ListSchemaExtensionsRequest listSchemaExtensionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSchemaExtensionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSchemaExtensionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSchemaExtensions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListSchemaExtensionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListSchemaExtensionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListSchemaExtensionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSchemaExtensionsRequest, ListSchemaExtensionsResponse>()
                            .withOperationName("ListSchemaExtensions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListSchemaExtensionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listSchemaExtensionsRequest));
            CompletableFuture<ListSchemaExtensionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all tags on a directory.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Registers a certificate for a secure LDAP or client certificate authentication.
     * </p>
     *
     * @param registerCertificateRequest
     * @return A Java Future containing the result of the RegisterCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>InvalidCertificateException The certificate PEM that was provided has incorrect encoding.</li>
     *         <li>CertificateLimitExceededException The certificate could not be added because the certificate limit
     *         has been reached.</li>
     *         <li>CertificateAlreadyExistsException The certificate has already been registered into the system.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.RegisterCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/RegisterCertificate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<RegisterCertificateResponse> registerCertificate(
            RegisterCertificateRequest registerCertificateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(registerCertificateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, registerCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RegisterCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RegisterCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RegisterCertificateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RegisterCertificateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RegisterCertificateRequest, RegisterCertificateResponse>()
                            .withOperationName("RegisterCertificate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RegisterCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(registerCertificateRequest));
            CompletableFuture<RegisterCertificateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates a directory with an Amazon SNS topic. This establishes the directory as a publisher to the specified
     * Amazon SNS topic. You can then receive email or text (SMS) messages when the status of your directory changes.
     * You get notified if your directory goes from an Active status to an Impaired or Inoperable status. You also
     * receive a notification when the directory returns to an Active status.
     * </p>
     *
     * @param registerEventTopicRequest
     *        Registers a new event topic.
     * @return A Java Future containing the result of the RegisterEventTopic operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.RegisterEventTopic
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/RegisterEventTopic" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<RegisterEventTopicResponse> registerEventTopic(RegisterEventTopicRequest registerEventTopicRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(registerEventTopicRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, registerEventTopicRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RegisterEventTopic");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RegisterEventTopicResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RegisterEventTopicResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RegisterEventTopicResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RegisterEventTopicRequest, RegisterEventTopicResponse>()
                            .withOperationName("RegisterEventTopic").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RegisterEventTopicRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(registerEventTopicRequest));
            CompletableFuture<RegisterEventTopicResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Rejects a directory sharing request that was sent from the directory owner account.
     * </p>
     *
     * @param rejectSharedDirectoryRequest
     * @return A Java Future containing the result of the RejectSharedDirectory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>DirectoryAlreadySharedException The specified directory has already been shared with this Amazon Web
     *         Services account.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.RejectSharedDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/RejectSharedDirectory" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<RejectSharedDirectoryResponse> rejectSharedDirectory(
            RejectSharedDirectoryRequest rejectSharedDirectoryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(rejectSharedDirectoryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, rejectSharedDirectoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RejectSharedDirectory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RejectSharedDirectoryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RejectSharedDirectoryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RejectSharedDirectoryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RejectSharedDirectoryRequest, RejectSharedDirectoryResponse>()
                            .withOperationName("RejectSharedDirectory").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RejectSharedDirectoryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(rejectSharedDirectoryRequest));
            CompletableFuture<RejectSharedDirectoryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes IP address blocks from a directory.
     * </p>
     *
     * @param removeIpRoutesRequest
     * @return A Java Future containing the result of the RemoveIpRoutes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.RemoveIpRoutes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/RemoveIpRoutes" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<RemoveIpRoutesResponse> removeIpRoutes(RemoveIpRoutesRequest removeIpRoutesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(removeIpRoutesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeIpRoutesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveIpRoutes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RemoveIpRoutesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RemoveIpRoutesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RemoveIpRoutesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RemoveIpRoutesRequest, RemoveIpRoutesResponse>()
                            .withOperationName("RemoveIpRoutes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RemoveIpRoutesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(removeIpRoutesRequest));
            CompletableFuture<RemoveIpRoutesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops all replication and removes the domain controllers from the specified Region. You cannot remove the primary
     * Region with this operation. Instead, use the <code>DeleteDirectory</code> API.
     * </p>
     *
     * @param removeRegionRequest
     * @return A Java Future containing the result of the RemoveRegion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>AccessDeniedException Client authentication is not available in this region at this time.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.RemoveRegion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/RemoveRegion" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<RemoveRegionResponse> removeRegion(RemoveRegionRequest removeRegionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(removeRegionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeRegionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveRegion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RemoveRegionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    RemoveRegionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RemoveRegionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RemoveRegionRequest, RemoveRegionResponse>()
                            .withOperationName("RemoveRegion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RemoveRegionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(removeRegionRequest));
            CompletableFuture<RemoveRegionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes tags from a directory.
     * </p>
     *
     * @param removeTagsFromResourceRequest
     * @return A Java Future containing the result of the RemoveTagsFromResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.RemoveTagsFromResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/RemoveTagsFromResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<RemoveTagsFromResourceResponse> removeTagsFromResource(
            RemoveTagsFromResourceRequest removeTagsFromResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(removeTagsFromResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeTagsFromResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveTagsFromResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RemoveTagsFromResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RemoveTagsFromResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RemoveTagsFromResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RemoveTagsFromResourceRequest, RemoveTagsFromResourceResponse>()
                            .withOperationName("RemoveTagsFromResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RemoveTagsFromResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(removeTagsFromResourceRequest));
            CompletableFuture<RemoveTagsFromResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Resets the password for any user in your Managed Microsoft AD or Simple AD directory.
     * </p>
     * <p>
     * You can reset the password for any user in your directory with the following exceptions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For Simple AD, you cannot reset the password for any user that is a member of either the <b>Domain Admins</b> or
     * <b>Enterprise Admins</b> group except for the administrator user.
     * </p>
     * </li>
     * <li>
     * <p>
     * For Managed Microsoft AD, you can only reset the password for a user that is in an OU based off of the NetBIOS
     * name that you typed when you created your directory. For example, you cannot reset the password for a user in the
     * <b>Amazon Web Services Reserved</b> OU. For more information about the OU structure for an Managed Microsoft AD
     * directory, see <a href=
     * "https://docs.aws.amazon.com/directoryservice/latest/admin-guide/ms_ad_getting_started_what_gets_created.html"
     * >What Gets Created</a> in the <i>Directory Service Administration Guide</i>.
     * </p>
     * </li>
     * </ul>
     *
     * @param resetUserPasswordRequest
     * @return A Java Future containing the result of the ResetUserPassword operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>UserDoesNotExistException The user provided a username that does not exist in your directory.</li>
     *         <li>InvalidPasswordException The new password provided by the user does not meet the password complexity
     *         requirements defined in your directory.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.ResetUserPassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ResetUserPassword" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ResetUserPasswordResponse> resetUserPassword(ResetUserPasswordRequest resetUserPasswordRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(resetUserPasswordRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, resetUserPasswordRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ResetUserPassword");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ResetUserPasswordResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ResetUserPasswordResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ResetUserPasswordResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ResetUserPasswordRequest, ResetUserPasswordResponse>()
                            .withOperationName("ResetUserPassword").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ResetUserPasswordRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(resetUserPasswordRequest));
            CompletableFuture<ResetUserPasswordResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Restores a directory using an existing directory snapshot.
     * </p>
     * <p>
     * When you restore a directory from a snapshot, any changes made to the directory after the snapshot date are
     * overwritten.
     * </p>
     * <p>
     * This action returns as soon as the restore operation is initiated. You can monitor the progress of the restore
     * operation by calling the <a>DescribeDirectories</a> operation with the directory identifier. When the
     * <b>DirectoryDescription.Stage</b> value changes to <code>Active</code>, the restore operation is complete.
     * </p>
     *
     * @param restoreFromSnapshotRequest
     *        An object representing the inputs for the <a>RestoreFromSnapshot</a> operation.
     * @return A Java Future containing the result of the RestoreFromSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.RestoreFromSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/RestoreFromSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<RestoreFromSnapshotResponse> restoreFromSnapshot(
            RestoreFromSnapshotRequest restoreFromSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(restoreFromSnapshotRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, restoreFromSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RestoreFromSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RestoreFromSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RestoreFromSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RestoreFromSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RestoreFromSnapshotRequest, RestoreFromSnapshotResponse>()
                            .withOperationName("RestoreFromSnapshot").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RestoreFromSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(restoreFromSnapshotRequest));
            CompletableFuture<RestoreFromSnapshotResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Shares a specified directory (<code>DirectoryId</code>) in your Amazon Web Services account (directory owner)
     * with another Amazon Web Services account (directory consumer). With this operation you can use your directory
     * from any Amazon Web Services account and from any Amazon VPC within an Amazon Web Services Region.
     * </p>
     * <p>
     * When you share your Managed Microsoft AD directory, Directory Service creates a shared directory in the directory
     * consumer account. This shared directory contains the metadata to provide access to the directory within the
     * directory owner account. The shared directory is visible in all VPCs in the directory consumer account.
     * </p>
     * <p>
     * The <code>ShareMethod</code> parameter determines whether the specified directory can be shared between Amazon
     * Web Services accounts inside the same Amazon Web Services organization (<code>ORGANIZATIONS</code>). It also
     * determines whether you can share the directory with any other Amazon Web Services account either inside or
     * outside of the organization (<code>HANDSHAKE</code>).
     * </p>
     * <p>
     * The <code>ShareNotes</code> parameter is only used when <code>HANDSHAKE</code> is called, which sends a directory
     * sharing request to the directory consumer.
     * </p>
     *
     * @param shareDirectoryRequest
     * @return A Java Future containing the result of the ShareDirectory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectoryAlreadySharedException The specified directory has already been shared with this Amazon Web
     *         Services account.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidTargetException The specified shared target is not valid.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ShareLimitExceededException The maximum number of Amazon Web Services accounts that you can share
     *         with this directory has been reached.</li>
     *         <li>OrganizationsException Exception encountered while trying to access your Amazon Web Services
     *         organization.</li>
     *         <li>AccessDeniedException Client authentication is not available in this region at this time.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.ShareDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ShareDirectory" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ShareDirectoryResponse> shareDirectory(ShareDirectoryRequest shareDirectoryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(shareDirectoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, shareDirectoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ShareDirectory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ShareDirectoryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ShareDirectoryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ShareDirectoryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ShareDirectoryRequest, ShareDirectoryResponse>()
                            .withOperationName("ShareDirectory").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ShareDirectoryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(shareDirectoryRequest));
            CompletableFuture<ShareDirectoryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Applies a schema extension to a Microsoft AD directory.
     * </p>
     *
     * @param startSchemaExtensionRequest
     * @return A Java Future containing the result of the StartSchemaExtension operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>SnapshotLimitExceededException The maximum number of manual snapshots for the directory has been
     *         reached. You can use the <a>GetSnapshotLimits</a> operation to determine the snapshot limits for a
     *         directory.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.StartSchemaExtension
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/StartSchemaExtension" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StartSchemaExtensionResponse> startSchemaExtension(
            StartSchemaExtensionRequest startSchemaExtensionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startSchemaExtensionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startSchemaExtensionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartSchemaExtension");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartSchemaExtensionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartSchemaExtensionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartSchemaExtensionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartSchemaExtensionRequest, StartSchemaExtensionResponse>()
                            .withOperationName("StartSchemaExtension").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartSchemaExtensionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startSchemaExtensionRequest));
            CompletableFuture<StartSchemaExtensionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops the directory sharing between the directory owner and consumer accounts.
     * </p>
     *
     * @param unshareDirectoryRequest
     * @return A Java Future containing the result of the UnshareDirectory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidTargetException The specified shared target is not valid.</li>
     *         <li>DirectoryNotSharedException The specified directory has not been shared with this Amazon Web Services
     *         account.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.UnshareDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/UnshareDirectory" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UnshareDirectoryResponse> unshareDirectory(UnshareDirectoryRequest unshareDirectoryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(unshareDirectoryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, unshareDirectoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UnshareDirectory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UnshareDirectoryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UnshareDirectoryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UnshareDirectoryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UnshareDirectoryRequest, UnshareDirectoryResponse>()
                            .withOperationName("UnshareDirectory").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UnshareDirectoryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(unshareDirectoryRequest));
            CompletableFuture<UnshareDirectoryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a conditional forwarder that has been set up for your Amazon Web Services directory.
     * </p>
     *
     * @param updateConditionalForwarderRequest
     *        Updates a conditional forwarder.
     * @return A Java Future containing the result of the UpdateConditionalForwarder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.UpdateConditionalForwarder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/UpdateConditionalForwarder" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateConditionalForwarderResponse> updateConditionalForwarder(
            UpdateConditionalForwarderRequest updateConditionalForwarderRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateConditionalForwarderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateConditionalForwarderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateConditionalForwarder");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateConditionalForwarderResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateConditionalForwarderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateConditionalForwarderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateConditionalForwarderRequest, UpdateConditionalForwarderResponse>()
                            .withOperationName("UpdateConditionalForwarder").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateConditionalForwarderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateConditionalForwarderRequest));
            CompletableFuture<UpdateConditionalForwarderResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the directory for a particular update type.
     * </p>
     *
     * @param updateDirectorySetupRequest
     * @return A Java Future containing the result of the UpdateDirectorySetup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>DirectoryInDesiredStateException The directory is already updated to desired update type settings.</li>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>SnapshotLimitExceededException The maximum number of manual snapshots for the directory has been
     *         reached. You can use the <a>GetSnapshotLimits</a> operation to determine the snapshot limits for a
     *         directory.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>AccessDeniedException Client authentication is not available in this region at this time.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.UpdateDirectorySetup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/UpdateDirectorySetup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateDirectorySetupResponse> updateDirectorySetup(
            UpdateDirectorySetupRequest updateDirectorySetupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateDirectorySetupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDirectorySetupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDirectorySetup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateDirectorySetupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateDirectorySetupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateDirectorySetupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateDirectorySetupRequest, UpdateDirectorySetupResponse>()
                            .withOperationName("UpdateDirectorySetup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateDirectorySetupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateDirectorySetupRequest));
            CompletableFuture<UpdateDirectorySetupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds or removes domain controllers to or from the directory. Based on the difference between current value and
     * new value (provided through this API call), domain controllers will be added or removed. It may take up to 45
     * minutes for any new domain controllers to become fully active once the requested number of domain controllers is
     * updated. During this time, you cannot make another update request.
     * </p>
     *
     * @param updateNumberOfDomainControllersRequest
     * @return A Java Future containing the result of the UpdateNumberOfDomainControllers operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>DomainControllerLimitExceededException The maximum allowed number of domain controllers per directory
     *         was exceeded. The default limit per directory is 20 domain controllers.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.UpdateNumberOfDomainControllers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/UpdateNumberOfDomainControllers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateNumberOfDomainControllersResponse> updateNumberOfDomainControllers(
            UpdateNumberOfDomainControllersRequest updateNumberOfDomainControllersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateNumberOfDomainControllersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateNumberOfDomainControllersRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateNumberOfDomainControllers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateNumberOfDomainControllersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateNumberOfDomainControllersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateNumberOfDomainControllersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateNumberOfDomainControllersRequest, UpdateNumberOfDomainControllersResponse>()
                            .withOperationName("UpdateNumberOfDomainControllers").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateNumberOfDomainControllersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateNumberOfDomainControllersRequest));
            CompletableFuture<UpdateNumberOfDomainControllersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the Remote Authentication Dial In User Service (RADIUS) server information for an AD Connector or
     * Microsoft AD directory.
     * </p>
     *
     * @param updateRadiusRequest
     *        Contains the inputs for the <a>UpdateRadius</a> operation.
     * @return A Java Future containing the result of the UpdateRadius operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.UpdateRadius
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/UpdateRadius" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateRadiusResponse> updateRadius(UpdateRadiusRequest updateRadiusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateRadiusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateRadiusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRadius");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateRadiusResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateRadiusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateRadiusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateRadiusRequest, UpdateRadiusResponse>()
                            .withOperationName("UpdateRadius").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateRadiusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateRadiusRequest));
            CompletableFuture<UpdateRadiusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the configurable settings for the specified directory.
     * </p>
     *
     * @param updateSettingsRequest
     * @return A Java Future containing the result of the UpdateSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>IncompatibleSettingsException The specified directory setting is not compatible with other settings.</li>
     *         <li>UnsupportedSettingsException The specified directory setting is not supported.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.UpdateSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/UpdateSettings" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateSettingsResponse> updateSettings(UpdateSettingsRequest updateSettingsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateSettingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateSettingsRequest, UpdateSettingsResponse>()
                            .withOperationName("UpdateSettings").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateSettingsRequest));
            CompletableFuture<UpdateSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the trust that has been set up between your Managed Microsoft AD directory and an self-managed Active
     * Directory.
     * </p>
     *
     * @param updateTrustRequest
     * @return A Java Future containing the result of the UpdateTrust operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.UpdateTrust
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/UpdateTrust" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateTrustResponse> updateTrust(UpdateTrustRequest updateTrustRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateTrustRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateTrustRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateTrust");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateTrustResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateTrustResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateTrustResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateTrustRequest, UpdateTrustResponse>()
                            .withOperationName("UpdateTrust").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateTrustRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateTrustRequest));
            CompletableFuture<UpdateTrustResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Directory Service for Microsoft Active Directory allows you to configure and verify trust relationships.
     * </p>
     * <p>
     * This action verifies a trust relationship between your Managed Microsoft AD directory and an external domain.
     * </p>
     *
     * @param verifyTrustRequest
     *        Initiates the verification of an existing trust relationship between an Managed Microsoft AD directory and
     *        an external domain.
     * @return A Java Future containing the result of the VerifyTrust operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.VerifyTrust
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/VerifyTrust" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<VerifyTrustResponse> verifyTrust(VerifyTrustRequest verifyTrustRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(verifyTrustRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, verifyTrustRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "VerifyTrust");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<VerifyTrustResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    VerifyTrustResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<VerifyTrustResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<VerifyTrustRequest, VerifyTrustResponse>()
                            .withOperationName("VerifyTrust").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new VerifyTrustRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(verifyTrustRequest));
            CompletableFuture<VerifyTrustResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public final DirectoryServiceClientConfiguration serviceClientConfiguration() {
        return new DirectoryServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(DirectoryException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                                .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DirectoryUnavailableException")
                                .exceptionBuilderSupplier(DirectoryUnavailableException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidCertificateException")
                                .exceptionBuilderSupplier(InvalidCertificateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DirectoryNotSharedException")
                                .exceptionBuilderSupplier(DirectoryNotSharedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RegionLimitExceededException")
                                .exceptionBuilderSupplier(RegionLimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EntityDoesNotExistException")
                                .exceptionBuilderSupplier(EntityDoesNotExistException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                                .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                                .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidNextTokenException")
                                .exceptionBuilderSupplier(InvalidNextTokenException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                                .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                                .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                                .exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UserDoesNotExistException")
                                .exceptionBuilderSupplier(UserDoesNotExistException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidPasswordException")
                                .exceptionBuilderSupplier(InvalidPasswordException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnsupportedOperationException")
                                .exceptionBuilderSupplier(UnsupportedOperationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ClientException")
                                .exceptionBuilderSupplier(ClientException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IncompatibleSettingsException")
                                .exceptionBuilderSupplier(IncompatibleSettingsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AuthenticationFailedException")
                                .exceptionBuilderSupplier(AuthenticationFailedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                                .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                                .exceptionBuilderSupplier(InsufficientPermissionsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                                .exceptionBuilderSupplier(CertificateLimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OrganizationsException")
                                .exceptionBuilderSupplier(OrganizationsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException")
                                .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidParameterException")
                                .exceptionBuilderSupplier(InvalidParameterException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                                .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceException")
                                .exceptionBuilderSupplier(ServiceException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                                .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException")
                                .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                                .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnsupportedSettingsException")
                                .exceptionBuilderSupplier(UnsupportedSettingsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                                .exceptionBuilderSupplier(NoAvailableCertificateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidTargetException")
                                .exceptionBuilderSupplier(InvalidTargetException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException")
                                .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TagLimitExceededException")
                                .exceptionBuilderSupplier(TagLimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ShareLimitExceededException")
                                .exceptionBuilderSupplier(ShareLimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CertificateInUseException")
                                .exceptionBuilderSupplier(CertificateInUseException::builder).httpStatusCode(400).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        DirectoryServiceClientConfigurationBuilder serviceConfigBuilder = new DirectoryServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
