/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the client certificate authentication settings for the <code>RegisterCertificate</code>
 * and <code>DescribeCertificate</code> operations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClientCertAuthSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<ClientCertAuthSettings.Builder, ClientCertAuthSettings> {
    private static final SdkField<String> OCSP_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OCSPUrl").getter(getter(ClientCertAuthSettings::ocspUrl)).setter(setter(Builder::ocspUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OCSPUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OCSP_URL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("OCSPUrl", OCSP_URL_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String ocspUrl;

    private ClientCertAuthSettings(BuilderImpl builder) {
        this.ocspUrl = builder.ocspUrl;
    }

    /**
     * <p>
     * Specifies the URL of the default OCSP server used to check for revocation status. A secondary value to any OCSP
     * address found in the AIA extension of the user certificate.
     * </p>
     * 
     * @return Specifies the URL of the default OCSP server used to check for revocation status. A secondary value to
     *         any OCSP address found in the AIA extension of the user certificate.
     */
    public final String ocspUrl() {
        return ocspUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ocspUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClientCertAuthSettings)) {
            return false;
        }
        ClientCertAuthSettings other = (ClientCertAuthSettings) obj;
        return Objects.equals(ocspUrl(), other.ocspUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClientCertAuthSettings").add("OCSPUrl", ocspUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OCSPUrl":
            return Optional.ofNullable(clazz.cast(ocspUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ClientCertAuthSettings, T> g) {
        return obj -> g.apply((ClientCertAuthSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClientCertAuthSettings> {
        /**
         * <p>
         * Specifies the URL of the default OCSP server used to check for revocation status. A secondary value to any
         * OCSP address found in the AIA extension of the user certificate.
         * </p>
         * 
         * @param ocspUrl
         *        Specifies the URL of the default OCSP server used to check for revocation status. A secondary value to
         *        any OCSP address found in the AIA extension of the user certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ocspUrl(String ocspUrl);
    }

    static final class BuilderImpl implements Builder {
        private String ocspUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(ClientCertAuthSettings model) {
            ocspUrl(model.ocspUrl);
        }

        public final String getOcspUrl() {
            return ocspUrl;
        }

        public final void setOcspUrl(String ocspUrl) {
            this.ocspUrl = ocspUrl;
        }

        @Override
        public final Builder ocspUrl(String ocspUrl) {
            this.ocspUrl = ocspUrl;
            return this;
        }

        @Override
        public ClientCertAuthSettings build() {
            return new ClientCertAuthSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
