/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeClientAuthenticationSettingsResponse extends DirectoryResponse implements
        ToCopyableBuilder<DescribeClientAuthenticationSettingsResponse.Builder, DescribeClientAuthenticationSettingsResponse> {
    private static final SdkField<List<ClientAuthenticationSettingInfo>> CLIENT_AUTHENTICATION_SETTINGS_INFO_FIELD = SdkField
            .<List<ClientAuthenticationSettingInfo>> builder(MarshallingType.LIST)
            .memberName("ClientAuthenticationSettingsInfo")
            .getter(getter(DescribeClientAuthenticationSettingsResponse::clientAuthenticationSettingsInfo))
            .setter(setter(Builder::clientAuthenticationSettingsInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientAuthenticationSettingsInfo")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ClientAuthenticationSettingInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(ClientAuthenticationSettingInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeClientAuthenticationSettingsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CLIENT_AUTHENTICATION_SETTINGS_INFO_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ClientAuthenticationSettingsInfo", CLIENT_AUTHENTICATION_SETTINGS_INFO_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final List<ClientAuthenticationSettingInfo> clientAuthenticationSettingsInfo;

    private final String nextToken;

    private DescribeClientAuthenticationSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.clientAuthenticationSettingsInfo = builder.clientAuthenticationSettingsInfo;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ClientAuthenticationSettingsInfo
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasClientAuthenticationSettingsInfo() {
        return clientAuthenticationSettingsInfo != null && !(clientAuthenticationSettingsInfo instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the type of client authentication for the specified directory. The following information is
     * retrieved: The date and time when the status of the client authentication type was last updated, whether the
     * client authentication type is enabled or disabled, and the type of client authentication.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClientAuthenticationSettingsInfo}
     * method.
     * </p>
     * 
     * @return Information about the type of client authentication for the specified directory. The following
     *         information is retrieved: The date and time when the status of the client authentication type was last
     *         updated, whether the client authentication type is enabled or disabled, and the type of client
     *         authentication.
     */
    public final List<ClientAuthenticationSettingInfo> clientAuthenticationSettingsInfo() {
        return clientAuthenticationSettingsInfo;
    }

    /**
     * <p>
     * The next token used to retrieve the client authentication settings if the number of setting types exceeds page
     * limit and there is another page.
     * </p>
     * 
     * @return The next token used to retrieve the client authentication settings if the number of setting types exceeds
     *         page limit and there is another page.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasClientAuthenticationSettingsInfo() ? clientAuthenticationSettingsInfo() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClientAuthenticationSettingsResponse)) {
            return false;
        }
        DescribeClientAuthenticationSettingsResponse other = (DescribeClientAuthenticationSettingsResponse) obj;
        return hasClientAuthenticationSettingsInfo() == other.hasClientAuthenticationSettingsInfo()
                && Objects.equals(clientAuthenticationSettingsInfo(), other.clientAuthenticationSettingsInfo())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DescribeClientAuthenticationSettingsResponse")
                .add("ClientAuthenticationSettingsInfo",
                        hasClientAuthenticationSettingsInfo() ? clientAuthenticationSettingsInfo() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientAuthenticationSettingsInfo":
            return Optional.ofNullable(clazz.cast(clientAuthenticationSettingsInfo()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeClientAuthenticationSettingsResponse, T> g) {
        return obj -> g.apply((DescribeClientAuthenticationSettingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectoryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeClientAuthenticationSettingsResponse> {
        /**
         * <p>
         * Information about the type of client authentication for the specified directory. The following information is
         * retrieved: The date and time when the status of the client authentication type was last updated, whether the
         * client authentication type is enabled or disabled, and the type of client authentication.
         * </p>
         * 
         * @param clientAuthenticationSettingsInfo
         *        Information about the type of client authentication for the specified directory. The following
         *        information is retrieved: The date and time when the status of the client authentication type was last
         *        updated, whether the client authentication type is enabled or disabled, and the type of client
         *        authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientAuthenticationSettingsInfo(Collection<ClientAuthenticationSettingInfo> clientAuthenticationSettingsInfo);

        /**
         * <p>
         * Information about the type of client authentication for the specified directory. The following information is
         * retrieved: The date and time when the status of the client authentication type was last updated, whether the
         * client authentication type is enabled or disabled, and the type of client authentication.
         * </p>
         * 
         * @param clientAuthenticationSettingsInfo
         *        Information about the type of client authentication for the specified directory. The following
         *        information is retrieved: The date and time when the status of the client authentication type was last
         *        updated, whether the client authentication type is enabled or disabled, and the type of client
         *        authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientAuthenticationSettingsInfo(ClientAuthenticationSettingInfo... clientAuthenticationSettingsInfo);

        /**
         * <p>
         * Information about the type of client authentication for the specified directory. The following information is
         * retrieved: The date and time when the status of the client authentication type was last updated, whether the
         * client authentication type is enabled or disabled, and the type of client authentication.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.directory.model.ClientAuthenticationSettingInfo.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.directory.model.ClientAuthenticationSettingInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.directory.model.ClientAuthenticationSettingInfo.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #clientAuthenticationSettingsInfo(List<ClientAuthenticationSettingInfo>)}.
         * 
         * @param clientAuthenticationSettingsInfo
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.directory.model.ClientAuthenticationSettingInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clientAuthenticationSettingsInfo(java.util.Collection<ClientAuthenticationSettingInfo>)
         */
        Builder clientAuthenticationSettingsInfo(
                Consumer<ClientAuthenticationSettingInfo.Builder>... clientAuthenticationSettingsInfo);

        /**
         * <p>
         * The next token used to retrieve the client authentication settings if the number of setting types exceeds
         * page limit and there is another page.
         * </p>
         * 
         * @param nextToken
         *        The next token used to retrieve the client authentication settings if the number of setting types
         *        exceeds page limit and there is another page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DirectoryResponse.BuilderImpl implements Builder {
        private List<ClientAuthenticationSettingInfo> clientAuthenticationSettingsInfo = DefaultSdkAutoConstructList
                .getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClientAuthenticationSettingsResponse model) {
            super(model);
            clientAuthenticationSettingsInfo(model.clientAuthenticationSettingsInfo);
            nextToken(model.nextToken);
        }

        public final List<ClientAuthenticationSettingInfo.Builder> getClientAuthenticationSettingsInfo() {
            List<ClientAuthenticationSettingInfo.Builder> result = ClientAuthenticationSettingsInfoCopier
                    .copyToBuilder(this.clientAuthenticationSettingsInfo);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClientAuthenticationSettingsInfo(
                Collection<ClientAuthenticationSettingInfo.BuilderImpl> clientAuthenticationSettingsInfo) {
            this.clientAuthenticationSettingsInfo = ClientAuthenticationSettingsInfoCopier
                    .copyFromBuilder(clientAuthenticationSettingsInfo);
        }

        @Override
        public final Builder clientAuthenticationSettingsInfo(
                Collection<ClientAuthenticationSettingInfo> clientAuthenticationSettingsInfo) {
            this.clientAuthenticationSettingsInfo = ClientAuthenticationSettingsInfoCopier.copy(clientAuthenticationSettingsInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientAuthenticationSettingsInfo(ClientAuthenticationSettingInfo... clientAuthenticationSettingsInfo) {
            clientAuthenticationSettingsInfo(Arrays.asList(clientAuthenticationSettingsInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientAuthenticationSettingsInfo(
                Consumer<ClientAuthenticationSettingInfo.Builder>... clientAuthenticationSettingsInfo) {
            clientAuthenticationSettingsInfo(Stream.of(clientAuthenticationSettingsInfo)
                    .map(c -> ClientAuthenticationSettingInfo.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeClientAuthenticationSettingsResponse build() {
            return new DescribeClientAuthenticationSettingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
