/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Deletes a conditional forwarder.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteConditionalForwarderRequest extends DirectoryRequest implements
        ToCopyableBuilder<DeleteConditionalForwarderRequest.Builder, DeleteConditionalForwarderRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(DeleteConditionalForwarderRequest::directoryId))
            .setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<String> REMOTE_DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RemoteDomainName").getter(getter(DeleteConditionalForwarderRequest::remoteDomainName))
            .setter(setter(Builder::remoteDomainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoteDomainName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD,
            REMOTE_DOMAIN_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("DirectoryId", DIRECTORY_ID_FIELD);
                    put("RemoteDomainName", REMOTE_DOMAIN_NAME_FIELD);
                }
            });

    private final String directoryId;

    private final String remoteDomainName;

    private DeleteConditionalForwarderRequest(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.remoteDomainName = builder.remoteDomainName;
    }

    /**
     * <p>
     * The directory ID for which you are deleting the conditional forwarder.
     * </p>
     * 
     * @return The directory ID for which you are deleting the conditional forwarder.
     */
    public final String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * The fully qualified domain name (FQDN) of the remote domain with which you are deleting the conditional
     * forwarder.
     * </p>
     * 
     * @return The fully qualified domain name (FQDN) of the remote domain with which you are deleting the conditional
     *         forwarder.
     */
    public final String remoteDomainName() {
        return remoteDomainName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(remoteDomainName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteConditionalForwarderRequest)) {
            return false;
        }
        DeleteConditionalForwarderRequest other = (DeleteConditionalForwarderRequest) obj;
        return Objects.equals(directoryId(), other.directoryId()) && Objects.equals(remoteDomainName(), other.remoteDomainName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteConditionalForwarderRequest").add("DirectoryId", directoryId())
                .add("RemoteDomainName", remoteDomainName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "RemoteDomainName":
            return Optional.ofNullable(clazz.cast(remoteDomainName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeleteConditionalForwarderRequest, T> g) {
        return obj -> g.apply((DeleteConditionalForwarderRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectoryRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteConditionalForwarderRequest> {
        /**
         * <p>
         * The directory ID for which you are deleting the conditional forwarder.
         * </p>
         * 
         * @param directoryId
         *        The directory ID for which you are deleting the conditional forwarder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * The fully qualified domain name (FQDN) of the remote domain with which you are deleting the conditional
         * forwarder.
         * </p>
         * 
         * @param remoteDomainName
         *        The fully qualified domain name (FQDN) of the remote domain with which you are deleting the
         *        conditional forwarder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteDomainName(String remoteDomainName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectoryRequest.BuilderImpl implements Builder {
        private String directoryId;

        private String remoteDomainName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteConditionalForwarderRequest model) {
            super(model);
            directoryId(model.directoryId);
            remoteDomainName(model.remoteDomainName);
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getRemoteDomainName() {
            return remoteDomainName;
        }

        public final void setRemoteDomainName(String remoteDomainName) {
            this.remoteDomainName = remoteDomainName;
        }

        @Override
        public final Builder remoteDomainName(String remoteDomainName) {
            this.remoteDomainName = remoteDomainName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteConditionalForwarderRequest build() {
            return new DeleteConditionalForwarderRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
